/*
 * Decompiled with CFR 0.152.
 */
package com.centeredwork.xilize;

import bsh.EvalError;
import bsh.TargetError;
import com.centeredwork.xilize.BeanShell;
import com.centeredwork.xilize.Block;
import com.centeredwork.xilize.Env;
import com.centeredwork.xilize.Modifiers;
import com.centeredwork.xilize.Regex;
import com.centeredwork.xilize.Task;
import java.io.File;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InlineMarkup {
    private static final String XIL_KEY = "`xil%";
    private static final String XIL_END = "%xil`";
    private static final String AMP_SUB = "q%`q%";
    private static final String PHRASE_TERMINATOR = "(?=$|<|`|\\s|([\\.,;:!\\?](\\s|$)))";
    private static final String CLASS = "\\(\\w*?(#\\w+)?\\)";
    private static final String ATTR = "\\{\\{[\\S &&[^{}]]+\\}\\}";
    private static final String STYLE = "\\{[\\S &&[^}]]+\\}";
    private static final String SYMS = "-|\\^|~|&lt;|&gt;|\\(+|\\)+";
    private static final String MODS_REGEX = "(-|\\^|~|&lt;|&gt;|\\(+|\\)+|\\(\\w*?(#\\w+)?\\)|\\{\\{[\\S &&[^{}]]+\\}\\}|\\{[\\S &&[^}]]+\\})+";
    private static final String MODS = "((-|\\^|~|&lt;|&gt;|\\(+|\\)+|\\(\\w*?(#\\w+)?\\)|\\{\\{[\\S &&[^{}]]+\\}\\}|\\{[\\S &&[^}]]+\\})+ )?";
    private static final String SYMS_IMG = "-|\\^|~|<|>|\\(+|\\)+";
    private static final String MODS_IMG = "((-|\\^|~|<|>|\\(+|\\)+|\\(\\w*?(#\\w+)?\\)|\\{\\{[\\S &&[^{}]]+\\}\\}|\\{[\\S &&[^}]]+\\})+ )?";
    private static final String PREFIX_REGEX = "(?sm)(^|[\\s>`])";
    private static final String LINK_REGEX = "([^(\"]+?)";
    private static final String LINK_EMB_REGEX = "([^(]+?)";
    private static final String TITLE_REGEX = "( *\\(([^)\n]+?)\\))?";
    private static final String LINK_TITLE_REGEX = "([^(\"]+?)( *\\(([^)\n]+?)\\))?";
    private static final String LINK_TITLE_EMB_REGEX = "([^(]+?)( *\\(([^)\n]+?)\\))?";
    private static final String URL_REGEX = "(\\S+?)";
    private static final String URL_TITLE_REGEX = "(\\S+?)( *\\(([^)\n]+?)\\))?";
    private static final String HTML_TAG_NAME = "A|ABBR|ACRONYM|ADDRESS|APPLET|AREA|B|BASE|BASEFONT|BDO|BIG|BLOCKQUOTE|BODY|BR|BUTTON|CAPTION|CENTER|CITE|CODE|COL|COLGROUP|DD|DEL|DFN|DIR|DIV|DL|DT|EM|FIELDSET|FONT|FORM|FRAME|FRAMESET|H1|H2|H3|H4|H5|H6|HEAD|HR|HTML|I|IFRAME|IMG|INPUT|INS|ISINDEX|KBD|LABEL|LEGEND|LI|LINK|MAP|MENU|META|NOFRAMES|NOSCRIPT|OBJECT|OL|OPTGROUP|OPTION|P|PARAM|PRE|Q|S|SAMP|SCRIPT|SELECT|SMALL|SPAN|STRIKE|STRONG|STYLE|SUB|SUP|TABLE|TBODY|TD|TEXTAREA|TFOOT|TH|THEAD|TITLE|TR|TT|U|UL|VAR|a|abbr|acronym|address|applet|area|b|base|basefont|bdo|big|blockquote|body|br|button|caption|center|cite|code|col|colgroup|dd|del|dfn|dir|div|dl|dt|em|fieldset|font|form|frame|frameset|h1|h2|h3|h4|h5|h6|head|hr|html|i|iframe|img|input|ins|isindex|kbd|label|legend|li|link|map|menu|meta|noframes|noscript|object|ol|optgroup|option|p|param|pre|q|s|samp|script|select|small|span|strike|strong|style|sub|sup|table|tbody|td|textarea|tfoot|th|thead|title|tr|tt|u|ul|var";
    private static final String HTML = "(<(A|ABBR|ACRONYM|ADDRESS|APPLET|AREA|B|BASE|BASEFONT|BDO|BIG|BLOCKQUOTE|BODY|BR|BUTTON|CAPTION|CENTER|CITE|CODE|COL|COLGROUP|DD|DEL|DFN|DIR|DIV|DL|DT|EM|FIELDSET|FONT|FORM|FRAME|FRAMESET|H1|H2|H3|H4|H5|H6|HEAD|HR|HTML|I|IFRAME|IMG|INPUT|INS|ISINDEX|KBD|LABEL|LEGEND|LI|LINK|MAP|MENU|META|NOFRAMES|NOSCRIPT|OBJECT|OL|OPTGROUP|OPTION|P|PARAM|PRE|Q|S|SAMP|SCRIPT|SELECT|SMALL|SPAN|STRIKE|STRONG|STYLE|SUB|SUP|TABLE|TBODY|TD|TEXTAREA|TFOOT|TH|THEAD|TITLE|TR|TT|U|UL|VAR|a|abbr|acronym|address|applet|area|b|base|basefont|bdo|big|blockquote|body|br|button|caption|center|cite|code|col|colgroup|dd|del|dfn|dir|div|dl|dt|em|fieldset|font|form|frame|frameset|h1|h2|h3|h4|h5|h6|head|hr|html|i|iframe|img|input|ins|isindex|kbd|label|legend|li|link|map|menu|meta|noframes|noscript|object|ol|optgroup|option|p|param|pre|q|s|samp|script|select|small|span|strike|strong|style|sub|sup|table|tbody|td|textarea|tfoot|th|thead|title|tr|tt|u|ul|var)(\\s+\\S+\\s*?=\\s*?\".*?\")*(\\s*?/?)>|</(A|ABBR|ACRONYM|ADDRESS|APPLET|AREA|B|BASE|BASEFONT|BDO|BIG|BLOCKQUOTE|BODY|BR|BUTTON|CAPTION|CENTER|CITE|CODE|COL|COLGROUP|DD|DEL|DFN|DIR|DIV|DL|DT|EM|FIELDSET|FONT|FORM|FRAME|FRAMESET|H1|H2|H3|H4|H5|H6|HEAD|HR|HTML|I|IFRAME|IMG|INPUT|INS|ISINDEX|KBD|LABEL|LEGEND|LI|LINK|MAP|MENU|META|NOFRAMES|NOSCRIPT|OBJECT|OL|OPTGROUP|OPTION|P|PARAM|PRE|Q|S|SAMP|SCRIPT|SELECT|SMALL|SPAN|STRIKE|STRONG|STYLE|SUB|SUP|TABLE|TBODY|TD|TEXTAREA|TFOOT|TH|THEAD|TITLE|TR|TT|U|UL|VAR|a|abbr|acronym|address|applet|area|b|base|basefont|bdo|big|blockquote|body|br|button|caption|center|cite|code|col|colgroup|dd|del|dfn|dir|div|dl|dt|em|fieldset|font|form|frame|frameset|h1|h2|h3|h4|h5|h6|head|hr|html|i|iframe|img|input|ins|isindex|kbd|label|legend|li|link|map|menu|meta|noframes|noscript|object|ol|optgroup|option|p|param|pre|q|s|samp|script|select|small|span|strike|strong|style|sub|sup|table|tbody|td|textarea|tfoot|th|thead|title|tr|tt|u|ul|var)\\s*?>)";
    private static final String XML = "(<\\?xml.*?\\?>)";
    private static final String DOCTYPE = "(<!DOCTYPE\\s.*?>)";
    private static final String HTML_COMMENT = "(<!--\\s(.*?\\s)-->)";
    private static final String EXISTING_MARKUP_ELEMENT = "((<(A|ABBR|ACRONYM|ADDRESS|APPLET|AREA|B|BASE|BASEFONT|BDO|BIG|BLOCKQUOTE|BODY|BR|BUTTON|CAPTION|CENTER|CITE|CODE|COL|COLGROUP|DD|DEL|DFN|DIR|DIV|DL|DT|EM|FIELDSET|FONT|FORM|FRAME|FRAMESET|H1|H2|H3|H4|H5|H6|HEAD|HR|HTML|I|IFRAME|IMG|INPUT|INS|ISINDEX|KBD|LABEL|LEGEND|LI|LINK|MAP|MENU|META|NOFRAMES|NOSCRIPT|OBJECT|OL|OPTGROUP|OPTION|P|PARAM|PRE|Q|S|SAMP|SCRIPT|SELECT|SMALL|SPAN|STRIKE|STRONG|STYLE|SUB|SUP|TABLE|TBODY|TD|TEXTAREA|TFOOT|TH|THEAD|TITLE|TR|TT|U|UL|VAR|a|abbr|acronym|address|applet|area|b|base|basefont|bdo|big|blockquote|body|br|button|caption|center|cite|code|col|colgroup|dd|del|dfn|dir|div|dl|dt|em|fieldset|font|form|frame|frameset|h1|h2|h3|h4|h5|h6|head|hr|html|i|iframe|img|input|ins|isindex|kbd|label|legend|li|link|map|menu|meta|noframes|noscript|object|ol|optgroup|option|p|param|pre|q|s|samp|script|select|small|span|strike|strong|style|sub|sup|table|tbody|td|textarea|tfoot|th|thead|title|tr|tt|u|ul|var)(\\s+\\S+\\s*?=\\s*?\".*?\")*(\\s*?/?)>|</(A|ABBR|ACRONYM|ADDRESS|APPLET|AREA|B|BASE|BASEFONT|BDO|BIG|BLOCKQUOTE|BODY|BR|BUTTON|CAPTION|CENTER|CITE|CODE|COL|COLGROUP|DD|DEL|DFN|DIR|DIV|DL|DT|EM|FIELDSET|FONT|FORM|FRAME|FRAMESET|H1|H2|H3|H4|H5|H6|HEAD|HR|HTML|I|IFRAME|IMG|INPUT|INS|ISINDEX|KBD|LABEL|LEGEND|LI|LINK|MAP|MENU|META|NOFRAMES|NOSCRIPT|OBJECT|OL|OPTGROUP|OPTION|P|PARAM|PRE|Q|S|SAMP|SCRIPT|SELECT|SMALL|SPAN|STRIKE|STRONG|STYLE|SUB|SUP|TABLE|TBODY|TD|TEXTAREA|TFOOT|TH|THEAD|TITLE|TR|TT|U|UL|VAR|a|abbr|acronym|address|applet|area|b|base|basefont|bdo|big|blockquote|body|br|button|caption|center|cite|code|col|colgroup|dd|del|dfn|dir|div|dl|dt|em|fieldset|font|form|frame|frameset|h1|h2|h3|h4|h5|h6|head|hr|html|i|iframe|img|input|ins|isindex|kbd|label|legend|li|link|map|menu|meta|noframes|noscript|object|ol|optgroup|option|p|param|pre|q|s|samp|script|select|small|span|strike|strong|style|sub|sup|table|tbody|td|textarea|tfoot|th|thead|title|tr|tt|u|ul|var)\\s*?>)|(<!--\\s(.*?\\s)-->)|(<\\?xml.*?\\?>)|(<!DOCTYPE\\s.*?>))";
    private static final String EXISTING_MARKUP = "((<(A|ABBR|ACRONYM|ADDRESS|APPLET|AREA|B|BASE|BASEFONT|BDO|BIG|BLOCKQUOTE|BODY|BR|BUTTON|CAPTION|CENTER|CITE|CODE|COL|COLGROUP|DD|DEL|DFN|DIR|DIV|DL|DT|EM|FIELDSET|FONT|FORM|FRAME|FRAMESET|H1|H2|H3|H4|H5|H6|HEAD|HR|HTML|I|IFRAME|IMG|INPUT|INS|ISINDEX|KBD|LABEL|LEGEND|LI|LINK|MAP|MENU|META|NOFRAMES|NOSCRIPT|OBJECT|OL|OPTGROUP|OPTION|P|PARAM|PRE|Q|S|SAMP|SCRIPT|SELECT|SMALL|SPAN|STRIKE|STRONG|STYLE|SUB|SUP|TABLE|TBODY|TD|TEXTAREA|TFOOT|TH|THEAD|TITLE|TR|TT|U|UL|VAR|a|abbr|acronym|address|applet|area|b|base|basefont|bdo|big|blockquote|body|br|button|caption|center|cite|code|col|colgroup|dd|del|dfn|dir|div|dl|dt|em|fieldset|font|form|frame|frameset|h1|h2|h3|h4|h5|h6|head|hr|html|i|iframe|img|input|ins|isindex|kbd|label|legend|li|link|map|menu|meta|noframes|noscript|object|ol|optgroup|option|p|param|pre|q|s|samp|script|select|small|span|strike|strong|style|sub|sup|table|tbody|td|textarea|tfoot|th|thead|title|tr|tt|u|ul|var)(\\s+\\S+\\s*?=\\s*?\".*?\")*(\\s*?/?)>|</(A|ABBR|ACRONYM|ADDRESS|APPLET|AREA|B|BASE|BASEFONT|BDO|BIG|BLOCKQUOTE|BODY|BR|BUTTON|CAPTION|CENTER|CITE|CODE|COL|COLGROUP|DD|DEL|DFN|DIR|DIV|DL|DT|EM|FIELDSET|FONT|FORM|FRAME|FRAMESET|H1|H2|H3|H4|H5|H6|HEAD|HR|HTML|I|IFRAME|IMG|INPUT|INS|ISINDEX|KBD|LABEL|LEGEND|LI|LINK|MAP|MENU|META|NOFRAMES|NOSCRIPT|OBJECT|OL|OPTGROUP|OPTION|P|PARAM|PRE|Q|S|SAMP|SCRIPT|SELECT|SMALL|SPAN|STRIKE|STRONG|STYLE|SUB|SUP|TABLE|TBODY|TD|TEXTAREA|TFOOT|TH|THEAD|TITLE|TR|TT|U|UL|VAR|a|abbr|acronym|address|applet|area|b|base|basefont|bdo|big|blockquote|body|br|button|caption|center|cite|code|col|colgroup|dd|del|dfn|dir|div|dl|dt|em|fieldset|font|form|frame|frameset|h1|h2|h3|h4|h5|h6|head|hr|html|i|iframe|img|input|ins|isindex|kbd|label|legend|li|link|map|menu|meta|noframes|noscript|object|ol|optgroup|option|p|param|pre|q|s|samp|script|select|small|span|strike|strong|style|sub|sup|table|tbody|td|textarea|tfoot|th|thead|title|tr|tt|u|ul|var)\\s*?>)|(<!--\\s(.*?\\s)-->)|(<\\?xml.*?\\?>)|(<!DOCTYPE\\s.*?>))(\\s*((<(A|ABBR|ACRONYM|ADDRESS|APPLET|AREA|B|BASE|BASEFONT|BDO|BIG|BLOCKQUOTE|BODY|BR|BUTTON|CAPTION|CENTER|CITE|CODE|COL|COLGROUP|DD|DEL|DFN|DIR|DIV|DL|DT|EM|FIELDSET|FONT|FORM|FRAME|FRAMESET|H1|H2|H3|H4|H5|H6|HEAD|HR|HTML|I|IFRAME|IMG|INPUT|INS|ISINDEX|KBD|LABEL|LEGEND|LI|LINK|MAP|MENU|META|NOFRAMES|NOSCRIPT|OBJECT|OL|OPTGROUP|OPTION|P|PARAM|PRE|Q|S|SAMP|SCRIPT|SELECT|SMALL|SPAN|STRIKE|STRONG|STYLE|SUB|SUP|TABLE|TBODY|TD|TEXTAREA|TFOOT|TH|THEAD|TITLE|TR|TT|U|UL|VAR|a|abbr|acronym|address|applet|area|b|base|basefont|bdo|big|blockquote|body|br|button|caption|center|cite|code|col|colgroup|dd|del|dfn|dir|div|dl|dt|em|fieldset|font|form|frame|frameset|h1|h2|h3|h4|h5|h6|head|hr|html|i|iframe|img|input|ins|isindex|kbd|label|legend|li|link|map|menu|meta|noframes|noscript|object|ol|optgroup|option|p|param|pre|q|s|samp|script|select|small|span|strike|strong|style|sub|sup|table|tbody|td|textarea|tfoot|th|thead|title|tr|tt|u|ul|var)(\\s+\\S+\\s*?=\\s*?\".*?\")*(\\s*?/?)>|</(A|ABBR|ACRONYM|ADDRESS|APPLET|AREA|B|BASE|BASEFONT|BDO|BIG|BLOCKQUOTE|BODY|BR|BUTTON|CAPTION|CENTER|CITE|CODE|COL|COLGROUP|DD|DEL|DFN|DIR|DIV|DL|DT|EM|FIELDSET|FONT|FORM|FRAME|FRAMESET|H1|H2|H3|H4|H5|H6|HEAD|HR|HTML|I|IFRAME|IMG|INPUT|INS|ISINDEX|KBD|LABEL|LEGEND|LI|LINK|MAP|MENU|META|NOFRAMES|NOSCRIPT|OBJECT|OL|OPTGROUP|OPTION|P|PARAM|PRE|Q|S|SAMP|SCRIPT|SELECT|SMALL|SPAN|STRIKE|STRONG|STYLE|SUB|SUP|TABLE|TBODY|TD|TEXTAREA|TFOOT|TH|THEAD|TITLE|TR|TT|U|UL|VAR|a|abbr|acronym|address|applet|area|b|base|basefont|bdo|big|blockquote|body|br|button|caption|center|cite|code|col|colgroup|dd|del|dfn|dir|div|dl|dt|em|fieldset|font|form|frame|frameset|h1|h2|h3|h4|h5|h6|head|hr|html|i|iframe|img|input|ins|isindex|kbd|label|legend|li|link|map|menu|meta|noframes|noscript|object|ol|optgroup|option|p|param|pre|q|s|samp|script|select|small|span|strike|strong|style|sub|sup|table|tbody|td|textarea|tfoot|th|thead|title|tr|tt|u|ul|var)\\s*?>)|(<!--\\s(.*?\\s)-->)|(<\\?xml.*?\\?>)|(<!DOCTYPE\\s.*?>)))*";
    private static Regex.Special keyValueSubTrans = new Regex.Special("${", "(?sm)(\\$\\{)([a-zA-Z_][a-zA-Z_0-9\\.-]*)(\\})", new Regex.Trans(){

        public void apply(Task task, StringBuilder stringBuilder, Matcher matcher) {
            String string = matcher.group(2);
            if (task.isDefined(string)) {
                stringBuilder.append(task.value(string));
            } else {
                stringBuilder.append(matcher.group(0));
            }
        }
    });
    private static Regex.Special execMacrosTrans = new Regex.Special("&{", "(?sm)(?:\\&\\{)(?: *(\\w(?:\\w|[0-9])*) *:)?([^\\}]+)(?:\\})", new Regex.Trans(){

        public void apply(Task task, StringBuilder stringBuilder, Matcher matcher) {
            BeanShell beanShell = task.getBsh();
            try {
                beanShell.set("task", task);
                if (matcher.group(1) == null) {
                    stringBuilder.append(beanShell.eval(matcher.group(2)).toString());
                } else {
                    beanShell.set("text", matcher.group(2));
                    stringBuilder.append(beanShell.eval(matcher.group(1) + "();").toString());
                }
            }
            catch (EvalError evalError) {
                String string = null;
                if (evalError instanceof TargetError) {
                    TargetError targetError = (TargetError)evalError;
                    string = targetError.printTargetError(targetError.getTarget());
                } else {
                    string = evalError.getMessage();
                }
                int n = 0;
                String string2 = evalError.getErrorSourceFile();
                File file = new File(string2);
                if (file.exists()) {
                    n = evalError.getErrorLineNumber();
                    string2 = file.getAbsolutePath();
                } else {
                    Matcher matcher2 = Pattern.compile("error at line (\\d+)").matcher(string);
                    if (matcher2.find()) {
                        n = new Integer(matcher2.group(1));
                    }
                    string2 = null;
                }
                if (string2 != null) {
                    task.error(string2 + ":" + n + ":" + string);
                }
                task.error(n, string);
                stringBuilder.append("==!!MACRO ERROR!!==");
            }
            catch (Throwable throwable) {
                task.error(0, "macro error: " + throwable.getMessage());
                stringBuilder.append("==!!MACRO ERROR!!==");
            }
        }
    });
    private static Pattern NO_MOD_PATTERN = Pattern.compile("(?sm)(^|\\s)==(\\S|(\\S.*?\\S))==(?=$|<|`|\\s|([\\.,;:!\\?](\\s|$)))");
    private Regex.Special noModTrans = new Regex.Special("==", NO_MOD_PATTERN, new Regex.Trans(){

        public void apply(Task task, StringBuilder stringBuilder, Matcher matcher) {
            stringBuilder.append(matcher.group(1));
            InlineMarkup.this.storeSnippet(stringBuilder, matcher.group(2));
        }
    });
    private static Pattern NO_MOD_EMBEDDED_PATTERN = Pattern.compile("(?sm)\\[==(\\S|(\\S.*?\\S))==\\]");
    private Regex.Special noModEmbeddedTrans = new Regex.Special("[==", NO_MOD_EMBEDDED_PATTERN, new Regex.Trans(){

        public void apply(Task task, StringBuilder stringBuilder, Matcher matcher) {
            InlineMarkup.this.storeSnippet(stringBuilder, matcher.group(1));
        }
    });
    private static Pattern CODE_PATTERN = Pattern.compile("(?s)(^|\\s)@(\\S{1,2}|(\\S[^@]+?\\S))@(?=$|<|`|\\s|([\\.,;:!\\?](\\s|$)))");
    private Regex.Special codeTrans = new Regex.Special("@", CODE_PATTERN, new Regex.Trans(){

        public void apply(Task task, StringBuilder stringBuilder, Matcher matcher) {
            stringBuilder.append(matcher.group(1));
            InlineMarkup.this.storeSnippet(stringBuilder, InlineMarkup.this.flowCode(matcher.group(2)));
        }
    });
    private static Pattern CODE_EMBEDDED_PATTERN = Pattern.compile("(?s)\\[@(.+?)@\\]");
    private Regex.Special codeEmbeddedTrans = new Regex.Special("[@", CODE_EMBEDDED_PATTERN, new Regex.Trans(){

        public void apply(Task task, StringBuilder stringBuilder, Matcher matcher) {
            InlineMarkup.this.storeSnippet(stringBuilder, InlineMarkup.this.flowCode(matcher.group(1)));
        }
    });
    private static Pattern EXISITING_MARKUP_PATTERN = Pattern.compile("((<(A|ABBR|ACRONYM|ADDRESS|APPLET|AREA|B|BASE|BASEFONT|BDO|BIG|BLOCKQUOTE|BODY|BR|BUTTON|CAPTION|CENTER|CITE|CODE|COL|COLGROUP|DD|DEL|DFN|DIR|DIV|DL|DT|EM|FIELDSET|FONT|FORM|FRAME|FRAMESET|H1|H2|H3|H4|H5|H6|HEAD|HR|HTML|I|IFRAME|IMG|INPUT|INS|ISINDEX|KBD|LABEL|LEGEND|LI|LINK|MAP|MENU|META|NOFRAMES|NOSCRIPT|OBJECT|OL|OPTGROUP|OPTION|P|PARAM|PRE|Q|S|SAMP|SCRIPT|SELECT|SMALL|SPAN|STRIKE|STRONG|STYLE|SUB|SUP|TABLE|TBODY|TD|TEXTAREA|TFOOT|TH|THEAD|TITLE|TR|TT|U|UL|VAR|a|abbr|acronym|address|applet|area|b|base|basefont|bdo|big|blockquote|body|br|button|caption|center|cite|code|col|colgroup|dd|del|dfn|dir|div|dl|dt|em|fieldset|font|form|frame|frameset|h1|h2|h3|h4|h5|h6|head|hr|html|i|iframe|img|input|ins|isindex|kbd|label|legend|li|link|map|menu|meta|noframes|noscript|object|ol|optgroup|option|p|param|pre|q|s|samp|script|select|small|span|strike|strong|style|sub|sup|table|tbody|td|textarea|tfoot|th|thead|title|tr|tt|u|ul|var)(\\s+\\S+\\s*?=\\s*?\".*?\")*(\\s*?/?)>|</(A|ABBR|ACRONYM|ADDRESS|APPLET|AREA|B|BASE|BASEFONT|BDO|BIG|BLOCKQUOTE|BODY|BR|BUTTON|CAPTION|CENTER|CITE|CODE|COL|COLGROUP|DD|DEL|DFN|DIR|DIV|DL|DT|EM|FIELDSET|FONT|FORM|FRAME|FRAMESET|H1|H2|H3|H4|H5|H6|HEAD|HR|HTML|I|IFRAME|IMG|INPUT|INS|ISINDEX|KBD|LABEL|LEGEND|LI|LINK|MAP|MENU|META|NOFRAMES|NOSCRIPT|OBJECT|OL|OPTGROUP|OPTION|P|PARAM|PRE|Q|S|SAMP|SCRIPT|SELECT|SMALL|SPAN|STRIKE|STRONG|STYLE|SUB|SUP|TABLE|TBODY|TD|TEXTAREA|TFOOT|TH|THEAD|TITLE|TR|TT|U|UL|VAR|a|abbr|acronym|address|applet|area|b|base|basefont|bdo|big|blockquote|body|br|button|caption|center|cite|code|col|colgroup|dd|del|dfn|dir|div|dl|dt|em|fieldset|font|form|frame|frameset|h1|h2|h3|h4|h5|h6|head|hr|html|i|iframe|img|input|ins|isindex|kbd|label|legend|li|link|map|menu|meta|noframes|noscript|object|ol|optgroup|option|p|param|pre|q|s|samp|script|select|small|span|strike|strong|style|sub|sup|table|tbody|td|textarea|tfoot|th|thead|title|tr|tt|u|ul|var)\\s*?>)|(<!--\\s(.*?\\s)-->)|(<\\?xml.*?\\?>)|(<!DOCTYPE\\s.*?>))(\\s*((<(A|ABBR|ACRONYM|ADDRESS|APPLET|AREA|B|BASE|BASEFONT|BDO|BIG|BLOCKQUOTE|BODY|BR|BUTTON|CAPTION|CENTER|CITE|CODE|COL|COLGROUP|DD|DEL|DFN|DIR|DIV|DL|DT|EM|FIELDSET|FONT|FORM|FRAME|FRAMESET|H1|H2|H3|H4|H5|H6|HEAD|HR|HTML|I|IFRAME|IMG|INPUT|INS|ISINDEX|KBD|LABEL|LEGEND|LI|LINK|MAP|MENU|META|NOFRAMES|NOSCRIPT|OBJECT|OL|OPTGROUP|OPTION|P|PARAM|PRE|Q|S|SAMP|SCRIPT|SELECT|SMALL|SPAN|STRIKE|STRONG|STYLE|SUB|SUP|TABLE|TBODY|TD|TEXTAREA|TFOOT|TH|THEAD|TITLE|TR|TT|U|UL|VAR|a|abbr|acronym|address|applet|area|b|base|basefont|bdo|big|blockquote|body|br|button|caption|center|cite|code|col|colgroup|dd|del|dfn|dir|div|dl|dt|em|fieldset|font|form|frame|frameset|h1|h2|h3|h4|h5|h6|head|hr|html|i|iframe|img|input|ins|isindex|kbd|label|legend|li|link|map|menu|meta|noframes|noscript|object|ol|optgroup|option|p|param|pre|q|s|samp|script|select|small|span|strike|strong|style|sub|sup|table|tbody|td|textarea|tfoot|th|thead|title|tr|tt|u|ul|var)(\\s+\\S+\\s*?=\\s*?\".*?\")*(\\s*?/?)>|</(A|ABBR|ACRONYM|ADDRESS|APPLET|AREA|B|BASE|BASEFONT|BDO|BIG|BLOCKQUOTE|BODY|BR|BUTTON|CAPTION|CENTER|CITE|CODE|COL|COLGROUP|DD|DEL|DFN|DIR|DIV|DL|DT|EM|FIELDSET|FONT|FORM|FRAME|FRAMESET|H1|H2|H3|H4|H5|H6|HEAD|HR|HTML|I|IFRAME|IMG|INPUT|INS|ISINDEX|KBD|LABEL|LEGEND|LI|LINK|MAP|MENU|META|NOFRAMES|NOSCRIPT|OBJECT|OL|OPTGROUP|OPTION|P|PARAM|PRE|Q|S|SAMP|SCRIPT|SELECT|SMALL|SPAN|STRIKE|STRONG|STYLE|SUB|SUP|TABLE|TBODY|TD|TEXTAREA|TFOOT|TH|THEAD|TITLE|TR|TT|U|UL|VAR|a|abbr|acronym|address|applet|area|b|base|basefont|bdo|big|blockquote|body|br|button|caption|center|cite|code|col|colgroup|dd|del|dfn|dir|div|dl|dt|em|fieldset|font|form|frame|frameset|h1|h2|h3|h4|h5|h6|head|hr|html|i|iframe|img|input|ins|isindex|kbd|label|legend|li|link|map|menu|meta|noframes|noscript|object|ol|optgroup|option|p|param|pre|q|s|samp|script|select|small|span|strike|strong|style|sub|sup|table|tbody|td|textarea|tfoot|th|thead|title|tr|tt|u|ul|var)\\s*?>)|(<!--\\s(.*?\\s)-->)|(<\\?xml.*?\\?>)|(<!DOCTYPE\\s.*?>)))*");
    private Regex.Special existingMarkupTrans = new Regex.Special("<", EXISITING_MARKUP_PATTERN, new Regex.Trans(){

        public void apply(Task task, StringBuilder stringBuilder, Matcher matcher) {
            InlineMarkup.this.storeSnippet(stringBuilder, matcher.group(0));
        }
    });
    private static Regex.Special linkEmbeddedTrans = new Regex.Special("[\"", "(?sm)\\[\"([^(]+?)( *\\(([^)\n]+?)\\))?\":(\\S+?)\\]", new Regex.Trans(){

        public void apply(Task task, StringBuilder stringBuilder, Matcher matcher) {
            stringBuilder.append("<a href=\"");
            String string = task.getUrl(matcher.group(4));
            if (string == null) {
                string = matcher.group(4);
            }
            stringBuilder.append(string);
            stringBuilder.append('\"');
            String string2 = matcher.group(3);
            if (string2 != null) {
                stringBuilder.append(" title=\"" + string2);
                stringBuilder.append('\"');
            }
            String string3 = matcher.group(1);
            stringBuilder.append(">" + string3 + "</a>");
        }
    });
    private static Regex.Special linkTrans = new Regex.Special("\"", "(?sm)(^|[\\s>`])\"([^(\"]+?)( *\\(([^)\n]+?)\\))?\":(\\S+?)(?=$|<|`|\\s|([\\.,;:!\\?](\\s|$)))", new Regex.Trans(){

        public void apply(Task task, StringBuilder stringBuilder, Matcher matcher) {
            stringBuilder.append(matcher.group(1));
            stringBuilder.append("<a href=\"");
            String string = task.getUrl(matcher.group(5));
            if (string == null) {
                string = matcher.group(5);
            }
            stringBuilder.append(string);
            stringBuilder.append('\"');
            String string2 = matcher.group(4);
            if (string2 != null) {
                stringBuilder.append(" title=\"" + string2);
                stringBuilder.append('\"');
            }
            String string3 = matcher.group(2);
            stringBuilder.append(">" + string3 + "</a>");
        }
    });
    private static Regex.Special imgEmbeddedTrans = new Regex.Special("[!", "(?sm)\\[!((-|\\^|~|<|>|\\(+|\\)+|\\(\\w*?(#\\w+)?\\)|\\{\\{[\\S &&[^{}]]+\\}\\}|\\{[\\S &&[^}]]+\\})+ )?(\\S+?)( *\\(([^)\n]+?)\\))?!\\]", new Regex.Trans(){

        public void apply(Task task, StringBuilder stringBuilder, Matcher matcher) {
            String string;
            stringBuilder.append("<img src=\"");
            String string2 = task.getUrl(matcher.group(4));
            if (string2 == null) {
                string2 = matcher.group(4);
            }
            stringBuilder.append(string2);
            stringBuilder.append('\"');
            String string3 = matcher.group(6);
            if (string3 != null) {
                stringBuilder.append(" alt=\"" + string3 + "\" title=\"" + string3 + "\"");
            }
            if ((string = matcher.group(1)) != null) {
                Modifiers.Image image = new Modifiers.Image(task, string);
                stringBuilder.append(image.tagAttributes());
            }
            stringBuilder.append(" />");
        }
    });
    private static Regex.Special imgTrans = new Regex.Special("!", "(?sm)(^|[\\s>`])!((-|\\^|~|<|>|\\(+|\\)+|\\(\\w*?(#\\w+)?\\)|\\{\\{[\\S &&[^{}]]+\\}\\}|\\{[\\S &&[^}]]+\\})+ )?(\\S+?)( *\\(([^)\n]+?)\\))?!(?=$|<|`|\\s|([\\.,;:!\\?](\\s|$)))", new Regex.Trans(){

        public void apply(Task task, StringBuilder stringBuilder, Matcher matcher) {
            String string;
            stringBuilder.append(matcher.group(1));
            stringBuilder.append("<img src=\"");
            String string2 = task.getUrl(matcher.group(5));
            if (string2 == null) {
                string2 = matcher.group(5);
            }
            stringBuilder.append(string2);
            stringBuilder.append('\"');
            String string3 = matcher.group(7);
            if (string3 != null) {
                stringBuilder.append(" alt=\"" + string3 + "\" title=\"" + string3 + "\"");
            }
            if ((string = matcher.group(2)) != null) {
                Modifiers.Image image = new Modifiers.Image(task, string);
                stringBuilder.append(image.tagAttributes());
            }
            stringBuilder.append(" />");
        }
    });
    private static Regex.Special imgLinkEmbeddedTrans = new Regex.Special("[!", "(?sm)\\[!((-|\\^|~|&lt;|&gt;|\\(+|\\)+|\\(\\w*?(#\\w+)?\\)|\\{\\{[\\S &&[^{}]]+\\}\\}|\\{[\\S &&[^}]]+\\})+ )?(\\S+?)( *\\(([^)\n]+?)\\))?!:(\\S+?)\\]", new Regex.Trans(){

        public void apply(Task task, StringBuilder stringBuilder, Matcher matcher) {
            String string;
            stringBuilder.append("<a href=\"");
            String string2 = task.getUrl(matcher.group(7));
            if (string2 == null) {
                string2 = matcher.group(7);
            }
            stringBuilder.append(string2);
            stringBuilder.append("\"><img src=\"");
            String string3 = task.getUrl(matcher.group(4));
            if (string3 == null) {
                string3 = matcher.group(4);
            }
            stringBuilder.append(string3);
            stringBuilder.append('\"');
            String string4 = matcher.group(6);
            if (string4 != null) {
                stringBuilder.append(" alt=\"" + string4 + "\" title=\"" + string4 + "\"");
            }
            if ((string = matcher.group(1)) != null) {
                string = InlineMarkup.cer2gtrLess(string);
                Modifiers.Image image = new Modifiers.Image(task, string);
                stringBuilder.append(image.tagAttributes());
            }
            stringBuilder.append(" /></a>");
        }
    });
    private static Regex.Special imgLinkTrans = new Regex.Special("!", "(?sm)(^|[\\s>`])!((-|\\^|~|&lt;|&gt;|\\(+|\\)+|\\(\\w*?(#\\w+)?\\)|\\{\\{[\\S &&[^{}]]+\\}\\}|\\{[\\S &&[^}]]+\\})+ )?(\\S+?)( *\\(([^)\n]+?)\\))?!:(\\S+?)(?=$|<|`|\\s|([\\.,;:!\\?](\\s|$)))", new Regex.Trans(){

        public void apply(Task task, StringBuilder stringBuilder, Matcher matcher) {
            String string;
            stringBuilder.append(matcher.group(1));
            stringBuilder.append("<a href=\"");
            String string2 = task.getUrl(matcher.group(8));
            if (string2 == null) {
                string2 = matcher.group(8);
            }
            stringBuilder.append(string2);
            stringBuilder.append("\"><img src=\"");
            String string3 = task.getUrl(matcher.group(5));
            if (string3 == null) {
                string3 = matcher.group(5);
            }
            stringBuilder.append(string3);
            stringBuilder.append('\"');
            String string4 = matcher.group(7);
            if (string4 != null) {
                stringBuilder.append(" alt=\"" + string4 + "\" title=\"" + string4 + "\"");
            }
            if ((string = matcher.group(2)) != null) {
                string = InlineMarkup.cer2gtrLess(string);
                Modifiers.Image image = new Modifiers.Image(task, string);
                stringBuilder.append(image.tagAttributes());
            }
            stringBuilder.append(" /></a>");
        }
    });
    private static Regex.Special spanTrans = new Regex.Special("%", "(?sm)(^|\\s|>|`)%((-|\\^|~|&lt;|&gt;|\\(+|\\)+|\\(\\w*?(#\\w+)?\\)|\\{\\{[\\S &&[^{}]]+\\}\\}|\\{[\\S &&[^}]]+\\})+ )?((?:\\S{1,2})|(?:[\\S&&[^_+*-]].+?\\S))%(?=$|<|`|\\s|([\\.,;:!\\?](\\s|$)))", new Regex.Trans(){

        public void apply(Task task, StringBuilder stringBuilder, Matcher matcher) {
            stringBuilder.append(matcher.group(1));
            stringBuilder.append("<span");
            String string = matcher.group(2);
            if (string != null) {
                string = InlineMarkup.cer2gtrLess(string);
                Modifiers.Span span = new Modifiers.Span(task, string);
                stringBuilder.append(span.tagAttributes());
            }
            stringBuilder.append(">");
            stringBuilder.append(matcher.group(5));
            stringBuilder.append("</span>");
        }
    });
    private static Regex.Special spanEmbeddedTrans = new Regex.Special("[%", "(?sm)\\[%((-|\\^|~|&lt;|&gt;|\\(+|\\)+|\\(\\w*?(#\\w+)?\\)|\\{\\{[\\S &&[^{}]]+\\}\\}|\\{[\\S &&[^}]]+\\})+ )?((?:\\S{1,2})|(?:[\\S&&[^_+*-]].+?))%\\]", new Regex.Trans(){

        public void apply(Task task, StringBuilder stringBuilder, Matcher matcher) {
            stringBuilder.append("<span");
            String string = matcher.group(1);
            if (string != null) {
                string = InlineMarkup.cer2gtrLess(string);
                Modifiers.Span span = new Modifiers.Span(task, string);
                stringBuilder.append(span.tagAttributes());
            }
            stringBuilder.append(">");
            stringBuilder.append(matcher.group(4));
            stringBuilder.append("</span>");
        }
    });
    private static final String FN_MATCH = "\\[(\\d+)\\]";
    private static final String FN_REPLACE_MODERN = "<a class=\"fn_mark\" id=\"fnmk$1\" href=\"#fn$1\">$1</a>";
    private static Regex.Replace fnMarkerModernTrans = new Regex.Replace("[", "\\[(\\d+)\\]", "<a class=\"fn_mark\" id=\"fnmk$1\" href=\"#fn$1\">$1</a>");
    private static Regex.Replace fnMarkerClassicTrans = new Regex.Replace("[", "\\[(\\d+)\\]", "<sup><a class=\"fn_mark\" id=\"fnmk$1\" href=\"#fn$1\">$1</a></sup>");
    private static final String[] INLINE_MARKUP = new String[]{"__", "**", "*", "_", "??", "++", "--", "-", "+", "~", "^"};
    private static final String[] INLINE_TAGS = new String[]{"i", "b", "strong", "em", "cite", "big", "small", "del", "ins", "sub", "sup"};
    private static SymPhraseTransform[] phraseTrans = new SymPhraseTransform[INLINE_MARKUP.length];
    private static SymPhraseEmbeddedTransform[] phraseEmbeddedTrans = new SymPhraseEmbeddedTransform[INLINE_MARKUP.length];
    private static Regex.Replace acronymTrans;
    private static Regex.Replace acronymLikeTrans;
    private static Regex.Replace ampersandStoreTrans;
    private static Regex.Replace ampersandRestoreTrans;
    private HashMap<String, String> snippetMap = new HashMap(64);
    private static int nextKeyId;
    private static Pattern SNIPPET_RESTORE_PATTERN;
    private String text;
    private Block block;
    private Task task;
    private Env env;
    private boolean preserveWhitespace;

    private static String phrases(Task task, String string) {
        if (string.length() < 3) {
            return string;
        }
        string = spanTrans.apply(task, string);
        string = spanEmbeddedTrans.apply(task, string);
        for (int i = 0; i < phraseTrans.length; ++i) {
            string = phraseEmbeddedTrans[i].replace(string);
            string = phraseTrans[i].replace(string);
        }
        string = task.value("_FootnoteStyle_").equals("modern") ? fnMarkerModernTrans.replace(string) : fnMarkerClassicTrans.replace(string);
        string = acronymTrans.replace(string);
        string = acronymLikeTrans.replace(string);
        return string;
    }

    private static String cers(String string) {
        String[][] stringArrayArray = new String[][]{{"(\\s?)--(\\s?)", "$1&#8212;$2"}, {"\\s-\\s", " &#8211; "}, {"\\b( )?\\((tm|TM)\\)", "$1&#8482;"}, {"\\b( )?\\([rR]\\)", "$1&#174;"}, {"(\\A|\\b)( )?\\([cC]\\)( )?(\\b|\\Z)", "$2&#169;$3"}};
        for (int i = 0; i < stringArrayArray.length; ++i) {
            string = string.replaceAll(stringArrayArray[i][0], stringArrayArray[i][1]);
        }
        return string;
    }

    private static String cer2gtrLess(String string) {
        string = string.replaceAll("&gt;", ">");
        string = string.replaceAll("&lt;", "<");
        return string;
    }

    private void storeSnippet(StringBuilder stringBuilder, String string) {
        String string2 = XIL_KEY + Integer.toString(nextKeyId++) + XIL_END;
        stringBuilder.append(string2);
        this.snippetMap.put(string2, string);
    }

    private String flowCode(String string) {
        string = "<code>" + InlineMarkup.replaceUnkindChar(string) + "</code>";
        if (!this.preserveWhitespace) {
            string = string.replaceAll("\\n", "<br />");
        }
        return string;
    }

    InlineMarkup() {
    }

    public String translate(Block block) {
        this.init(block, false);
        return this.translate();
    }

    public String translateKeepNL(Block block) {
        this.init(block, true);
        return this.translate();
    }

    public String translateKeepNL(Block block, String string) {
        this.init(block, true);
        this.text = string;
        return this.translate();
    }

    public String translate(Task task, String string) {
        this.text = string;
        this.task = task;
        this.env = task.getEnv();
        nextKeyId = 0;
        return this.translate();
    }

    public String translateKM(Task task, String string) {
        this.text = string;
        this.task = task;
        this.env = task.getEnv();
        nextKeyId = 0;
        this.keyValueSub();
        this.execMacros();
        return this.text;
    }

    public String translateKMU(Task task, String string) {
        return InlineMarkup.replaceUnkindChar(this.translateKM(task, string));
    }

    private void init(Block block, boolean bl) {
        this.preserveWhitespace = bl;
        this.text = bl ? block.linesAsString() : block.linesAsStringTrim();
        this.task = block.getTask();
        this.env = this.task.getEnv();
        nextKeyId = 0;
    }

    private void keyValueSub() {
        this.text = keyValueSubTrans.apply(this.task, this.text);
    }

    private void execMacros() {
        this.text = execMacrosTrans.apply(this.task, this.text);
    }

    private String translate() {
        this.keyValueSub();
        this.execMacros();
        this.text = this.noModTrans.apply(this.task, this.text);
        this.text = this.noModEmbeddedTrans.apply(this.task, this.text);
        this.text = this.codeTrans.apply(this.task, this.text);
        this.text = this.codeEmbeddedTrans.apply(this.task, this.text);
        this.text = this.existingMarkupTrans.apply(this.task, this.text);
        this.text = linkEmbeddedTrans.apply(this.task, this.text);
        this.text = linkTrans.apply(this.task, this.text);
        this.text = imgEmbeddedTrans.apply(this.task, this.text);
        this.text = imgTrans.apply(this.task, this.text);
        this.text = imgLinkEmbeddedTrans.apply(this.task, this.text);
        this.text = imgLinkTrans.apply(this.task, this.text);
        this.text = this.existingMarkupTrans.apply(this.task, this.text);
        this.text = ampersandStoreTrans.replace(this.text);
        this.text = InlineMarkup.replaceUnkindChar(this.text);
        this.text = ampersandRestoreTrans.replace(this.text);
        this.text = InlineMarkup.phrases(this.task, this.text);
        this.text = this.existingMarkupTrans.apply(this.task, this.text);
        this.text = InlineMarkup.cers(this.text);
        if (this.snippetMap.size() > 0) {
            this.text = this.env.getRegex().applyTrans(this.task, this.text, SNIPPET_RESTORE_PATTERN, new Regex.Trans(){

                public void apply(Task task, StringBuilder stringBuilder, Matcher matcher) {
                    stringBuilder.append((String)InlineMarkup.this.snippetMap.get(matcher.group(1)));
                }
            });
        }
        if (!this.preserveWhitespace) {
            this.text = InlineMarkup.breakLines(this.text);
        }
        return this.text;
    }

    public static String replaceUnkindChar(String string) {
        string = string.replaceAll("&", "&amp;");
        string = string.replaceAll(">", "&gt;");
        return string.replaceAll("<", "&lt;");
    }

    public static String breakLines(String string) {
        return string.replaceAll("\n", "<br />\n");
    }

    static {
        for (int i = 0; i < INLINE_MARKUP.length; ++i) {
            InlineMarkup.phraseTrans[i] = new SymPhraseTransform(INLINE_MARKUP[i], INLINE_TAGS[i]);
            InlineMarkup.phraseEmbeddedTrans[i] = new SymPhraseEmbeddedTransform(INLINE_MARKUP[i], INLINE_TAGS[i]);
        }
        acronymTrans = new Regex.Replace("", "\\b([A-Z][A-Z0-9]{2,})(\\(([^\\)]+?)\\))", "<acronym title=\"$3\"><span class=\"caps\">$1</span></acronym>");
        acronymLikeTrans = new Regex.Replace("", "(\\s|^)([A-Z][A-Z0-9]{2,})\\b", "$1<span class=\"caps\">$2</span>");
        ampersandStoreTrans = new Regex.Replace("&", "(?s)((&)(([a-zA-Z1234]{2,8})|(#\\d{2,4});))", "q%`q%$3");
        ampersandRestoreTrans = new Regex.Replace(AMP_SUB, AMP_SUB, "&");
        nextKeyId = 0;
        SNIPPET_RESTORE_PATTERN = Pattern.compile("(?sm)(`xil%\\d+%xil`)");
    }

    private static class SymPhraseEmbeddedTransform
    extends Regex.Replace {
        SymPhraseEmbeddedTransform(String string, String string2) {
            super("[" + string, "(?sm)\\[" + Pattern.quote(string) + "((\\S){1,2}|(\\S.+?\\S))" + Pattern.quote(string) + "\\]", "<" + string2 + ">$1</" + string2 + ">");
        }
    }

    private static class SymPhraseTransform
    extends Regex.Replace {
        SymPhraseTransform(String string, String string2) {
            super(string, "(?sm)(^|\\s|>|`)" + Pattern.quote(string) + "((?:\\S{1,2})|(?:[\\S&&[^_+*-]].+?\\S))" + Pattern.quote(string) + InlineMarkup.PHRASE_TERMINATOR, "$1<" + string2 + ">$2</" + string2 + ">");
        }
    }
}

