/*
 * Decompiled with CFR 0.152.
 */
package com.centeredwork.xilize;

import com.centeredwork.xilize.BeanShell;
import com.centeredwork.xilize.Files;
import com.centeredwork.xilize.Key;
import com.centeredwork.xilize.ReporterStd;
import com.centeredwork.xilize.Xilize2;
import java.io.File;
import java.text.NumberFormat;
import java.util.HashMap;

public class Main {
    private static String NL = System.getProperty("line.separator");
    private static String USAGE = NL + "Arguments may have one of two forms:" + NL + "        -cf file" + NL + "or" + NL + "        [ options ] target [ qualifier ]" + NL + NL + "\"target\" is a file or directory tree to translate.  If it is the root of a" + NL + "project tree then \"qualifier\" may be a file or directory within that tree and" + NL + "translation will be restricted to its scope. \"qualifier\" may be expressed as a" + NL + "relative path from \"target\"." + NL + NL + "options:" + NL + NL + "| -cf file | --config-file file | reads configuration \"file\" before translation" + NL + "| -do      | --directory-only   | translate single directory only" + NL + "| -fr      | --find-root        | automatically locate root directory" + NL + "| -h       | --help             | this message" + NL + NL + "see http://www.centeredwork.com/xilize2 for more information" + NL;

    public static void main(String[] stringArray) {
        Object object;
        int n;
        if (stringArray.length == 0) {
            Main.quit("arguments required");
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        boolean bl = false;
        boolean bl2 = false;
        for (n = 0; n < stringArray.length && stringArray[n].startsWith("-"); ++n) {
            object = stringArray[n];
            if (((String)object).matches("-h|--help")) {
                Main.usage();
                return;
            }
            if (((String)object).matches("-cf|--config-file")) {
                if (n + 1 >= stringArray.length) {
                    Main.quit("config file must be specified with this option");
                    return;
                }
                hashMap.put(Key._XilizeConfigFile_.name(), stringArray[++n]);
                continue;
            }
            if (((String)object).matches("-do|--directory-only")) {
                bl = true;
                continue;
            }
            if (!((String)object).matches("-fr|--find-root")) continue;
            bl2 = true;
        }
        object = null;
        File file = null;
        if (bl2) {
            if (n != stringArray.length - 1) {
                Main.quit("too few arguments");
                return;
            }
            file = new File(stringArray[n]);
            ++n;
        } else {
            object = new File(stringArray[n]);
            if (++n < stringArray.length) {
                file = new File(stringArray[n]);
                ++n;
            }
        }
        if (n != stringArray.length) {
            Main.quit("too many arguments");
            return;
        }
        if (object != null) {
            if (!((File)object).exists()) {
                Main.quit(((File)object).getAbsolutePath() + " does not exist.");
                return;
            }
            if (file != null && !(file = Files.localFile(file.getPath(), ((File)object).getAbsolutePath())).exists()) {
                Main.quit(file.getAbsolutePath() + " does not exist.");
                return;
            }
        }
        if (bl2) {
            if (file == null) {
                Main.quit("-fr option requires a target");
            }
            if (!file.exists()) {
                Main.quit(file.getAbsolutePath() + " does not exist.");
                return;
            }
            object = Files.findRoot(file);
            if (object == null) {
                Main.quit("root not found starting from " + file.getAbsolutePath());
                return;
            }
        }
        Xilize2.startup(new ReporterStd(), new BeanShell(), hashMap);
        Xilize2 xilize2 = new Xilize2();
        if (object != null || file != null) {
            if (file == null) {
                if (((File)object).isDirectory()) {
                    if (bl) {
                        xilize2.xilizeDirectory((File)object, (File)object);
                    } else {
                        xilize2.xilizeBranch((File)object, (File)object);
                    }
                } else {
                    xilize2.xilizeFile(((File)object).getParentFile(), (File)object);
                }
            } else if (!((File)object).isDirectory()) {
                Main.quit(((File)object).getAbsolutePath() + " is not a directory");
            } else if (file.isFile()) {
                xilize2.xilizeFile((File)object, file);
            } else if (bl) {
                xilize2.xilizeDirectory((File)object, file);
            } else {
                xilize2.xilizeBranch((File)object, file);
            }
        }
        Xilize2.ExitCode exitCode = xilize2.translate();
        long l = xilize2.getEnv().getReporter().getLifeTime();
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(1);
        numberFormat.setMinimumFractionDigits(1);
        System.out.println("translated (" + numberFormat.format((double)l / 1000.0) + " seconds)");
        Xilize2.shutdown();
        System.exit(xilize2.getResultCode().getExitCode());
    }

    private static void quit(String string) {
        System.err.println(string);
        System.err.println();
        Main.usage(Xilize2.ExitCode.Usage.getExitCode());
    }

    private static void usage() {
        Main.usage(Xilize2.ExitCode.Okay.getExitCode());
    }

    private static void usage(int n) {
        System.err.println("Usage:");
        System.err.print(USAGE);
        System.exit(n);
    }
}

