/*
 * Decompiled with CFR 0.152.
 */
package com.centeredwork.xilize;

import com.centeredwork.xilize.Task;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Regex {
    private static final int BUFFER_SIZE = 1024;
    private StringBuilder buffer = new StringBuilder(1024);

    Regex() {
    }

    public String applyTrans(Task task, String string, Pattern pattern, Trans trans) {
        this.buffer.delete(0, this.buffer.length());
        Matcher matcher = pattern.matcher(string);
        int n = 0;
        while (matcher.find()) {
            if (matcher.start() > 0) {
                this.buffer.append(string.substring(n, matcher.start()));
            }
            trans.apply(task, this.buffer, matcher);
            n = matcher.end();
        }
        if (n == 0) {
            return string;
        }
        if (n < string.length()) {
            this.buffer.append(string.substring(n));
        }
        return this.buffer.toString();
    }

    public static String replace(String string, Pattern pattern, String string2) {
        return pattern.matcher(string).replaceAll(string2);
    }

    public static class Special
    extends Transformation {
        protected Trans trans;

        public Special(String string, String string2, Trans trans) {
            super(string, string2);
            this.trans = trans;
        }

        public Special(String string, Pattern pattern, Trans trans) {
            super(string, pattern);
            this.trans = trans;
        }

        public String apply(Task task, String string) {
            if (-1 == string.indexOf(this.marker)) {
                return string;
            }
            return task.getEnv().getRegex().applyTrans(task, string, this.pattern, this.trans);
        }
    }

    public static class Replace
    extends Transformation {
        protected String replacement;

        public Replace(String string, String string2, String string3) {
            super(string, string2);
            this.replacement = string3;
        }

        public Replace(String string, Pattern pattern, String string2) {
            super(string, pattern);
            this.replacement = string2;
        }

        public String replace(String string) {
            if (-1 == string.indexOf(this.marker)) {
                return string;
            }
            return this.pattern.matcher(string).replaceAll(this.replacement);
        }
    }

    protected static class Transformation {
        String marker;
        Pattern pattern;

        Transformation(String string, String string2) {
            this.pattern = Pattern.compile(string2);
            this.marker = string;
        }

        Transformation(String string, Pattern pattern) {
            this.pattern = pattern;
            this.marker = string;
        }
    }

    public static interface Trans {
        public void apply(Task var1, StringBuilder var2, Matcher var3);
    }
}

