/*
 * Decompiled with CFR 0.152.
 */
package com.centeredwork.xilize;

import bsh.EvalError;
import com.centeredwork.xilize.BeanShell;
import com.centeredwork.xilize.Block;
import com.centeredwork.xilize.Signature;
import com.centeredwork.xilize.Task;
import com.centeredwork.xilize.XilizeException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SigIf
extends Signature {
    public SigIf() {
        super("if");
    }

    public void exec(Task task, Block block) throws XilizeException {
        if (!block.isParent()) {
            task.error(block.getLineNumber(), "child blocks required (used when condition is true)");
            return;
        }
        String string = block.linesAsString();
        BeanShell beanShell = task.getBsh();
        String string2 = null;
        try {
            beanShell.set("task", task);
            string2 = beanShell.exec(task, block.getLineNumber(), string);
            boolean bl = new Boolean(string2);
            ArrayList<Block> arrayList = block.getChildren();
            Block block2 = arrayList.get(arrayList.size() - 1);
            if (bl) {
                if (block2.getSignature().getName().equals("else")) {
                    arrayList.remove(arrayList.size() - 1);
                }
            } else if (block2.getSignature().getName().equals("else")) {
                block.setChildren(block2.getChildren());
            } else {
                block.setChildren(null);
            }
        }
        catch (EvalError evalError) {
            throw new XilizeException(task, block.getLineNumber(), evalError.getMessage());
        }
        finally {
            beanShell.set("task", null);
        }
    }

    public String translate(Task task, Block block) {
        if (block.getChildren() != null) {
            for (Block block2 : block.getChildren()) {
                block2.translate();
            }
        }
        return null;
    }

    public static class Def
    extends Signature {
        boolean negate;
        private static Pattern pattern = Pattern.compile(" *(\\S+) +(.*)");

        Def(String string, boolean bl) {
            super(string);
            this.negate = bl;
        }

        public void exec(Task task, Block block) throws XilizeException {
            if (!block.isParent()) {
                Matcher matcher = pattern.matcher(block.getLine(0));
                if (!matcher.matches()) {
                    task.error(block.getLineNumber(), "must have key and text for true condition");
                } else if (this.negate && !task.isDefined(matcher.group(1)) || !this.negate && task.isDefined(matcher.group(1))) {
                    block.morph(matcher.group(2));
                }
                return;
            }
            String string = "if. " + (this.negate ? "!" : "") + "task.isDefined(\"" + block.linesAsStringTrim() + "\")";
            block.morph(string);
        }

        public String translate(Task task, Block block) {
            if (block.getChildren() != null) {
                for (Block block2 : block.getChildren()) {
                    block2.translate();
                }
            }
            return null;
        }
    }
}

