/*
 * Decompiled with CFR 0.152.
 */
package com.centeredwork.xilize;

import com.centeredwork.xilize.BeanShell;
import com.centeredwork.xilize.Block;
import com.centeredwork.xilize.BlockAssembler;
import com.centeredwork.xilize.BlockReader;
import com.centeredwork.xilize.Catalog;
import com.centeredwork.xilize.Env;
import com.centeredwork.xilize.Files;
import com.centeredwork.xilize.Key;
import com.centeredwork.xilize.Reporter;
import com.centeredwork.xilize.Signature;
import com.centeredwork.xilize.Task;
import com.centeredwork.xilize.Xilize2;
import com.centeredwork.xilize.XilizeException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;

public class TaskFile
extends Task {
    protected File file;
    protected File outputFile;
    protected Catalog catalog;
    protected ArrayList<Block> rawBlocks = new ArrayList();

    public TaskFile(Task task, File file) {
        super(task);
        this.file = file;
        this.catalog = new Catalog(this);
    }

    protected boolean isGeneratingOutput() {
        return true;
    }

    public String getPath() {
        return this.file.getAbsolutePath();
    }

    public File getFile() {
        return this.file;
    }

    public String getDescription() {
        return "file " + this.getPath();
    }

    public String toString() {
        return this.getDescription() + ":" + (this.file == null ? "" : this.file.getName());
    }

    public void xilize() throws XilizeException {
        if (this.isHalted()) {
            throw new XilizeException(Xilize2.ExitCode.UserHalt, (Task)this, "user interrupt");
        }
        try {
            BlockReader blockReader = new BlockReader(this, new BufferedReader(new FileReader(this.file)));
            this.xilize(blockReader);
            blockReader.close();
        }
        catch (IOException iOException) {
            this.error("error reading file", iOException);
        }
    }

    private void xilize(BlockReader blockReader) throws XilizeException {
        this.report(this.file.toString());
        this.define(Key._FilePathXil_, Files.normalizePath(this.file.getAbsolutePath()));
        this.define(Key._FileNameXil_, this.file.getName());
        try {
            Object object2;
            int n = -1;
            if (this.isNatural()) {
                if (this.isDefined(Key.commoninc)) {
                    this.include(this.value(Key.commoninc));
                }
                if (this.isDefined(Key.headerinc)) {
                    this.include(this.value(Key.headerinc));
                }
                n = this.rawBlocks.size();
            }
            this.getRawBlocks(blockReader);
            if (this.isNatural()) {
                if (this.isDefined(Key.footerinc)) {
                    this.include(this.value(Key.footerinc));
                }
                if (n < this.rawBlocks.size()) {
                    for (int i = n; i < this.rawBlocks.size(); ++i) {
                        object2 = this.rawBlocks.get(i);
                        if (((Block)object2).isSigned()) continue;
                        String object3 = this.markup(((Block)object2).linesAsString());
                        this.define(Key._NaturalLabel_, object3);
                        this.defineDefault(Key.title.name(), object3);
                        ((Block)object2).setSignature(this.getSignature(this.value(Key._NaturalSig_)));
                        break;
                    }
                }
            }
            Block block = new Block();
            new BlockAssembler(this, this.rawBlocks).assemble(block);
            for (Block block2 : block.getChildren()) {
                block2.exec();
            }
            object2 = new Block(this, this.getSignature("prolog"));
            Block block3 = new Block(this, this.getSignature("epilog"));
            ArrayList<Block> arrayList = block.getChildren();
            if (block.getChildren() == null) {
                block.addChild((Block)object2);
                block.addChild(block3);
            } else {
                block.getChildren().add(0, (Block)object2);
                block.addChild(block3);
            }
            String string = this.file.getName();
            String string2 = this.value(Key._OutputExtension_);
            this.outputFile = new File(this.file.getParent(), string.replaceAll("\\.xil$", "." + string2));
            this.define(Key._FilePathHtml_, Files.normalizePath(this.outputFile.getAbsolutePath()));
            this.define(Key._FilePathOuput_, Files.normalizePath(this.outputFile.getAbsolutePath()));
            this.define(Key._FileNameHtml_, this.outputFile.getName());
            this.define(Key._FileNameOutput_, this.outputFile.getName());
            for (Block block4 : block.getChildren()) {
                block4.translate();
            }
            for (Block block5 : block.getChildren()) {
                block5.translateLast();
            }
            if (this.isGeneratingOutput()) {
                PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(this.outputFile)));
                for (Block block6 : block.getChildren()) {
                    block6.write(printWriter);
                    printWriter.println();
                }
                printWriter.close();
            }
        }
        catch (XilizeException xilizeException) {
            this.error(0, xilizeException.getMessage());
            throw xilizeException;
        }
        catch (IOException iOException) {
            this.error("error reading/writing source file, trying to continue", iOException);
        }
    }

    void include(String string) throws XilizeException {
        this.include(0, string);
    }

    void include(int n, String string) throws XilizeException {
        this.include(n, Files.localFile(string, this.file.getParent()));
    }

    void include(int n, File file) throws XilizeException {
        new Include(this, file, n, this.rawBlocks).xilize();
    }

    protected void getRawBlocks(BlockReader blockReader) throws XilizeException {
        Block block = null;
        try {
            while ((block = blockReader.readRawBlock()) != null) {
                if (block.getSignature() == null) {
                    this.error(block.getLineNumber(), "block has no signature");
                    throw new XilizeException(Xilize2.ExitCode.Error, (Task)this, "block has no signature");
                }
                if (this.isValueTrue(Key._DebugReportRawBlocks_)) {
                    this.report(block.toString());
                }
                if (block.getSignature().isImmediate()) {
                    block.exec();
                    continue;
                }
                this.rawBlocks.add(block);
            }
        }
        catch (IOException iOException) {
            int n = 0;
            if (this.rawBlocks.size() > 0) {
                n = this.rawBlocks.get(this.rawBlocks.size() - 1).getLineNumber();
            }
            this.error(n, "reading problem after this block: " + iOException.getMessage());
        }
    }

    static class Master
    extends Config {
        Master(File file, Reporter reporter, BeanShell beanShell) {
            super(null, file);
            this.env = new Env(reporter, beanShell);
            Key.addDefaultKV(this.defReg);
            Signature.addStdSigSet(this);
        }

        public String getDescription() {
            return "master task";
        }

        void loadSystemProperties() {
            Properties properties = System.getProperties();
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.define(string, properties.getProperty(string));
            }
        }
    }

    static class Config
    extends TaskFile {
        public Config(Task task, File file) {
            super(task, file);
        }

        public String getDescription() {
            return "config file" + this.getPath();
        }

        protected boolean isGeneratingOutput() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Include
    extends TaskFile {
        int lineNum;

        public Include(TaskFile taskFile, File file, int n, ArrayList<Block> arrayList) {
            super(taskFile, file);
            this.lineNum = n;
            this.rawBlocks = arrayList;
            this.defReg = this.parent.defReg;
            this.abbrevReg = this.parent.abbrevReg;
            this.sigReg = this.parent.sigReg;
        }

        @Override
        public String getDescription() {
            return "include file " + this.getPath();
        }

        @Override
        public void xilize() throws XilizeException {
            try {
                BlockReader blockReader = new BlockReader(this, new BufferedReader(new FileReader(this.file)));
                this.getRawBlocks(blockReader);
                blockReader.close();
            }
            catch (IOException iOException) {
                this.getParent().error(this.lineNum, "error reading include file: " + iOException.getMessage());
                iOException.printStackTrace();
            }
        }
    }
}

