/*
 * Decompiled with CFR 0.152.
 */
package cmp.QuickSort;

import cmp.QuickSort.Comparator;

public class QuickSort {
    private static final String EmbeddedCopyright = "Copyright 1996-1998 Roedy Green, Canadian Mind Products, http://mindprod.com";
    private static final boolean debugging = false;
    private Comparator delegate;
    private Object[] userArray;

    public static void sort(Object[] objectArray, Comparator comparator) {
        QuickSort quickSort = new QuickSort();
        quickSort.delegate = comparator;
        quickSort.userArray = objectArray;
        if (quickSort.isAlreadySorted()) {
            return;
        }
        quickSort.quicksort(0, objectArray.length - 1);
        if (quickSort.isAlreadySorted()) {
            return;
        }
    }

    private void quicksort(int n, int n2) {
        if (n < n2) {
            int n3 = this.partition(n, n2);
            if (n3 == n2) {
                --n3;
            }
            this.quicksort(n, n3);
            this.quicksort(n3 + 1, n2);
        }
    }

    private int partition(int n, int n2) {
        Object object = this.userArray[n];
        while (true) {
            if (this.delegate.compare(this.userArray[n2], object) >= 0 && n < n2) {
                --n2;
                continue;
            }
            while (this.delegate.compare(this.userArray[n], object) < 0 && n < n2) {
                ++n;
            }
            if (n >= n2) break;
            Object object2 = this.userArray[n];
            this.userArray[n] = this.userArray[n2];
            this.userArray[n2] = object2;
        }
        return n2;
    }

    private boolean isAlreadySorted() {
        int n = 1;
        while (n < this.userArray.length) {
            if (this.delegate.compare(this.userArray[n], this.userArray[n - 1]) < 0) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

