/*
 * Decompiled with CFR 0.152.
 */
package javasrc.app;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javasrc.app.ClassFile;
import javasrc.app.Reference;

public class Pass2 {
    public static final boolean debug = false;
    public static final String DEFAULT_DIR = ".";
    public static final String USAGE = "Usage: java -Doutdir=<doc dir>[-Dtitle=<title>][-Dverbose=true]javasrc.Pass2 ";
    private static String _outDir;
    private static String _title;
    private static boolean _verbose;
    ArrayList packageNames = new ArrayList();
    Hashtable packageClasses = new Hashtable();

    public static String getOutDir() {
        return _outDir;
    }

    public static void setOutDir(String string) {
        _outDir = string;
    }

    public static String getTitle() {
        return _title;
    }

    public static void setTitle(String string) {
        _title = string;
    }

    public static boolean getVerbose() {
        return _verbose;
    }

    public static void setVerbose(boolean bl) {
        _verbose = bl;
    }

    public void run(String[] stringArray) throws IOException {
        File file = new File(Pass2.getOutDir());
        this.walkDirectories(null, file);
        Collections.sort(this.packageNames, this.stringComparator());
        this.createPackageFiles();
        this.createOverviewFrame();
        this.createIndex();
        this.createStyleSheet();
        this.createAllClassesFrame();
        this.createOverviewSummaryFrame();
        this.createFilenameFrame();
    }

    private void walkDirectories(String string, File file) throws IOException {
        Object object;
        File file2 = new File(file, "references.txt");
        if (file2.exists()) {
            this.processRefFile(string, file2);
            object = (HashMap)this.packageClasses.get(string);
            if (((HashMap)object).size() > 0) {
                this.packageNames.add(string);
            }
        }
        object = file.listFiles();
        int n = 0;
        while (n < ((File[])object).length) {
            if (((File)object[n]).isDirectory()) {
                String string2 = string == null ? ((File)object[n]).getName() : string + DEFAULT_DIR + ((File)object[n]).getName();
                this.walkDirectories(string2, (File)object[n]);
            }
            ++n;
        }
    }

    private void processRefFile(String string, File file) throws IOException {
        Object object;
        HashMap<String, String> hashMap = (HashMap<String, String>)this.packageClasses.get(string);
        if (hashMap == null) {
            hashMap = new HashMap<String, String>();
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        Vector<String> vector = new Vector<String>();
        while ((object = bufferedReader.readLine()) != null) {
            vector.addElement((String)object);
        }
        bufferedReader.close();
        inputStreamReader.close();
        fileInputStream.close();
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        Arrays.sort(objectArray, this.stringComparator());
        BufferedWriter bufferedWriter = null;
        String string2 = null;
        String string3 = null;
        int n = 0;
        while (n < objectArray.length) {
            object = objectArray[n];
            if (((String)object).charAt(0) != '#') {
                Reference reference = new Reference((String)object);
                if (!reference.referentFileClass.equals(string2)) {
                    if (string3 != null) {
                        this.closeSection(bufferedWriter, string3);
                    }
                    if (bufferedWriter != null) {
                        this.closeOutputFile(bufferedWriter, string2);
                    }
                    bufferedWriter = this.openOutputFile(string, reference);
                    string2 = reference.referentFileClass;
                    string3 = null;
                }
                if (!hashMap.containsKey(reference.referentClass)) {
                    hashMap.put(reference.referentClass, reference.referentFileClass);
                }
                if (!reference.referentTag.equals(string3)) {
                    if (string3 != null) {
                        this.closeSection(bufferedWriter, string3);
                    }
                    string3 = reference.referentTag;
                    this.openSection(bufferedWriter, string, reference);
                }
                if (!reference.referringMethod.equals("?")) {
                    this.writeLink(bufferedWriter, string, reference);
                }
            }
            ++n;
        }
        if (bufferedWriter != null) {
            this.closeOutputFile(bufferedWriter, string2);
        }
        this.packageClasses.put(string, hashMap);
    }

    private void closeOutputFile(BufferedWriter bufferedWriter, String string) throws IOException {
        bufferedWriter.write("</body></html>");
        bufferedWriter.flush();
        bufferedWriter.close();
    }

    private BufferedWriter openOutputFile(String string, Reference reference) throws IOException {
        File file = new File(Pass2.getOutDir());
        String string2 = string == null ? reference.referentFileClass : string.replace('.', File.separatorChar) + File.separatorChar + reference.referentFileClass;
        string2 = string2 + "_java_ref.html";
        File file2 = new File(file, string2);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        bufferedWriter.write("<html><head><link rel=\"stylesheet\" type=\"text/css\" href=\"" + this.getBackupPath(string) + "styles.css\"></head><body>");
        return bufferedWriter;
    }

    private void closeSection(BufferedWriter bufferedWriter, String string) throws IOException {
        bufferedWriter.write("</p>");
    }

    private void openSection(BufferedWriter bufferedWriter, String string, Reference reference) throws IOException {
        if (reference.referentType.equals("Class")) {
            bufferedWriter.write("<p class=\"classReflist\">");
            String string2 = "<p class=\"classReflistHeader\">Class: <a name=" + reference.referentTag + " href=" + reference.referentFileClass + "_java.html#" + reference.referentTag + ">" + reference.referentClass + "</a></p>";
            bufferedWriter.write(string2);
        } else if (reference.referentType.equals("Method")) {
            bufferedWriter.write("<p class=\"methodReflist\">");
            bufferedWriter.write("<!-- hello -->");
            String string3 = "<p class=\"methodReflistHeader\">Method: <a name=" + reference.referentTag + " href=" + reference.referentFileClass + "_java.html#" + reference.referentTag + ">" + reference.referentTag + "</a></p>";
            bufferedWriter.write(string3);
        } else if (reference.referentType.equals("Variable")) {
            bufferedWriter.write("<p class=\"variableReflist\">");
            String string4 = "<p class=\"variableReflistHeader\">Variable: <a name=" + reference.referentTag + " href=" + reference.referentFileClass + "_java.html#" + reference.referentTag + ">" + reference.referentTag + "</a></p>";
            bufferedWriter.write(string4);
        } else {
            bufferedWriter.write("<p>open section " + reference.referentType + "</p>");
        }
    }

    private void writeLink(BufferedWriter bufferedWriter, String string, Reference reference) throws IOException {
        String string2 = this.sourceName(string, reference);
        if (reference.referentType.equals("Class")) {
            String string3 = "<p class=\"classRefItem\"><a href=" + string2 + "#" + reference.referringLineNumber + ">" + reference.referringPackage + DEFAULT_DIR + reference.referringClass + DEFAULT_DIR + reference.referringMethod + " (" + reference.referringFile + ":" + reference.referringLineNumber + ")</a></p>\n";
            bufferedWriter.write(string3);
        } else if (reference.referentType.equals("Method")) {
            String string4 = "<p class=\"methodRefItem\"><a href=" + string2 + "#" + reference.referringLineNumber + ">" + reference.referringPackage + DEFAULT_DIR + reference.referringClass + DEFAULT_DIR + reference.referringMethod + " (" + reference.referringFile + ":" + reference.referringLineNumber + ")</a></p>\n";
            bufferedWriter.write(string4);
        } else if (reference.referentType.equals("Variable")) {
            String string5 = "<p class=\"variableRefItem\"><a href=" + string2 + "#" + reference.referringLineNumber + ">" + reference.referringPackage + DEFAULT_DIR + reference.referringClass + DEFAULT_DIR + reference.referringMethod + " (" + reference.referringFile + ":" + reference.referringLineNumber + ")</a></p>\n";
            bufferedWriter.write(string5);
        } else {
            bufferedWriter.write("<p>link for a " + reference.referentType + "</p>");
        }
    }

    private String sourceName(String string, Reference reference) {
        String string2 = this.getBackupPath(string) + reference.referringPackage.replace('.', '/') + "/" + reference.referringClass + "_java.html";
        return string2;
    }

    private String getBackupPath(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, DEFAULT_DIR);
        String string2 = "";
        int n = 0;
        n = stringTokenizer.countTokens();
        int n2 = 0;
        while (n2 < n) {
            string2 = string2 + "../";
            ++n2;
        }
        String string3 = string2;
        return string3;
    }

    private void createPackageFiles() {
        int n = 0;
        Iterator iterator = ((AbstractList)this.packageNames).iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            List list = this.orderedPackageClasses(string);
            n += list.size();
            String string2 = Pass2.getOutDir() + File.separatorChar + string.replace('.', File.separatorChar) + File.separatorChar + "classList.html";
            File file = new File(string2);
            Pass2.createDirs(file);
            try {
                PrintWriter printWriter = new PrintWriter(new BufferedOutputStream(new FileOutputStream(file)));
                String string3 = "<head>\n<LINK rel=\"stylesheet\" type=\"text/css\" name=\"style1\" href=\"" + this.getBackupPath(string) + "styles.css\">\n" + "</head><body>\n";
                printWriter.println(string3);
                printWriter.println("<p class=packagename>" + string + "</p>");
                Iterator iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    ClassFile classFile = (ClassFile)iterator2.next();
                    String string4 = classFile.className;
                    String string5 = classFile.fileName;
                    int n2 = string4.indexOf(46);
                    String string6 = string4;
                    String string7 = "<p class=\"classListItem\"><a href=\"" + string5 + "_java.html#" + string6 + "\" TARGET=\"classFrame\">" + string4 + "</a></p>";
                    printWriter.println(string7);
                }
                printWriter.println("</body></html>");
                printWriter.close();
            }
            catch (Exception exception) {
                System.err.println("Error writing file:" + string2);
                exception.printStackTrace();
            }
        }
        System.out.println(n + " classes total");
    }

    private List orderedPackageClasses(String string) {
        HashMap hashMap = (HashMap)this.packageClasses.get(string);
        Set set = hashMap.entrySet();
        Iterator iterator = set.iterator();
        ArrayList<ClassFile> arrayList = new ArrayList<ClassFile>();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ClassFile classFile = new ClassFile((String)entry.getKey(), (String)entry.getValue());
            arrayList.add(classFile);
        }
        Collections.sort(arrayList, this.classFileComparator());
        return arrayList;
    }

    private Comparator stringComparator() {
        return new Comparator(this){
            private final /* synthetic */ Pass2 this$0;

            public int compare(Object object, Object object2) {
                return ((String)object).compareTo(object2);
            }

            public boolean equals(Object object) {
                return false;
            }
            {
                this.this$0 = pass2;
                this.constructor$0(pass2);
            }

            private final void constructor$0(Pass2 pass2) {
            }
        };
    }

    private Comparator classFileComparator() {
        return new Comparator(this){
            private final /* synthetic */ Pass2 this$0;

            public int compare(Object object, Object object2) {
                ClassFile classFile = (ClassFile)object;
                ClassFile classFile2 = (ClassFile)object2;
                return classFile.className.compareTo(classFile2.className);
            }

            public boolean equals(Object object) {
                return false;
            }
            {
                this.this$0 = pass2;
                this.constructor$0(pass2);
            }

            private final void constructor$0(Pass2 pass2) {
            }
        };
    }

    private void createIndex() {
        String string = Pass2.getOutDir() + File.separatorChar + "index.html";
        File file = new File(string);
        Pass2.createDirs(file);
        try {
            PrintWriter printWriter = new PrintWriter(new BufferedOutputStream(new FileOutputStream(file)));
            printWriter.println("<TITLE>" + Pass2.getTitle() + "</TITLE>");
            printWriter.println("<FRAMESET cols=\"20%,80%\">");
            printWriter.println("  <FRAMESET rows=\"30%,70%\">");
            printWriter.println("    <FRAME src=\"overview-frame.html\" name=\"packageListFrame\">");
            printWriter.println("    <FRAME src=\"allclasses-frame.html\" name=\"packageFrame\">");
            printWriter.println("  </FRAMESET>");
            printWriter.println("  ");
            printWriter.println("  <FRAMESET ROWS=40,*>");
            printWriter.println("    <FRAME src=\"filename.html\" name=\"filenameFrame\" scrolling=no>");
            printWriter.println("    <FRAME src=\"overview-summary.html\" name=\"classFrame\">");
            printWriter.println("  </FRAMESET>");
            printWriter.println("</FRAMESET>");
            printWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void createStyleSheet() {
        String string = Pass2.getOutDir() + File.separatorChar + "styles.css";
        File file = new File(string);
        if (!file.exists()) {
            Pass2.createDirs(file);
            try {
                PrintWriter printWriter = new PrintWriter(new BufferedOutputStream(new FileOutputStream(file)));
                printWriter.println("body { font-family: lucida, verdana, arial, sans-serif; font-size:9pt } ");
                printWriter.println("pre { font-size:9pt } ");
                printWriter.println(".comment   { color:darkred } ");
                printWriter.println(".linenum   { color:blue;font-weight:normal; color:#888 } ");
                printWriter.println(".classDef  { color:#080;font-weight:bold } ");
                printWriter.println(".classRef  { color:#060;font-weight:normal } ");
                printWriter.println(".methodDef { color:blue;font-weight:bold } ");
                printWriter.println(".methodRef { color:#009;font-weight:normal } ");
                printWriter.println(".varDef    { color:#870;font-weight:bold } ");
                printWriter.println(".varRef    { color:#660;font-weight:normal } ");
                printWriter.println(".packageListItem      { font-family: lucida, verdana, arial, sans-serif; ");
                printWriter.println("\t                margin:0; padding:0; border:0 } ");
                printWriter.println(".packageName          { font-family: lucida, verdana, arial, sans-serif; ");
                printWriter.println("\t\t\tfont-weight:bold } ");
                printWriter.println(".textDiv              { font-family: lucida, verdana, arial, sans-serif; ");
                printWriter.println("\t\t\tfont-weight:bold } ");
                printWriter.println(".classListItem        { font-family: lucida, verdana, arial, sans-serif; ");
                printWriter.println("\t                margin:0; padding:0; border:0 } ");
                printWriter.println(".classReflist         { border-bottom:solid } ");
                printWriter.println(".classReflistHeader   { font-weight:bold; ");
                printWriter.println("\t\t\tborder:0; margin:0; padding:0 } ");
                printWriter.println(".classRefItem         { margin:0; padding:0; border:0 } ");
                printWriter.println("p.classRefItem a        { color:#060 } ");
                printWriter.println("p.classReflistHeader a  { color:#080 } ");
                printWriter.println(".methodReflist         { } ");
                printWriter.println(".methodReflistHeader   { font-weight:bold; ");
                printWriter.println("\t\t\t border:0; margin:0; padding:0} ");
                printWriter.println(".methodRefItem         { margin:0; padding:0; border:0; color:#009 } ");
                printWriter.println("p.methodRefItem a        { color:#009 } ");
                printWriter.println("p.methodReflistHeader a  { color:blue } ");
                printWriter.println(".variableReflist         { } ");
                printWriter.println(".variableReflistHeader   { font-weight:bold; ");
                printWriter.println("\t\t           border:0; margin:0; padding:0} ");
                printWriter.println(".variableRefItem         { margin:0; padding:0; border:0; color:#660 } ");
                printWriter.println("p.variableRefItem a        { color:#660 } ");
                printWriter.println("p.variableRefListheader a  { color:#870 } ");
                printWriter.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void createOverviewFrame() {
        String string = Pass2.getOutDir() + File.separatorChar + "overview-frame.html";
        File file = new File(string);
        Pass2.createDirs(file);
        try {
            PrintWriter printWriter = new PrintWriter(new BufferedOutputStream(new FileOutputStream(file)));
            Iterator iterator = ((AbstractList)this.packageNames).iterator();
            printWriter.println("<html><head><link rel=\"stylesheet\" type=\"text/css\"href=\"styles.css\"></head><body>");
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                String string3 = string2.replace('.', '/') + "/" + "classList.html";
                printWriter.println("<p class=\"packageListItem\"><A HREF=\"" + string3 + "\" TARGET=\"packageFrame\">" + string2 + "</A></p>");
            }
            printWriter.println("</body></html>");
            printWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void createFilenameFrame() {
        String string = Pass2.getOutDir() + File.separatorChar + "filename.html";
        File file = new File(string);
        Pass2.createDirs(file);
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
            printWriter.println("<html><head><link rel=\"stylesheet\" type=\"text/css\"href=\"styles.css\"></head><body>");
            printWriter.println("<LAYER><NOLAYER><DIV ID=textDiv></NOLAYER><NOLAYER></DIV></NOLAYER></LAYER>");
            printWriter.println("</body></html>");
            printWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void createAllClassesFrame() {
        String string = Pass2.getOutDir() + File.separatorChar + "allclasses-frame.html";
        File file = new File(string);
        Pass2.createDirs(file);
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
            printWriter.println("packageFrame");
            printWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void createOverviewSummaryFrame() {
        String string = Pass2.getOutDir() + File.separatorChar + "overview-summary.html";
        File file = new File(string);
        Pass2.createDirs(file);
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
            printWriter.println("classFrame");
            printWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void initializeDefaults() {
        String string = System.getProperty("outdir");
        if (string == null) {
            string = DEFAULT_DIR;
        }
        Pass2.setOutDir(string);
        String string2 = System.getProperty("title");
        if (string2 == null) {
            string2 = "Pass2: " + string;
        }
        Pass2.setTitle(string2);
        boolean bl = false;
        String string3 = System.getProperty("verbose");
        if (string3 != null && ((string3 = string3.trim()).equalsIgnoreCase("on") || string3.equalsIgnoreCase("true") || string3.equalsIgnoreCase("yes") || string3.equalsIgnoreCase("1"))) {
            bl = true;
        }
        Pass2.setVerbose(bl);
    }

    private static void createDirs(File file) {
        String string = file.getParent();
        File file2 = new File(string);
        if (!file2.exists()) {
            file2.mkdirs();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Pass2 pass2 = new Pass2();
        pass2.initializeDefaults();
        pass2.run(stringArray);
    }
}

