/*
 * Decompiled with CFR 0.152.
 */
package javasrc.symtab;

import java.io.Externalizable;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import javasrc.symtab.ClassDefProxy;
import javasrc.symtab.ClassTag;
import javasrc.symtab.Definition;
import javasrc.symtab.DummyClass;
import javasrc.symtab.HTMLTag;
import javasrc.symtab.HTMLTagContainer;
import javasrc.symtab.HasImports;
import javasrc.symtab.JavaHashtable;
import javasrc.symtab.JavaVector;
import javasrc.symtab.MethodDef;
import javasrc.symtab.MultiDef;
import javasrc.symtab.Occurrence;
import javasrc.symtab.PackageDef;
import javasrc.symtab.ScopedDef;
import javasrc.symtab.SymbolTable;
import javasrc.symtab.VariableDef;
import javasrc.symtab.Visitor;

public class ClassDef
extends HasImports
implements Externalizable {
    static final int CLASS = 0;
    static final int INTERFACE = 1;
    static final int EITHER = 2;
    private static Hashtable allClassDefs = new Hashtable();
    private static Set goals = new HashSet();
    private int classOrInterface = 2;
    private ClassDef superClass;
    private JavaVector subClasses;
    private JavaVector interfaces;
    private JavaVector implementers;
    protected String packageName;

    protected static ClassDef findLoadedClass(String string, String string2) {
        String string3 = string + "." + string2;
        return (ClassDef)allClassDefs.get(string3);
    }

    void addImplementer(ClassDef classDef) {
        this.getImplementers().addElement(classDef);
        this.setType(1);
        classDef.setType(0);
    }

    void addSubclass(ClassDef classDef) {
        this.getSubClasses().addElement(classDef);
    }

    JavaVector getImplementers() {
        if (this.implementers == null) {
            this.implementers = new JavaVector();
        }
        return this.implementers;
    }

    public JavaVector getInterfaces() {
        return this.interfaces;
    }

    JavaVector getSubClasses() {
        if (this.subClasses == null) {
            this.subClasses = new JavaVector();
        }
        return this.subClasses;
    }

    public ClassDef getSuperClass() {
        return this.superClass;
    }

    public boolean isClass() {
        return this.classOrInterface == 0;
    }

    public boolean isInterface() {
        return this.classOrInterface == 1;
    }

    Definition lookup(String string, int n, Class clazz) {
        String string2 = this.getName() + "|" + this.getName() + "|" + n + "|" + clazz;
        if (goals.contains(string2)) {
            System.out.println("detected infinite loop: " + string2);
            new Exception().printStackTrace();
            return null;
        }
        goals.add(string2);
        Definition definition = super.lookup(string, n, clazz);
        if (definition == null && this.getSuperClass() != null) {
            this.setType(0);
            this.getSuperClass().setType(0);
            definition = this.getSuperClass().lookup(string, n, clazz);
        }
        if (definition == null && this.interfaces != null) {
            Enumeration enumeration = this.interfaces.elements();
            while (definition == null && enumeration.hasMoreElements()) {
                definition = ((ClassDef)enumeration.nextElement()).lookup(string, n, clazz);
            }
        }
        goals.remove(string2);
        return definition;
    }

    public void generateReferences(FileWriter fileWriter) {
        try {
            Object v;
            Serializable serializable;
            fileWriter.write("<p class=\"classReflist\">");
            String string = "<p class=\"classReflistHeader\">Class: <a name=" + this.getName() + " href=" + this.getSourceName() + "#" + this.getClassScopeName() + ">" + this.getScopedClassName() + "</a></p>";
            fileWriter.write(string);
            JavaVector javaVector = this.getReferences();
            Enumeration enumeration = javaVector.elements();
            while (enumeration.hasMoreElements()) {
                serializable = (Occurrence)enumeration.nextElement();
                if (serializable == null) continue;
                String string2 = this.getOccurrencePath((Occurrence)serializable) + ((Occurrence)serializable).getLinkReference();
                String string3 = "<p class=\"classRefItem\"><a href=" + string2 + ">" + this.getName() + " in " + ((Occurrence)serializable).getPackageName() + "." + ((Occurrence)serializable).getClassName() + "." + ((Occurrence)serializable).getMethodName() + " (" + ((Occurrence)serializable).getFile().getName() + ":" + Integer.toString(((Occurrence)serializable).getLine()) + ")</a></p>\n";
                fileWriter.write(string3);
            }
            serializable = this.getElements();
            Enumeration enumeration2 = ((Hashtable)serializable).elements();
            while (enumeration2.hasMoreElements()) {
                v = enumeration2.nextElement();
                if (!(v instanceof VariableDef)) continue;
                ((Definition)v).generateReferences(fileWriter);
            }
            enumeration2 = ((Hashtable)serializable).elements();
            while (enumeration2.hasMoreElements()) {
                v = enumeration2.nextElement();
                if (!(v instanceof MethodDef) && !(v instanceof MultiDef)) continue;
                ((Definition)v).generateReferences(fileWriter);
            }
            fileWriter.write("</p>\n");
            enumeration2 = ((Hashtable)serializable).elements();
            while (enumeration2.hasMoreElements()) {
                v = enumeration2.nextElement();
                if (!(v instanceof ClassDef)) continue;
                ((Definition)v).generateReferences(fileWriter);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void generateTags(HTMLTagContainer hTMLTagContainer) {
        String string = "<a class=\"classDef\" name=" + this.getClassScopeName() + " href=" + this.getRefName() + "#" + this.getClassScopeName() + ">" + this.getName() + "</a>";
        if (this.getOccurrence() != null) {
            HTMLTag hTMLTag = new HTMLTag(this.getOccurrence(), this.getName(), string);
            hTMLTagContainer.addElement(hTMLTag);
        }
        this.tagElements(hTMLTagContainer);
    }

    public HTMLTag getOccurrenceTag(Occurrence occurrence) {
        String string = this.getRelativePath(occurrence) + this.getSourceName();
        String string2 = "<a class=\"classRef\" href=" + string + "#" + this.getClassScopeName() + ">" + this.getName() + "</a>";
        HTMLTag hTMLTag = new HTMLTag(occurrence, this.getName(), string2);
        return hTMLTag;
    }

    void resolveTypes(SymbolTable symbolTable) {
        Object object;
        ClassDef classDef;
        super.resolveTypes(symbolTable);
        if (this.subClasses != null) {
            this.subClasses.resolveTypes(symbolTable);
            this.openImports(symbolTable);
        }
        if ((classDef = this.getSuperClass()) != null && classDef instanceof DummyClass) {
            object = ((DummyClass)classDef).getPackage();
            if ((classDef = symbolTable.lookupDummy(classDef)) == null) {
                classDef = new DummyClass(symbolTable.getUniqueName(this.getSuperClass().getName()), null, symbolTable.getUniqueName((String)object));
            }
            if (classDef != null) {
                classDef.addReference(this.getSuperClass().getOccurrence());
                this.setSuperClass(classDef);
                classDef.addSubclass(this);
                classDef.setType(0);
            }
            this.setType(0);
        }
        if (this.interfaces != null) {
            this.interfaces.resolveTypes(symbolTable);
            object = this.interfaces.elements();
            while (object.hasMoreElements()) {
                ((ClassDef)object.nextElement()).addImplementer(this);
            }
        }
        if (this.isTopLevel()) {
            this.closeImports(symbolTable);
        }
    }

    void resolveRefs(SymbolTable symbolTable) {
        JavaHashtable javaHashtable = symbolTable.getImports();
        JavaVector javaVector = symbolTable.getDemand();
        super.resolveRefs(symbolTable);
        if (this.isTopLevel()) {
            this.closeImports(symbolTable);
            symbolTable.setImports(javaHashtable);
            symbolTable.setDemand(javaVector);
        }
    }

    public void generateClassList(Vector vector) {
        if (this.hasElements()) {
            JavaHashtable javaHashtable = this.getElements();
            Enumeration enumeration = javaHashtable.elements();
            while (enumeration.hasMoreElements()) {
                Definition definition = (Definition)enumeration.nextElement();
                if (!(definition instanceof ClassDef)) continue;
                Occurrence occurrence = definition.getOccurrence();
                String string = occurrence.getFile().getName();
                string = string.substring(0, string.lastIndexOf("."));
                String string2 = string + "_java.html";
                if (!string.equals(definition.getName())) {
                    string2 = string2 + "#" + occurrence.getLine();
                }
                String string3 = "<p class=\"classListItem\"><a href=\"" + string2 + "\"" + "TARGET=\"classFrame\">" + definition.getScopedClassName() + "</a></p>";
                ClassTag classTag = new ClassTag(definition.getScopedClassName(), string3);
                vector.addElement(classTag);
                ((ClassDef)definition).generateClassList(vector);
            }
        }
    }

    void setInterfaces(JavaVector javaVector) {
        this.interfaces = javaVector;
    }

    void setSuperClass(ClassDef classDef) {
        this.superClass = classDef;
        this.setType(0);
        classDef.setType(0);
    }

    void setType(int n) {
        this.classOrInterface = n;
    }

    String getClassScopeName() {
        String string = this.getParentScope() instanceof ClassDef ? this.getParentScope().getName() + "." + this.getName() : this.getName();
        return string;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.getName());
        objectOutput.writeObject(this.getPackageName());
        objectOutput.writeObject(this.getOccurrence());
        ScopedDef scopedDef = this.getParentScope();
        if (scopedDef instanceof PackageDef) {
            scopedDef = null;
        }
        if (scopedDef == null && this.getPackageName() == null) {
            new Exception().printStackTrace();
        }
        objectOutput.writeObject(scopedDef);
        objectOutput.writeObject(this.elements);
        ClassDef classDef = this.superClass instanceof ClassDef && !(this.superClass instanceof ClassDefProxy) && !(this.superClass instanceof DummyClass) ? new ClassDefProxy(this.superClass) : this.superClass;
        objectOutput.writeObject(classDef);
        objectOutput.writeObject(this.interfaces);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.setName((String)objectInput.readObject());
        SymbolTable.startReadExternal("ClassDef " + this.getName());
        this.packageName = (String)objectInput.readObject();
        this.setOccurrence((Occurrence)objectInput.readObject());
        ScopedDef scopedDef = (ScopedDef)objectInput.readObject();
        this.elements = (JavaHashtable)objectInput.readObject();
        this.superClass = (ClassDef)objectInput.readObject();
        this.interfaces = (JavaVector)objectInput.readObject();
        if (scopedDef == null) {
            scopedDef = (ScopedDef)SymbolTable.getSymbolTable().findPackage(this.packageName);
        }
        this.setParentScope(scopedDef);
        this.setupFileNames();
        String string = this.packageName + "." + this.getName();
        allClassDefs.put(string, this);
        SymbolTable.endReadExternal();
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
        this.elements.accept(visitor);
    }

    public String toString() {
        Object object;
        Object object2;
        String string = "  " + super.toString() + "\n";
        if (this.interfaces != null) {
            object2 = this.interfaces.elements();
            while (object2.hasMoreElements()) {
                object = (Definition)object2.nextElement();
                string = string + "    " + object + "\n";
            }
        }
        object2 = this.getElements();
        object = ((Hashtable)object2).elements();
        while (object.hasMoreElements()) {
            Definition definition = (Definition)object.nextElement();
            string = string + "    " + definition + "\n";
        }
        return string;
    }

    public ClassDef() {
    }

    ClassDef(String string, Occurrence occurrence, ClassDef classDef, JavaVector javaVector, ScopedDef scopedDef) {
        super(string, occurrence, scopedDef);
        if (classDef != null) {
            this.superClass = classDef;
        }
        this.interfaces = javaVector;
    }
}

