/*
 * Decompiled with CFR 0.152.
 */
package javasrc.symtab;

import java.util.Enumeration;
import java.util.Hashtable;
import javasrc.symtab.ClassDef;
import javasrc.symtab.Definition;
import javasrc.symtab.DummyClass;
import javasrc.symtab.HTMLTagContainer;
import javasrc.symtab.SymbolTable;
import javasrc.symtab.Taggable;
import javasrc.symtab.Visitor;

class JavaHashtable
extends Hashtable {
    private static final int CLASS = 0;
    private static final int INTERFACE = 1;
    private static final int EITHER = 2;
    private boolean resolving = false;
    private boolean resolvingRefs = false;

    void tagElements(HTMLTagContainer hTMLTagContainer) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            ((Taggable)enumeration.nextElement()).generateTags(hTMLTagContainer);
        }
    }

    void resolveTypes(SymbolTable symbolTable) {
        if (!this.resolving) {
            this.resolving = true;
            Enumeration enumeration = this.elements();
            while (enumeration.hasMoreElements()) {
                Definition definition = (Definition)enumeration.nextElement();
                if (definition instanceof DummyClass) {
                    if (definition.getName().endsWith("SymbolTable")) {
                        new Exception().printStackTrace();
                    }
                    System.out.println("Resolving DummyClass:" + definition.getName());
                    String string = ((DummyClass)definition).getPackage();
                    System.out.println("pkg " + string);
                    ClassDef classDef = symbolTable.lookupDummy(definition);
                    System.out.println("newD = " + classDef);
                    if (classDef == null) continue;
                    classDef.addReference(definition.getOccurrence());
                    this.remove(definition.getName());
                    this.put(definition.getName(), classDef);
                    continue;
                }
                definition.resolveTypes(symbolTable);
            }
        }
    }

    void resolveRefs(SymbolTable symbolTable) {
        if (!this.resolvingRefs) {
            this.resolvingRefs = true;
            Enumeration enumeration = this.elements();
            while (enumeration.hasMoreElements()) {
                Definition definition = (Definition)enumeration.nextElement();
                definition.resolveRefs(symbolTable);
            }
        }
    }

    public void accept(Visitor visitor) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Definition definition = (Definition)enumeration.nextElement();
            definition.accept(visitor);
        }
    }

    JavaHashtable() {
    }
}

