/*
 * Decompiled with CFR 0.152.
 */
package javasrc.symtab;

import java.io.Externalizable;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import java.util.Vector;
import javasrc.symtab.ClassDef;
import javasrc.symtab.ClassDefProxy;
import javasrc.symtab.Definition;
import javasrc.symtab.DummyClass;
import javasrc.symtab.HTMLTagContainer;
import javasrc.symtab.Occurrence;
import javasrc.symtab.PrimitiveDef;
import javasrc.symtab.SymbolTable;
import javasrc.symtab.Taggable;
import javasrc.symtab.Visitor;
import javasrc.xref.JavaToken;

public class JavaVector
extends Vector
implements Externalizable {
    private boolean resolvingRefs = false;
    private boolean resolvingTypes = false;

    public void addElement(Definition definition) {
        super.addElement(definition);
        if (definition == null) {
            throw new IllegalArgumentException("null element added to vector");
        }
    }

    public Definition getElement(String string) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Definition definition = (Definition)enumeration.nextElement();
            if (!definition.getName().equals(string)) continue;
            return definition;
        }
        return null;
    }

    void generateTags(HTMLTagContainer hTMLTagContainer) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            ((Taggable)enumeration.nextElement()).generateTags(hTMLTagContainer);
        }
    }

    void generateReferences(FileWriter fileWriter) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof Definition)) continue;
            Definition definition = (Definition)e;
            definition.generateReferences(fileWriter);
        }
    }

    public void resolveRefs(SymbolTable symbolTable) {
        if (!this.resolvingRefs) {
            this.resolvingRefs = true;
            Enumeration enumeration = this.elements();
            while (enumeration.hasMoreElements()) {
                JavaToken javaToken = (JavaToken)((Object)enumeration.nextElement());
                Definition definition = symbolTable.lookup(javaToken.getText(), javaToken.getParamCount(), null);
                if (definition == null) {
                    definition = symbolTable.findPackage(javaToken.getText());
                }
                if (definition == null) continue;
                definition.addReference(new Occurrence(javaToken.getFile(), javaToken.getLine(), javaToken.getColumn(), javaToken.getPackageName(), javaToken.getClassName(), javaToken.getMethodName()));
                definition.resolveRefs(symbolTable);
            }
        }
    }

    public void resolveTypes(SymbolTable symbolTable) {
        if (!this.resolvingTypes) {
            this.resolvingTypes = true;
            Enumeration enumeration = this.elements();
            while (enumeration.hasMoreElements()) {
                Definition definition = (Definition)enumeration.nextElement();
                if (definition instanceof DummyClass) {
                    String string = ((DummyClass)definition).getPackage();
                    ClassDef classDef = symbolTable.lookupDummy(definition);
                    if (classDef == null) continue;
                    classDef.addReference(definition.getOccurrence());
                    this.removeElement(definition);
                    this.addElement(classDef);
                    continue;
                }
                definition.resolveTypes(symbolTable);
            }
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        Vector<Definition> vector = new Vector<Definition>();
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Definition definition = (Definition)enumeration.nextElement();
            if (definition instanceof ClassDef && !(definition instanceof ClassDefProxy) && !(definition instanceof PrimitiveDef) && !(definition instanceof DummyClass)) {
                definition = new ClassDefProxy((ClassDef)definition);
            }
            vector.addElement(definition);
        }
        objectOutput.writeObject(vector);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Vector vector = (Vector)objectInput.readObject();
        this.addAll(vector);
    }

    public void accept(Visitor visitor) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Definition definition = (Definition)enumeration.nextElement();
            definition.accept(visitor);
        }
    }
}

