/*
 * Decompiled with CFR 0.152.
 */
package javasrc.symtab;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javasrc.symtab.ClassDef;
import javasrc.symtab.ClassDefProxy;
import javasrc.symtab.ClassTag;
import javasrc.symtab.Definition;
import javasrc.symtab.DummyClass;
import javasrc.symtab.HTMLTag;
import javasrc.symtab.HTMLTagContainer;
import javasrc.symtab.JavaHashtable;
import javasrc.symtab.Occurrence;
import javasrc.symtab.ReferencePersistor;
import javasrc.symtab.ScopedDef;
import javasrc.symtab.SymbolTable;
import javasrc.symtab.Visitor;

public class PackageDef
extends ScopedDef
implements Serializable {
    private static String _currentPackPath;
    private Hashtable persistedDefs;

    public Hashtable getDefinitions() {
        return this.getElements();
    }

    public void persistDefinitions(String string) {
        File file = null;
        Vector vector = new Vector(20, 20);
        if (this.hasElements()) {
            JavaHashtable javaHashtable = this.getElements();
            Enumeration enumeration = javaHashtable.elements();
            while (enumeration.hasMoreElements()) {
                Definition definition = (Definition)enumeration.nextElement();
                String string2 = string + File.separatorChar + definition.getPackagePath();
                if (definition instanceof ClassDefProxy || definition instanceof DummyClass) continue;
                try {
                    String string3 = string2 + File.separatorChar + definition.getName() + ".def";
                    file = new File(string3);
                    new File(file.getParent()).mkdirs();
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                    objectOutputStream.writeObject(definition);
                    objectOutputStream.flush();
                    objectOutputStream.close();
                    fileOutputStream.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public void persistReferences(String string) {
        ReferencePersistor referencePersistor = new ReferencePersistor(string);
        this.accept(referencePersistor);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
        if (this.elements != null) {
            this.elements.accept(visitor);
        }
    }

    public Vector generateClassList() {
        Vector<ClassTag> vector = null;
        if (this.hasElements()) {
            vector = new Vector<ClassTag>(2);
            JavaHashtable javaHashtable = this.getElements();
            Enumeration enumeration = javaHashtable.elements();
            while (enumeration.hasMoreElements()) {
                Definition definition = (Definition)enumeration.nextElement();
                if (!(definition instanceof ClassDef)) continue;
                Occurrence occurrence = definition.getOccurrence();
                SymbolTable.addFileClassDef(occurrence.getFile(), (ClassDef)definition);
                String string = occurrence.getFile().getName();
                string = string.substring(0, string.lastIndexOf("."));
                String string2 = string + "_java.html";
                if (!string.equals(definition.getName())) {
                    string2 = string2 + "#" + occurrence.getLine();
                }
                String string3 = "<p class=\"classListItem\"><a href=\"" + string2 + "\"" + "TARGET=\"classFrame\">" + definition.getName() + "</a></p>";
                ClassTag classTag = new ClassTag(((ClassDef)definition).getScopedClassName(), string3);
                vector.addElement(classTag);
                ((ClassDef)definition).generateClassList(vector);
            }
        }
        return vector;
    }

    public void generateTags(HTMLTagContainer hTMLTagContainer) {
        if (this.hasElements()) {
            this.tagElements(hTMLTagContainer);
        }
    }

    public HTMLTag getOccurrenceTag(Occurrence occurrence) {
        return null;
    }

    Definition lookup(String string, Class clazz) {
        boolean bl = false;
        Definition definition = super.lookup(string, clazz);
        if (definition == null || definition instanceof DummyClass) {
            ClassDef classDef = ClassDef.findLoadedClass(this.getName(), string);
            if (classDef == null) {
                classDef = this.loadClassDef(string);
            }
            if (classDef != null) {
                definition = new ClassDefProxy(classDef);
                this.elements.put(string, definition);
            }
        }
        return definition;
    }

    public ClassDef loadClassDef(String string) {
        ClassDef classDef = null;
        File file = (File)this.persistedDefs.get(string);
        if (file != null) {
            try {
                System.out.println("loading " + string + " from " + file);
                System.out.flush();
                FileInputStream fileInputStream = new FileInputStream(file);
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                classDef = (ClassDef)objectInputStream.readObject();
                objectInputStream.close();
                fileInputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return classDef;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        JavaHashtable javaHashtable = this.elements;
        this.elements = null;
        objectOutputStream.defaultWriteObject();
        this.elements = javaHashtable;
    }

    public String toString() {
        String string = "------- Package -------\n";
        string = string + super.toString() + "\n";
        if (this.hasElements()) {
            JavaHashtable javaHashtable = this.getElements();
            Enumeration enumeration = javaHashtable.elements();
            while (enumeration.hasMoreElements()) {
                Definition definition = (Definition)enumeration.nextElement();
                string = string + definition.toString() + "\n";
            }
        }
        return string;
    }

    PackageDef(String string, Occurrence occurrence, ScopedDef scopedDef) {
        super(string, occurrence, scopedDef);
        FilenameFilter filenameFilter;
        File file;
        File[] fileArray;
        String string2 = string.replace('.', File.separatorChar);
        this.persistedDefs = new Hashtable();
        if (!string.equals("java.lang") && (fileArray = (file = new File(SymbolTable.getSymbolTable().getOutDirPath() + File.separatorChar + string2)).listFiles(filenameFilter = new FilenameFilter(this){
            private final /* synthetic */ PackageDef this$0;

            public boolean accept(File file, String string) {
                return string.endsWith(".def");
            }
            {
                this.this$0 = packageDef;
                this.constructor$0(packageDef);
            }

            private final void constructor$0(PackageDef packageDef) {
            }
        })) != null) {
            int n = 0;
            while (n < fileArray.length) {
                String string3 = fileArray[n].getName();
                String string4 = string3.substring(0, string3.length() - ".def".length());
                this.persistedDefs.put(string4, fileArray[n]);
                ++n;
            }
        }
    }
}

