/*
 * Decompiled with CFR 0.152.
 */
package javasrc.symtab;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import javasrc.symtab.ClassDef;
import javasrc.symtab.Definition;
import javasrc.symtab.JavaVector;
import javasrc.symtab.MethodDef;
import javasrc.symtab.Occurrence;
import javasrc.symtab.PackageDef;
import javasrc.symtab.PrimitiveDef;
import javasrc.symtab.ReferenceTypes;
import javasrc.symtab.ScopedDef;
import javasrc.symtab.VariableDef;
import javasrc.symtab.Visitor;

public class ReferencePersistor
implements Visitor,
ReferenceTypes {
    private String filePath = null;
    private String outDirPath = null;
    private PrintWriter pw = null;
    private BufferedWriter bw = null;
    private FileWriter fw = null;

    public void done() {
        if (this.pw != null) {
            this.closeWriters();
        }
        this.pw = null;
        this.bw = null;
        this.fw = null;
    }

    public void visit(PackageDef packageDef) {
        if (this.pw != null) {
            this.closeWriters();
        }
        String string = this.outDirPath + File.separatorChar + packageDef.getName().replace('.', File.separatorChar);
        File file = new File(string);
        file.mkdirs();
        this.filePath = string + File.separatorChar + "references.txt";
        try {
            boolean bl = true;
            this.fw = new FileWriter(this.filePath, bl);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.fw = null;
        }
        this.bw = new BufferedWriter(this.fw);
        this.pw = new PrintWriter(this.bw);
        this.pw.println("# ReferentFileClass | ReferentClass | ReferentType | ReferentTag | ReferringPackage | ReferringClass | ReferringMethod | ReferringFile | ReferringLineNumber");
    }

    private String getReferentFileClass(Definition definition) {
        String string = definition.getOccurrence().getFile().getName();
        return string.substring(0, string.length() - ".java".length());
    }

    public void visit(ClassDef classDef) {
        String string;
        if (classDef instanceof PrimitiveDef) {
            return;
        }
        String string2 = this.getReferentFileClass(classDef);
        String string3 = classDef.getClassScopeName();
        if (classDef.getParentScope() instanceof ClassDef) {
            String string4 = classDef.getParentScope().getName();
            string = string4 + "." + classDef.getName();
        } else {
            string = classDef.getName();
        }
        this.persist(string2, "Class", string3, string, classDef);
    }

    public void visit(MethodDef methodDef) {
        String string = this.getReferentFileClass(methodDef);
        String string2 = methodDef.getClassScopeName();
        ScopedDef scopedDef = methodDef.getParentScope();
        ScopedDef scopedDef2 = scopedDef.getParentScope();
        String string3 = scopedDef2 instanceof ClassDef ? scopedDef2.getName() + "." + scopedDef.getName() : scopedDef.getName();
        this.persist(string, "Method", string2, string3, methodDef);
    }

    public void visit(VariableDef variableDef) {
        ScopedDef scopedDef;
        String string = this.getReferentFileClass(variableDef);
        String string2 = variableDef.getClassScopeName();
        ScopedDef scopedDef2 = variableDef.getParentScope();
        ScopedDef scopedDef3 = scopedDef2.getParentScope();
        String string3 = scopedDef2 instanceof MethodDef ? ((scopedDef = scopedDef3.getParentScope()) instanceof ClassDef ? scopedDef.getName() + "." + scopedDef3.getName() : scopedDef3.getName()) : (scopedDef3 instanceof ClassDef ? scopedDef3.getName() + "." + scopedDef2.getName() : scopedDef2.getName());
        this.persist(string, "Variable", string2, string3, variableDef);
    }

    private void persist(String string, String string2, String string3, String string4, Definition definition) {
        JavaVector javaVector = definition.getReferences();
        if (javaVector != null) {
            Enumeration enumeration = javaVector.elements();
            while (enumeration.hasMoreElements()) {
                Occurrence occurrence = (Occurrence)enumeration.nextElement();
                this.persist(string, string2, string3, string4, occurrence);
            }
        }
        this.persist(string, string2, string3, string4, definition.getOccurrence());
    }

    private void persist(String string, String string2, String string3, String string4, Occurrence occurrence) {
        this.pw.print(string);
        this.pw.print("|");
        this.pw.print(string4);
        this.pw.print("|");
        this.pw.print(string3);
        this.pw.print("|");
        this.pw.print(string2);
        this.pw.print("|");
        this.pw.print(occurrence.getPackageName());
        this.pw.print("|");
        this.pw.print(occurrence.getClassName());
        this.pw.print("|");
        this.pw.print(occurrence.getMethodName());
        this.pw.print("|");
        this.pw.print(occurrence.getFile().getName());
        this.pw.print("|");
        this.pw.println(occurrence.getLine());
    }

    private void closeWriters() {
        try {
            this.pw.close();
            this.bw.close();
            this.fw.close();
        }
        catch (IOException iOException) {
            System.err.println("Hell has frozen over.");
            iOException.printStackTrace();
        }
    }

    public ReferencePersistor(String string) {
        this.outDirPath = string;
    }
}

