/*
 * Decompiled with CFR 0.152.
 */
package javasrc.symtab;

import java.util.Hashtable;
import javasrc.symtab.Definition;
import javasrc.symtab.HTMLTag;
import javasrc.symtab.HTMLTagContainer;
import javasrc.symtab.JavaHashtable;
import javasrc.symtab.JavaVector;
import javasrc.symtab.MethodDef;
import javasrc.symtab.MultiDef;
import javasrc.symtab.Occurrence;
import javasrc.symtab.SymbolTable;
import javasrc.xref.JavaToken;

public abstract class ScopedDef
extends Definition {
    public static final boolean debug = false;
    private static int resolveLevel = 0;
    protected JavaHashtable elements = new JavaHashtable();
    private JavaVector unresolvedStuff;
    private boolean iAmDefaultOrBaseScope = false;

    public Hashtable getSymbols() {
        return this.elements;
    }

    void add(Definition definition) {
        Definition definition2 = (Definition)this.elements.get(definition.getName());
        if (definition2 != null) {
            if (!(definition2 instanceof MultiDef)) {
                this.elements.remove(definition2);
                MultiDef multiDef = new MultiDef(definition.getName(), definition2);
                multiDef.addDef(definition2);
                definition2 = multiDef;
                this.elements.put(definition.getName(), definition2);
            }
            ((MultiDef)definition2).addDef(definition);
        } else {
            this.elements.put(definition.getName(), definition);
            definition.setParentScope(this);
        }
    }

    void addUnresolved(JavaToken javaToken) {
        if (this.unresolvedStuff == null) {
            this.unresolvedStuff = new JavaVector();
        }
        this.unresolvedStuff.addElement(javaToken);
    }

    public JavaHashtable getElements() {
        return this.elements;
    }

    boolean hasElements() {
        return !this.elements.isEmpty();
    }

    public boolean isDefaultOrBaseScope() {
        return this.iAmDefaultOrBaseScope;
    }

    Definition lookup(String string, int n, Class clazz) {
        Definition definition = (Definition)this.elements.get(string);
        if (definition instanceof MultiDef) {
            definition = definition.lookup(string, n, clazz);
        } else if (definition instanceof MethodDef && ((MethodDef)definition).getParamCount() != n) {
            definition = null;
        }
        if (definition != null && !definition.isA(clazz)) {
            definition = null;
        }
        return definition;
    }

    void tagElements(HTMLTagContainer hTMLTagContainer) {
        if (this.elements != null) {
            this.elements.tagElements(hTMLTagContainer);
        }
    }

    void resolveTypes(SymbolTable symbolTable) {
        ++resolveLevel;
        symbolTable.pushScope(this);
        this.elements.resolveTypes(symbolTable);
        symbolTable.popScope();
        super.resolveTypes(symbolTable);
        --resolveLevel;
    }

    void resolveRefs(SymbolTable symbolTable) {
        ++resolveLevel;
        symbolTable.pushScope(this);
        if (this.unresolvedStuff != null) {
            this.unresolvedStuff.resolveRefs(symbolTable);
            this.unresolvedStuff = null;
        }
        this.elements.resolveRefs(symbolTable);
        symbolTable.popScope();
        super.resolveRefs(symbolTable);
        --resolveLevel;
    }

    void setDefaultOrBaseScope(boolean bl) {
        this.iAmDefaultOrBaseScope = bl;
    }

    public HTMLTag getOccurrenceTag(Occurrence occurrence) {
        return null;
    }

    public ScopedDef() {
    }

    ScopedDef(String string, Occurrence occurrence, ScopedDef scopedDef) {
        super(string, occurrence, scopedDef);
    }
}

