/*
 * Decompiled with CFR 0.152.
 */
package javasrc.symtab;

import java.io.Externalizable;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import javasrc.symtab.ClassDef;
import javasrc.symtab.ClassDefProxy;
import javasrc.symtab.Definition;
import javasrc.symtab.DummyClass;
import javasrc.symtab.HTMLTag;
import javasrc.symtab.HTMLTagContainer;
import javasrc.symtab.JavaVector;
import javasrc.symtab.MethodDef;
import javasrc.symtab.Occurrence;
import javasrc.symtab.ScopedDef;
import javasrc.symtab.SymbolTable;
import javasrc.symtab.TypedDef;
import javasrc.symtab.Visitor;

public class VariableDef
extends Definition
implements TypedDef,
Externalizable {
    private ClassDef type = null;

    public Definition getType() {
        return this.type;
    }

    public void generateReferences(FileWriter fileWriter) {
        try {
            fileWriter.write("<p class=\"variableReflist\">");
            String string = "<p class=\"variableReflistHeader\">Variable: <a name=" + this.getName() + " href=" + this.getSourceName() + "#" + this.getClassScopeName() + ">" + this.getName() + "</a></p>";
            fileWriter.write(string);
            JavaVector javaVector = this.getReferences();
            Enumeration enumeration = javaVector.elements();
            while (enumeration.hasMoreElements()) {
                Occurrence occurrence = (Occurrence)enumeration.nextElement();
                if (occurrence == null) continue;
                String string2 = this.getOccurrencePath(occurrence) + occurrence.getLinkReference();
                String string3 = "<p class=\"variableRefItem\"><a href=" + string2 + ">" + this.getName() + " in " + occurrence.getPackageName() + "." + occurrence.getClassName() + "." + occurrence.getMethodName() + " (" + occurrence.getFile().getName() + ":" + Integer.toString(occurrence.getLine()) + ")</a></p>\n";
                fileWriter.write(string3);
            }
            fileWriter.write("</p>");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void generateTags(HTMLTagContainer hTMLTagContainer) {
        String string = "<a class=\"varDef\" name=" + this.getClassScopeName() + " href=" + this.getRefName() + "#" + this.getClassScopeName() + ">" + this.getName() + "</a>";
        if (this.getOccurrence() == null) {
            return;
        }
        HTMLTag hTMLTag = new HTMLTag(this.getOccurrence(), this.getName(), string);
        hTMLTagContainer.addElement(hTMLTag);
    }

    public HTMLTag getOccurrenceTag(Occurrence occurrence) {
        String string = this.getRelativePath(occurrence) + this.getSourceName();
        String string2 = "<a class=\"varRef\" title=\"" + this.getType().getName() + "\" " + "href=" + string + "#" + this.getClassScopeName() + ">" + this.getName() + "</a>";
        HTMLTag hTMLTag = new HTMLTag(occurrence, this.getName(), string2);
        return hTMLTag;
    }

    void resolveTypes(SymbolTable symbolTable) {
        ClassDef classDef;
        if (this.type != null && this.type instanceof DummyClass && (classDef = symbolTable.lookupDummy(this.type)) != null) {
            classDef.addReference(this.type.getOccurrence());
            this.type = classDef;
        }
        super.resolveTypes(symbolTable);
    }

    String getClassScopeName() {
        String string;
        ScopedDef scopedDef = this.getParentScope();
        ScopedDef scopedDef2 = scopedDef.getParentScope();
        if (scopedDef instanceof MethodDef) {
            ScopedDef scopedDef3 = scopedDef2.getParentScope();
            string = scopedDef3 instanceof ClassDef ? scopedDef3.getName() + "." + scopedDef2.getName() : scopedDef2.getName();
            string = string + "." + scopedDef.getName();
        } else {
            string = scopedDef2 instanceof ClassDef ? scopedDef2.getName() + "." + scopedDef.getName() : scopedDef.getName();
        }
        string = string + "." + this.getName();
        return string;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.getName());
        ScopedDef scopedDef = this.getParentScope();
        if (!(scopedDef instanceof MethodDef)) {
            scopedDef = new ClassDefProxy((ClassDef)scopedDef);
        }
        objectOutput.writeObject(scopedDef);
        objectOutput.writeObject(this.getOccurrence());
        ClassDef classDef = this.type instanceof DummyClass ? this.type : new ClassDefProxy(this.type);
        objectOutput.writeObject(classDef);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.setName((String)objectInput.readObject());
        SymbolTable.startReadExternal("VariableDef " + this.getName());
        this.setParentScope((ScopedDef)objectInput.readObject());
        this.setOccurrence((Occurrence)objectInput.readObject());
        this.type = (ClassDef)objectInput.readObject();
        this.setupFileNames();
        SymbolTable.endReadExternal();
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public VariableDef() {
    }

    VariableDef(String string, Occurrence occurrence, ClassDef classDef, ScopedDef scopedDef) {
        super(string, occurrence, scopedDef);
        this.type = classDef;
    }
}

