/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.commandline;

import de.java2html.commandline.IllegalCommandlineParametersException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CommandlineArguments {
    private Map valueByParameterName = new HashMap();
    private Set flags = new HashSet();

    public CommandlineArguments(String[] args) throws IllegalCommandlineParametersException {
        int i = 0;
        while (i < args.length) {
            if (this.isValidFlagName(args[i])) {
                String flagName = args[i].substring(1).toLowerCase();
                String value = null;
                if (i + 1 < args.length && !this.isValidFlagName(args[i + 1])) {
                    value = args[i + 1];
                    ++i;
                }
                if (this.flags.contains(flagName) || this.valueByParameterName.containsKey(flagName)) {
                    throw new IllegalCommandlineParametersException("Argument '" + flagName + "' has been defined more often than once.");
                }
                if (value == null) {
                    this.flags.add(flagName);
                } else {
                    this.valueByParameterName.put(flagName, value);
                }
            } else {
                throw new IllegalCommandlineParametersException("Unexpected parameter '" + args[i] + "'");
            }
            ++i;
        }
    }

    private boolean isValidFlagName(String name) {
        if (!name.startsWith("-")) {
            return false;
        }
        try {
            Double.parseDouble(name);
            return false;
        }
        catch (NumberFormatException numberFormatException) {
            return true;
        }
    }

    public String getParameterStringValue(String parameterName) {
        return (String)this.valueByParameterName.get(parameterName.toLowerCase());
    }

    public String getParameterStringValue(String parameterName, String defaultValue) {
        String value = this.getParameterStringValue(parameterName);
        return value != null ? value : defaultValue;
    }

    public int getParameterPositiveIntValue(String parameterName, int defaultValue) throws IllegalCommandlineParametersException {
        String value = this.getParameterStringValue(parameterName);
        if (value == null) {
            return defaultValue;
        }
        int i = this.parseInt(value);
        if (i < 0) {
            throw new IllegalCommandlineParametersException("Positive value for int argument expected, was '" + value + "'");
        }
        return i;
    }

    private int parseInt(String value) throws IllegalCommandlineParametersException {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalCommandlineParametersException("Illegal format for a int value '" + value + "'");
        }
    }

    public boolean isFlagSet(String flagName) {
        return this.flags.contains(flagName.toLowerCase());
    }

    public boolean isParameterSet(String flagName) {
        return this.valueByParameterName.containsKey(flagName.toLowerCase());
    }

    public String getRequiredParameterStringValue(String parameterName) throws IllegalCommandlineParametersException {
        String value = this.getParameterStringValue(parameterName);
        if (value == null) {
            throw new IllegalCommandlineParametersException("Missing required parameter value for '" + parameterName + "'");
        }
        return value;
    }

    public void assertContainsNoUnsupportedFlags(String[] supportedFlagNames) throws IllegalCommandlineParametersException {
        Set supportedFlagNameSet = this.createLowerCaseNameSet(supportedFlagNames);
        Iterator iterator = this.flags.iterator();
        while (iterator.hasNext()) {
            String flagName = (String)iterator.next();
            if (supportedFlagNameSet.contains(flagName)) continue;
            throw new IllegalCommandlineParametersException("The flag '" + flagName + "' is not supported (or missing required parameter value).");
        }
    }

    public void assertContainsNoUnsupportedParameters(String[] supportedParameterNames) throws IllegalCommandlineParametersException {
        Set supportedParameterNameSet = this.createLowerCaseNameSet(supportedParameterNames);
        Iterator iterator = this.valueByParameterName.keySet().iterator();
        while (iterator.hasNext()) {
            String flagName = (String)iterator.next();
            if (supportedParameterNameSet.contains(flagName)) continue;
            throw new IllegalCommandlineParametersException("The parameter '" + flagName + "' is not supported.");
        }
    }

    private Set createLowerCaseNameSet(String[] names) {
        HashSet<String> supportedFlagNameSet = new HashSet<String>();
        int i = 0;
        while (i < names.length) {
            supportedFlagNameSet.add(names[i].toLowerCase());
            ++i;
        }
        return supportedFlagNameSet;
    }
}

