/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.commandline;

import de.java2html.commandline.AbstractJava2HtmlConversion;
import de.java2html.converter.JavaSourceConverter;
import de.java2html.util.Ensure;
import de.java2html.util.IoUtilities;
import java.io.File;
import java.io.IOException;

public class Java2HtmlDirectoryConversion
extends AbstractJava2HtmlConversion {
    private File sourceDirectory;
    private File targetDirectory;
    private String fileMask;
    private boolean copyUnprocessedFiles;

    public Java2HtmlDirectoryConversion(File sourceDirectory, JavaSourceConverter converter, File targetDirectory, String fileMask, boolean copyUnprocessedFiles) {
        super(converter);
        Ensure.ensureArgumentNotNull(fileMask);
        Ensure.ensureArgumentNotNull(sourceDirectory);
        this.sourceDirectory = sourceDirectory;
        if (targetDirectory == null) {
            targetDirectory = sourceDirectory;
        }
        this.targetDirectory = targetDirectory;
        this.fileMask = fileMask;
        this.copyUnprocessedFiles = copyUnprocessedFiles;
    }

    public void execute() {
        this.convertDirectory(this.sourceDirectory, this.targetDirectory);
    }

    private void convertDirectory(File sourceDirectory, File targetDirectory) {
        File[] files = sourceDirectory.listFiles();
        int i = 0;
        while (i < files.length) {
            File targetFile;
            File file = files[i];
            if (file.isDirectory()) {
                File newTargetDirectory = null;
                newTargetDirectory = sourceDirectory.equals(targetDirectory) ? file : new File(targetDirectory, file.getAbsolutePath().substring(sourceDirectory.getAbsolutePath().length()));
                this.convertDirectory(file, newTargetDirectory);
            } else if (this.matches(file)) {
                targetFile = null;
                targetFile = sourceDirectory.equals(targetDirectory) ? file : new File(targetDirectory, file.getAbsolutePath().substring(sourceDirectory.getAbsolutePath().length()));
                targetFile = IoUtilities.exchangeFileExtension(targetFile, this.getConverter().getDefaultFileExtension());
                this.convertFile(file, targetFile);
            } else if (this.copyUnprocessedFiles && !sourceDirectory.equals(targetDirectory)) {
                targetFile = new File(targetDirectory, file.getAbsolutePath().substring(sourceDirectory.getAbsolutePath().length()));
                try {
                    IoUtilities.copy(file, targetFile);
                }
                catch (IOException iOException) {
                    System.err.println("ERROR: Could cot copy file to target:  " + file.getAbsolutePath());
                }
            }
            ++i;
        }
    }

    private boolean matches(File file) {
        return file.getAbsolutePath().toLowerCase().endsWith(this.fileMask.substring(1));
    }
}

