/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.gui;

import java.awt.Font;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class GTextArea
extends TextArea
implements KeyListener,
MouseListener {
    private boolean searching;
    private String search;
    private String text;
    private int direction;
    private static final int FORWARDS = 1;
    private static final int BACKWARDS = 2;
    private boolean hardEditable = true;

    public GTextArea() {
        this.init();
    }

    public GTextArea(String text) {
        super(text);
        this.init();
    }

    public GTextArea(String text, int scrollbars) {
        super(text, 0, 0, scrollbars);
        this.init();
    }

    public GTextArea(int rows, int columns) {
        super(rows, columns);
        this.init();
    }

    public GTextArea(String text, int rows, int columns) {
        super(text, rows, columns);
        this.init();
    }

    public GTextArea(String text, int rows, int columns, int scrollbars) {
        super(text, rows, columns, scrollbars);
        this.init();
    }

    private void init() {
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.searching = false;
        this.search = "";
    }

    public boolean isFocusTraversable() {
        return this.hardEditable;
    }

    public synchronized void setEditable(boolean b) {
        this.hardEditable = b;
        if (this.searching) {
            this.stopSearch();
        } else {
            super.setEditable(b);
        }
    }

    private void fontSizeUp() {
        Font f = this.getFont();
        int s = f.getSize() + 1;
        if (s > 30) {
            return;
        }
        Font f2 = new Font(f.getName(), f.getStyle(), s);
        this.setFont(f2);
        this.repaint();
    }

    private void fontSizeDown() {
        Font f = this.getFont();
        int s = f.getSize() - 1;
        if (s < 4) {
            return;
        }
        Font f2 = new Font(f.getName(), f.getStyle(), s);
        this.setFont(f2);
        this.repaint();
    }

    private void stopSearch() {
        this.searching = false;
        super.setEditable(this.hardEditable);
    }

    private void startSearch() {
        this.text = this.getText().toLowerCase();
        this.searching = true;
        this.search = "";
        super.setEditable(false);
    }

    private void findNext(String pat) {
        int a;
        int pos = this.getCaretPosition();
        if (this.getSelectionEnd() - this.getSelectionStart() == pat.length()) {
            ++pos;
        }
        if ((a = this.text.indexOf(pat, pos)) == -1) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        this.search = pat;
        this.setSelectionStart(a);
        this.setSelectionEnd(a + this.search.length());
    }

    private void findPrev(String pat) {
        int a;
        int pos = this.getCaretPosition();
        if (this.getSelectionEnd() - this.getSelectionStart() == pat.length()) {
            --pos;
        }
        if ((a = this.text.lastIndexOf(pat, pos)) == -1) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        this.search = pat;
        this.setSelectionStart(a);
        this.setSelectionEnd(a + this.search.length());
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (e.isControlDown()) {
            if (e.getKeyChar() == '9') {
                this.fontSizeUp();
            } else if (e.getKeyChar() == '8') {
                this.fontSizeDown();
            }
        }
        if (!this.searching) {
            return;
        }
        if (e.getKeyCode() == 39 || e.getKeyCode() == 37 || e.getKeyCode() == 40 || e.getKeyCode() == 38 || e.getKeyCode() == 27) {
            this.stopSearch();
            return;
        }
        if (e.getKeyCode() == 8) {
            if (this.search.length() <= 1) {
                this.stopSearch();
                e.consume();
                return;
            }
            this.search = this.search.substring(0, this.search.length() - 1);
            if (this.direction == 2) {
                this.findPrev(this.search);
            } else {
                this.findNext(this.search);
            }
            e.consume();
            return;
        }
    }

    public void keyTyped(KeyEvent e) {
        if (e.isControlDown()) {
            if (e.getKeyChar() == '\u0001') {
                this.stopSearch();
                this.selectAll();
                e.consume();
            } else if (e.getKeyChar() == '\u0012') {
                this.direction = 2;
                if (this.searching) {
                    this.findPrev(this.search);
                } else {
                    this.startSearch();
                }
                e.consume();
            } else if (e.getKeyChar() == '\u0013') {
                this.direction = 1;
                if (this.searching) {
                    this.findNext(this.search);
                } else {
                    this.startSearch();
                }
                e.consume();
            } else {
                this.stopSearch();
            }
            return;
        }
        if (!this.searching) {
            return;
        }
        char ch = e.getKeyChar();
        if (ch == '\b') {
            e.consume();
            return;
        }
        if (!Character.isJavaIdentifierPart(ch) && " @|<>!\"\u00a7$%&/()=?`\u00b4*+^\u00b0~#\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc-+[]{}\u00b5,.;:'\u00b2\u00b3\\\u00df".indexOf(ch) == -1) {
            this.stopSearch();
            e.consume();
            return;
        }
        ch = Character.toLowerCase(ch);
        if (this.direction == 2) {
            this.findPrev(String.valueOf(this.search) + ch);
        } else {
            this.findNext(String.valueOf(this.search) + ch);
        }
    }

    public void mouseClicked(MouseEvent e) {
        this.stopSearch();
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }
}

