/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.javasource.test;

import de.java2html.javasource.JavaSource;
import de.java2html.javasource.JavaSourceIterator;
import de.java2html.javasource.JavaSourceRun;
import de.java2html.javasource.JavaSourceType;
import de.java2html.javasource.test.JavaSourceParserTestCase;
import java.io.IOException;
import java.util.NoSuchElementException;
import junit.framework.Assert;
import junit.framework.TestCase;

public class JavaSourceIteratorTest
extends TestCase {
    public void testEmpty() throws IOException {
        JavaSource source = JavaSourceParserTestCase.doParse("");
        JavaSourceIterator iterator = source.getIterator();
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testFirstIsNewLine() throws IOException {
        JavaSource source = JavaSourceParserTestCase.doParse("\na");
        JavaSourceIterator iterator = source.getIterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        JavaSourceRun run = iterator.getNext();
        Assert.assertEquals((String)"", (String)run.getCode());
        Assert.assertTrue((boolean)run.isAtStartOfLine());
        Assert.assertTrue((boolean)run.isAtEndOfLine());
        Assert.assertEquals((Object)JavaSourceType.BACKGROUND, (Object)run.getType());
        Assert.assertTrue((boolean)iterator.hasNext());
        run = iterator.getNext();
        Assert.assertEquals((String)"a", (String)run.getCode());
        Assert.assertTrue((boolean)run.isAtStartOfLine());
        Assert.assertTrue((boolean)run.isAtEndOfLine());
        Assert.assertEquals((Object)JavaSourceType.CODE, (Object)run.getType());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testSingle() throws IOException {
        JavaSource source = JavaSourceParserTestCase.doParse("a");
        JavaSourceIterator iterator = source.getIterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        JavaSourceRun run = iterator.getNext();
        Assert.assertEquals((String)"a", (String)run.getCode());
        Assert.assertTrue((boolean)run.isAtStartOfLine());
        Assert.assertTrue((boolean)run.isAtEndOfLine());
        Assert.assertEquals((Object)JavaSourceType.CODE, (Object)run.getType());
        Assert.assertFalse((boolean)iterator.hasNext());
        try {
            iterator.next();
            Assert.fail();
        }
        catch (NoSuchElementException noSuchElementException) {}
    }

    public void testTwoLines() throws IOException {
        JavaSource source = JavaSourceParserTestCase.doParse("a\nb");
        JavaSourceIterator iterator = source.getIterator();
        JavaSourceRun run = iterator.getNext();
        Assert.assertEquals((String)"a", (String)run.getCode());
        Assert.assertTrue((boolean)run.isAtStartOfLine());
        Assert.assertTrue((boolean)run.isAtEndOfLine());
        Assert.assertEquals((Object)JavaSourceType.CODE, (Object)run.getType());
        Assert.assertTrue((boolean)iterator.hasNext());
        run = iterator.getNext();
        Assert.assertEquals((String)"b", (String)run.getCode());
        Assert.assertTrue((boolean)run.isAtStartOfLine());
        Assert.assertTrue((boolean)run.isAtEndOfLine());
        Assert.assertEquals((Object)JavaSourceType.CODE, (Object)run.getType());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void test1() throws IOException {
        JavaSource source = JavaSourceParserTestCase.doParse("public String text =\"test\";");
        JavaSourceIterator iterator = source.getIterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        JavaSourceRun run = iterator.getNext();
        Assert.assertEquals((String)"public ", (String)run.getCode());
        Assert.assertTrue((boolean)run.isAtStartOfLine());
        Assert.assertFalse((boolean)run.isAtEndOfLine());
        Assert.assertEquals((Object)JavaSourceType.KEYWORD, (Object)run.getType());
        Assert.assertTrue((boolean)iterator.hasNext());
        run = iterator.getNext();
        Assert.assertEquals((String)"String text =", (String)run.getCode());
        Assert.assertFalse((boolean)run.isAtStartOfLine());
        Assert.assertFalse((boolean)run.isAtEndOfLine());
        Assert.assertEquals((Object)JavaSourceType.CODE, (Object)run.getType());
        Assert.assertTrue((boolean)iterator.hasNext());
        run = iterator.getNext();
        Assert.assertEquals((String)"\"test\"", (String)run.getCode());
        Assert.assertFalse((boolean)run.isAtStartOfLine());
        Assert.assertFalse((boolean)run.isAtEndOfLine());
        Assert.assertEquals((Object)JavaSourceType.STRING, (Object)run.getType());
        Assert.assertTrue((boolean)iterator.hasNext());
        run = iterator.getNext();
        Assert.assertEquals((String)";", (String)run.getCode());
        Assert.assertFalse((boolean)run.isAtStartOfLine());
        Assert.assertTrue((boolean)run.isAtEndOfLine());
        Assert.assertEquals((Object)JavaSourceType.CODE, (Object)run.getType());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testEmptyLinesAreEmptyRuns() throws IOException {
        JavaSource source = JavaSourceParserTestCase.doParse("public\n\ntest");
        JavaSourceIterator iterator = source.getIterator();
        JavaSourceRun run = iterator.getNext();
        Assert.assertEquals((String)"public", (String)run.getCode());
        run = iterator.getNext();
        Assert.assertEquals((String)"", (String)run.getCode());
        run = iterator.getNext();
        Assert.assertEquals((String)"test", (String)run.getCode());
        Assert.assertFalse((boolean)iterator.hasNext());
    }
}

