/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.options;

import de.java2html.options.HorizontalAlignment;
import de.java2html.options.JavaSourceStyleTable;
import de.java2html.properties.ConversionOptionsPropertiesReader;
import de.java2html.util.Ensure;
import de.java2html.util.IllegalConfigurationException;
import de.java2html.util.IoUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class Java2HtmlConversionOptions {
    private static final String PROPERTIES_FILE_NAME = "java2html.properties";
    public static final String TAB_SIZE = "TAB_SIZE";
    public static final String SHOW_LINE_NUMBERS = "showLineNumbers";
    public static final String SHOW_FILE_NAME = "showFileName";
    public static final String SHOW_TABLE_BORDER = "showTableBorder";
    private static Java2HtmlConversionOptions defaultOptions;
    private JavaSourceStyleTable styleTable = JavaSourceStyleTable.getDefault();
    private int tabSize = 2;
    private boolean showLineNumbers = false;
    private boolean showFileName = false;
    private boolean showTableBorder = false;
    private boolean showJava2HtmlLink = false;
    private boolean addLineAnchors = false;
    private String lineAnchorPrefix = "";
    private HorizontalAlignment horizontalAlignment = HorizontalAlignment.LEFT;
    static /* synthetic */ Class class$0;

    public static Java2HtmlConversionOptions getRawDefault() {
        return new Java2HtmlConversionOptions();
    }

    public static Java2HtmlConversionOptions getDefault() throws IllegalConfigurationException {
        if (defaultOptions == null) {
            defaultOptions = Java2HtmlConversionOptions.createDefaultOptions();
        }
        return defaultOptions.getClone();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Java2HtmlConversionOptions createDefaultOptions() throws IllegalConfigurationException {
        Java2HtmlConversionOptions java2HtmlConversionOptions;
        InputStream inputStream;
        Class<?> clazz = class$0;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("de.java2html.options.Java2HtmlConversionOptions");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$0 = clazz2;
        }
        if ((inputStream = clazz.getClassLoader().getResourceAsStream(PROPERTIES_FILE_NAME)) == null) {
            return new Java2HtmlConversionOptions();
        }
        Properties properties = new Properties();
        try {
            try {
                properties.load(inputStream);
                java2HtmlConversionOptions = new ConversionOptionsPropertiesReader().read(properties);
                Object var3_3 = null;
            }
            catch (IOException exception) {
                throw new IllegalConfigurationException("Error loading configuration file 'java2html.properties' from classpath", exception);
            }
            catch (IllegalArgumentException exception) {
                throw new IllegalConfigurationException("Error loading configuration file 'java2html.properties' from classpath", exception);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            IoUtilities.close(inputStream);
            throw throwable;
        }
        IoUtilities.close(inputStream);
        return java2HtmlConversionOptions;
    }

    private Java2HtmlConversionOptions() {
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Java2HtmlConversionOptions)) {
            return false;
        }
        Java2HtmlConversionOptions other = (Java2HtmlConversionOptions)obj;
        return other.tabSize == this.tabSize && other.styleTable.equals(this.styleTable) && other.showFileName == this.showFileName && other.showJava2HtmlLink == this.showJava2HtmlLink && other.showLineNumbers == this.showLineNumbers && other.showTableBorder == this.showTableBorder && other.horizontalAlignment == this.horizontalAlignment;
    }

    public int hashCode() {
        return this.styleTable.hashCode() + this.tabSize;
    }

    public Java2HtmlConversionOptions getClone() {
        Java2HtmlConversionOptions options = new Java2HtmlConversionOptions();
        options.styleTable = this.styleTable.getClone();
        options.tabSize = this.tabSize;
        options.showLineNumbers = this.showLineNumbers;
        options.showFileName = this.showFileName;
        options.showJava2HtmlLink = this.showJava2HtmlLink;
        options.showTableBorder = this.showTableBorder;
        options.horizontalAlignment = this.horizontalAlignment;
        return options;
    }

    public void setStyleTable(JavaSourceStyleTable styleTable) {
        Ensure.ensureArgumentNotNull(styleTable);
        this.styleTable = styleTable;
    }

    public JavaSourceStyleTable getStyleTable() {
        return this.styleTable;
    }

    public int getTabSize() {
        return this.tabSize;
    }

    public void setTabSize(int tabSize) {
        this.tabSize = tabSize;
    }

    public boolean isShowLineNumbers() {
        return this.showLineNumbers;
    }

    public void setShowLineNumbers(boolean showLineNumbers) {
        this.showLineNumbers = showLineNumbers;
    }

    public boolean isShowFileName() {
        return this.showFileName;
    }

    public boolean isShowTableBorder() {
        return this.showTableBorder;
    }

    public void setShowFileName(boolean showFileName) {
        this.showFileName = showFileName;
    }

    public void setShowTableBorder(boolean showTableBorder) {
        this.showTableBorder = showTableBorder;
    }

    public boolean isAddLineAnchors() {
        return this.addLineAnchors;
    }

    public String getLineAnchorPrefix() {
        return this.lineAnchorPrefix;
    }

    public void setAddLineAnchors(boolean addLineAnchors) {
        this.addLineAnchors = addLineAnchors;
    }

    public void setLineAnchorPrefix(String lineAnchorPrefix) {
        this.lineAnchorPrefix = lineAnchorPrefix;
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        Ensure.ensureArgumentNotNull(horizontalAlignment);
        this.horizontalAlignment = horizontalAlignment;
    }

    public boolean isShowJava2HtmlLink() {
        return this.showJava2HtmlLink;
    }

    public void setShowJava2HtmlLink(boolean isShowJava2HtmlLink) {
        this.showJava2HtmlLink = isShowJava2HtmlLink;
    }
}

