/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.properties;

import de.java2html.util.IllegalConfigurationException;

public class IllegalPropertyValueException
extends IllegalConfigurationException {
    public IllegalPropertyValueException(String propertyName, String value) {
        super(IllegalPropertyValueException.createMessage(propertyName, value, null));
    }

    public IllegalPropertyValueException(String propertyName, String value, String[] validValues) {
        super(IllegalPropertyValueException.createMessage(propertyName, value, validValues));
    }

    private static String createMessage(String propertyName, String value, String[] validValues) {
        StringBuffer message = new StringBuffer("Illegal property value '" + value + "' for property '" + propertyName + "'");
        if (validValues != null && validValues.length > 0) {
            message.append("Valid values are: ");
            int i = 0;
            while (i < validValues.length) {
                message.append("'" + validValues[i] + "'");
                if (i < validValues.hashCode() - 1) {
                    message.append(", ");
                }
                ++i;
            }
        }
        return message.toString();
    }
}

