/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.properties.test;

import de.java2html.javasource.JavaSourceType;
import de.java2html.options.HorizontalAlignment;
import de.java2html.options.Java2HtmlConversionOptions;
import de.java2html.options.JavaSourceStyleTable;
import de.java2html.properties.ConversionOptionsPropertiesReader;
import de.java2html.properties.IllegalPropertyValueException;
import de.java2html.util.RGB;
import java.util.Properties;
import junit.framework.Assert;
import junit.framework.TestCase;

public class ConversionOptionsPropertiesReaderTest
extends TestCase {
    private ConversionOptionsPropertiesReader reader;

    protected void setUp() throws Exception {
        this.reader = new ConversionOptionsPropertiesReader();
    }

    public void testReadingEmptyProperties() throws IllegalPropertyValueException {
        Properties properties = new Properties();
        Java2HtmlConversionOptions options = this.reader.read(properties);
        Assert.assertEquals((Object)Java2HtmlConversionOptions.getDefault(), (Object)options);
    }

    public void testUnknownPropertyIgnored() throws IllegalPropertyValueException {
        Properties properties = new Properties();
        properties.setProperty("_unsupportedkey_", "value");
        Java2HtmlConversionOptions options = this.reader.read(properties);
        Assert.assertEquals((Object)Java2HtmlConversionOptions.getDefault(), (Object)options);
    }

    public void testReadDefaultStyleTableName() throws IllegalPropertyValueException {
        Properties properties = new Properties();
        properties.put("defaultStyleName", JavaSourceStyleTable.getDefaultKawaStyleTable().getName());
        Java2HtmlConversionOptions options = this.reader.read(properties);
        Assert.assertEquals((Object)JavaSourceStyleTable.getDefaultKawaStyleTable(), (Object)options.getStyleTable());
    }

    public void testReadIllegalDefaultStyleTableName() {
        Properties properties = new Properties();
        properties.put("defaultStyleName", "not_existing_" + JavaSourceStyleTable.getDefaultKawaStyleTable().getName());
        this.assertParsingPropertiesFails(properties);
    }

    private void assertParsingPropertiesFails(Properties properties) {
        try {
            this.reader.read(properties);
            Assert.fail();
        }
        catch (IllegalPropertyValueException illegalPropertyValueException) {}
    }

    public void testTabSize() throws IllegalPropertyValueException {
        Properties properties = new Properties();
        properties.put("TAB_SIZE", "9");
        Java2HtmlConversionOptions options = this.reader.read(properties);
        Assert.assertEquals((int)9, (int)options.getTabSize());
    }

    public void testIllegalTabSize() {
        Properties properties = new Properties();
        properties.put("TAB_SIZE", "illegal");
        this.assertParsingPropertiesFails(properties);
    }

    public void testShowLineNumbers() throws IllegalPropertyValueException {
        Properties properties = new Properties();
        properties.put("showLineNumbers", "false");
        Java2HtmlConversionOptions options = this.reader.read(properties);
        Assert.assertFalse((boolean)options.isShowLineNumbers());
    }

    public void testIllegalShowLineNumbers() {
        Properties properties = new Properties();
        properties.put("showLineNumbers", "illegal");
        this.assertParsingPropertiesFails(properties);
    }

    public void testShowFileName() throws IllegalPropertyValueException {
        Properties properties = new Properties();
        properties.put("showFileName", "true");
        Java2HtmlConversionOptions options = this.reader.read(properties);
        Assert.assertTrue((boolean)options.isShowFileName());
    }

    public void testIllegalShowFileName() {
        Properties properties = new Properties();
        properties.put("showFileName", "illegal");
        this.assertParsingPropertiesFails(properties);
    }

    public void testShowTableBorder() throws IllegalPropertyValueException {
        Properties properties = new Properties();
        properties.put("showTableBorder", "true");
        Java2HtmlConversionOptions options = this.reader.read(properties);
        Assert.assertTrue((boolean)options.isShowTableBorder());
    }

    public void testIllegalShowTableBorder() {
        Properties properties = new Properties();
        properties.put("showTableBorder", "illegal");
        this.assertParsingPropertiesFails(properties);
    }

    public void testShowJava2HtmlLink() throws IllegalPropertyValueException {
        Properties properties = new Properties();
        properties.put("showJava2HtmlLink", "true");
        Java2HtmlConversionOptions options = this.reader.read(properties);
        Assert.assertTrue((boolean)options.isShowJava2HtmlLink());
    }

    public void testIllegalJava2HtmlLink() {
        Properties properties = new Properties();
        properties.put("showJava2HtmlLink", "illegal");
        this.assertParsingPropertiesFails(properties);
    }

    public void testHorizontalAlignment() throws IllegalPropertyValueException {
        Properties properties = new Properties();
        properties.put("horizontalAlignment", HorizontalAlignment.RIGHT.getName());
        Java2HtmlConversionOptions options = this.reader.read(properties);
        Assert.assertEquals((Object)HorizontalAlignment.RIGHT, (Object)options.getHorizontalAlignment());
    }

    public void testIllegalHorizontalAlignment() {
        Properties properties = new Properties();
        properties.put("horizontalAlignment", "illegal");
        this.assertParsingPropertiesFails(properties);
    }

    public void testColor() throws IllegalPropertyValueException {
        Properties properties = new Properties();
        properties.put(String.valueOf(JavaSourceType.CODE.getName()) + "_COLOR", "255,255,255");
        Java2HtmlConversionOptions options = this.reader.read(properties);
        Assert.assertEquals((Object)RGB.WHITE, (Object)options.getStyleTable().get(JavaSourceType.CODE).getColor());
    }

    public void testIllegalColor() {
        Properties properties = new Properties();
        properties.put(String.valueOf(JavaSourceType.CODE.getName()) + "_COLOR", "illegal");
        this.assertParsingPropertiesFails(properties);
    }

    public void testBold() throws IllegalPropertyValueException {
        Properties properties = new Properties();
        properties.put(String.valueOf(JavaSourceType.CODE.getName()) + "_BOLD", "true");
        Java2HtmlConversionOptions options = this.reader.read(properties);
        Assert.assertTrue((boolean)options.getStyleTable().get(JavaSourceType.CODE).isBold());
    }

    public void testIllegalBold() {
        Properties properties = new Properties();
        properties.put(String.valueOf(JavaSourceType.CODE.getName()) + "_BOLD", "illegal");
        this.assertParsingPropertiesFails(properties);
    }

    public void testItalic() throws IllegalPropertyValueException {
        Properties properties = new Properties();
        properties.put(String.valueOf(JavaSourceType.CODE.getName()) + "_ITALIC", "true");
        Java2HtmlConversionOptions options = this.reader.read(properties);
        Assert.assertTrue((boolean)options.getStyleTable().get(JavaSourceType.CODE).isItalic());
    }

    public void testIllegalItalic() {
        Properties properties = new Properties();
        properties.put(String.valueOf(JavaSourceType.CODE.getName()) + "_ITALIC", "illegal");
        this.assertParsingPropertiesFails(properties);
    }
}

