/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg.animation;

import com.kitfox.svg.SVGElement;
import com.kitfox.svg.SVGLoaderHelper;
import com.kitfox.svg.animation.AnimateBase;
import com.kitfox.svg.animation.AnimateColorIface;
import com.kitfox.svg.xml.ColorTable;
import java.awt.Color;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AnimateColor
extends AnimateBase
implements AnimateColorIface {
    protected Color fromValue;
    protected Color toValue;

    public void loaderStartElement(SVGLoaderHelper helper, Attributes attrs, SVGElement parent) throws SAXException {
        super.loaderStartElement(helper, attrs, parent);
        String strn = attrs.getValue("from");
        this.fromValue = ColorTable.parseColor(strn);
        strn = attrs.getValue("to");
        this.toValue = ColorTable.parseColor(strn);
    }

    public Color evalColor(double interp) {
        int r1 = this.fromValue.getRed();
        int g1 = this.fromValue.getGreen();
        int b1 = this.fromValue.getBlue();
        int r2 = this.toValue.getRed();
        int g2 = this.toValue.getGreen();
        int b2 = this.toValue.getBlue();
        double invInterp = 1.0 - interp;
        return new Color((int)((double)r1 * invInterp + (double)r2 * interp), (int)((double)g1 * invInterp + (double)g2 * interp), (int)((double)b1 * invInterp + (double)b2 * interp));
    }
}

