/*
 * Decompiled with CFR 0.152.
 */
package de.java2html;

import de.java2html.Java2HtmlOptionsPanel;
import de.java2html.converter.JavaSourceConverter;
import de.java2html.gui.GBorderedPanel;
import de.java2html.gui.GLabel;
import de.java2html.gui.GTextArea;
import de.java2html.javasource.JavaSource;
import de.java2html.javasource.JavaSourceParser;
import de.java2html.options.Java2HtmlConversionOptions;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.StringWriter;

public class Java2HtmlApplet
extends Applet
implements TextListener {
    protected boolean initialized = false;
    protected static final Font FONT = new Font("Courier", 0, 11);
    protected GTextArea taInput;
    protected GTextArea taOutput;
    protected GLabel lStatistics;
    protected TextField tfTitle;
    private Java2HtmlOptionsPanel optionsPanel;

    public String getAppletInfo() {
        return "Java2Html Applet V4.1";
    }

    public void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.setBackground(SystemColor.control);
        Label l1 = new Label("Title (optional):", 2);
        this.tfTitle = new TextField(30);
        this.tfTitle.addTextListener(this);
        this.optionsPanel = new Java2HtmlOptionsPanel();
        this.optionsPanel.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Java2HtmlApplet.this.convert();
            }
        });
        Panel pa = new Panel();
        pa.add(l1);
        pa.add(this.tfTitle);
        this.taInput = new GTextArea();
        this.taInput.addTextListener(this);
        this.taInput.setFont(FONT);
        GBorderedPanel pi = new GBorderedPanel("Java source (paste your source code here):", -1);
        pi.setLayout(new BorderLayout(4, 4));
        pi.add((Component)this.taInput, "Center");
        this.taOutput = new GTextArea();
        this.taOutput.setEditable(false);
        this.taOutput.setFont(FONT);
        GBorderedPanel po = new GBorderedPanel("Converted source (copy and paste this to where you want it):", -1);
        po.setLayout(new BorderLayout(4, 4));
        po.add((Component)this.taOutput, "Center");
        GBorderedPanel ps = new GBorderedPanel("Statistics");
        this.lStatistics = new GLabel("-\n-\n-");
        ps.add(this.lStatistics);
        Panel pc = new Panel();
        pc.setLayout(new GridLayout(0, 1, 4, 4));
        pc.add(pi);
        pc.add(po);
        GBorderedPanel pe = new GBorderedPanel("Options");
        pe.add(this.optionsPanel);
        this.setLayout(new BorderLayout(4, 4));
        this.add((Component)pa, "North");
        this.add((Component)ps, "South");
        this.add((Component)pc, "Center");
        this.add((Component)pe, "East");
        this.taInput.requestFocus();
    }

    public void start() {
    }

    public void stop() {
    }

    protected void convert() {
        String input;
        String title = this.tfTitle.getText();
        if (title.equals("")) {
            title = null;
        }
        if ((input = this.taInput.getText()).trim().equals("")) {
            this.taOutput.setText("");
            this.lStatistics.setText("");
            return;
        }
        Java2HtmlConversionOptions options = this.optionsPanel.getConversionOptions();
        options.setShowJava2HtmlLink(true);
        JavaSourceParser parser = new JavaSourceParser(options);
        JavaSource source = parser.parse(input);
        source.setFileName(title);
        JavaSourceConverter converter = this.optionsPanel.getConverter();
        converter.setConversionOptions(options);
        StringWriter writer = new StringWriter();
        try {
            converter.convert(source, writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.taOutput.setText(String.valueOf(converter.getDocumentHeader()) + writer.getBuffer().toString() + converter.getDocumentFooter());
        this.lStatistics.setText(source.getStatisticsString());
        this.taOutput.selectAll();
    }

    public void textValueChanged(TextEvent evt) {
        this.convert();
    }

    public static void main(String[] args) {
        Frame appletFrame = new Frame("Applet viewer frame");
        appletFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        appletFrame.setLayout(new GridLayout());
        Java2HtmlApplet myApplet = new Java2HtmlApplet();
        appletFrame.add(myApplet);
        appletFrame.setSize(600, 450);
        myApplet.init();
        myApplet.start();
        appletFrame.show();
        appletFrame.setResizable(false);
    }
}

