/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.converter;

import de.java2html.converter.JavaSource2HTMLConverter;
import de.java2html.converter.JavaSourceConverter;
import de.java2html.javasource.JavaSource;
import de.java2html.javasource.JavaSourceIterator;
import de.java2html.javasource.JavaSourceParser;
import de.java2html.javasource.JavaSourceRun;
import de.java2html.javasource.JavaSourceType;
import de.java2html.util.RGB;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;

public class JavaSource2TeXConverter
extends JavaSourceConverter {
    private static String[] texFormats;
    protected static String DOCUMENT_HEADER;
    protected static final String DOCUMENT_FOOTER = "\\end{document}";
    protected static final String DOCUMENT_BLOCK_SEPARATOR = "\n\n";
    protected static final String BLOCK_HEADER = "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\n%  Java Sourcecode to TeX automatically converted code\n%  Java2Html Converter V4.1 2004by Markus Gebhard  markus@jave.de\n%     Further information: http://www.java2html.de\n";
    protected static final String[] WHITESPACES;

    static {
        JavaSourceType[] allTypes = JavaSourceType.getAll();
        texFormats = new String[allTypes.length];
        int i = 0;
        while (i < allTypes.length) {
            JavaSource2TeXConverter.texFormats[i] = "\\jttstyle" + (char)(97 + i) + " ";
            ++i;
        }
        DOCUMENT_HEADER = "\\documentclass[11pt,a4paper]{article}\n\n\\usepackage{color}\n\n\\begin{document}\n\n";
        WHITESPACES = new String[]{"", "~", "~~", "~~~", "~~~~"};
    }

    private String createFormatDefinition() {
        StringBuffer sb = new StringBuffer();
        sb.append("%Java2TeX style definitions\n");
        sb.append("%You can modify them to fit your needs\n");
        JavaSourceType[] allTypes = JavaSourceType.getAll();
        int i = 0;
        while (i < allTypes.length) {
            sb.append("\\newcommand{\\jttstyle");
            sb.append((char)(97 + i));
            sb.append("}{\\color[rgb]{");
            RGB color = this.getColorTable().get(allTypes[i].getName()).getColor();
            float[] cs = new float[]{(float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f};
            sb.append(JavaSource2TeXConverter.floatToCharArray(cs[0]));
            sb.append(',');
            sb.append(JavaSource2TeXConverter.floatToCharArray(cs[1]));
            sb.append(',');
            sb.append(JavaSource2TeXConverter.floatToCharArray(cs[2]));
            sb.append("}} %");
            sb.append(allTypes[i].getName());
            sb.append('\n');
            ++i;
        }
        sb.append('\n');
        return sb.toString();
    }

    public JavaSource2TeXConverter() {
    }

    public JavaSource2TeXConverter(JavaSource source) {
        super(source);
    }

    protected static final char[] floatToCharArray(float f) {
        if ((double)f >= 1.0) {
            return new char[]{'1', '.', '0', '0'};
        }
        return new char[]{'.', (char)(48.0f + f * 10.0f), (char)(48.0f + f * 100.0f % 10.0f), (char)(48.0f + f * 1000.0f % 10.0f)};
    }

    public String getDocumentHeader() {
        return String.valueOf(DOCUMENT_HEADER) + this.createFormatDefinition();
    }

    public String getDocumentFooter() {
        return DOCUMENT_FOOTER;
    }

    public String getBlockSeparator() {
        return DOCUMENT_BLOCK_SEPARATOR;
    }

    public void convert(BufferedWriter writer) throws IOException {
        if (this.source == null) {
            throw new IllegalStateException("Trying to write out converted code without having source set.");
        }
        writer.write(BLOCK_HEADER);
        if (this.getConversionOptions().isShowFileName()) {
            this.source.getFileName();
        }
        writer.write("{");
        writer.newLine();
        writer.write("\\noindent \\ttfamily");
        writer.newLine();
        int lineCount = this.source.getLineCount();
        int lineNumber = 1;
        JavaSourceIterator iterator = this.source.getIterator();
        while (iterator.hasNext()) {
            JavaSourceRun run = iterator.getNext();
            if (run.isAtStartOfLine() && this.getConversionOptions().isShowLineNumbers()) {
                this.writeLineNumber(writer, lineNumber++, lineCount);
            }
            this.toTeX(run, writer);
            if (!run.isAtEndOfLine()) continue;
            writer.write("\\\\");
            writer.newLine();
        }
        writer.newLine();
        writer.write("}");
        writer.newLine();
    }

    public void writeLineNumber(BufferedWriter writer, int lineNumber, int lineCount) throws IOException {
        writer.write(texFormats[JavaSourceType.LINE_NUMBERS.getID()]);
        writer.write(JavaSource2TeXConverter.leftSpace(lineNumber, lineCount));
        writer.write(String.valueOf(lineNumber));
        writer.write(126);
    }

    protected void toTeX(JavaSourceRun run, BufferedWriter writer) throws IOException {
        writer.write(texFormats[run.getType().getID()]);
        String text = run.getCode();
        int i = 0;
        while (i < text.length()) {
            char ch = text.charAt(i);
            if (ch == ' ') {
                writer.write(126);
            } else if (ch == '_' || ch == '\\' || ch == '^' || ch == '~' || ch == '\"' || ch == '|' || ch == '<' || ch == '>' || ch == '*') {
                writer.write("\\verb#" + ch + "#");
            } else if (ch == '{' || ch == '}' || ch == '_' || ch == '&' || ch == '%' || ch == '$' || ch == '#') {
                writer.write("\\" + ch);
            } else {
                writer.write(ch);
            }
            ++i;
        }
    }

    protected static final String whiteSpace(int size) {
        if (size < WHITESPACES.length) {
            return WHITESPACES[size];
        }
        char[] result = new char[size];
        while (size > 0) {
            result[--size] = 126;
        }
        return new String(result);
    }

    protected static final String leftSpace(int num, int max) {
        int count = (int)(Math.log(max) / Math.log(10.0)) - (int)(Math.log(num) / Math.log(10.0));
        return JavaSource2TeXConverter.whiteSpace(count);
    }

    public String getDefaultFileExtension() {
        return "tex";
    }

    public static void main(String[] args) throws IOException {
        long time0 = System.currentTimeMillis();
        JavaSource j = new JavaSourceParser().parse(new File("JavaSourceParser.java"));
        long time1 = System.currentTimeMillis();
        JavaSource2TeXConverter conn1 = new JavaSource2TeXConverter(j);
        conn1.convert(new StringWriter());
        long time2 = System.currentTimeMillis();
        JavaSource2HTMLConverter conn2 = new JavaSource2HTMLConverter(j);
        conn2.convert(new StringWriter());
        long time3 = System.currentTimeMillis();
        System.out.println("Parse:  " + (time1 - time0) + "ms");
        System.out.println("toTeX:  " + (time2 - time1) + "ms");
        System.out.println("toHTML: " + (time3 - time2) + "ms");
    }
}

