/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.javasource;

import de.java2html.javasource.IJavaSourceTypeChecker;
import de.java2html.javasource.JavaSource;
import de.java2html.javasource.JavaSourceType;
import de.java2html.options.Java2HtmlConversionOptions;
import de.java2html.util.IoUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class JavaSourceParser {
    private JavaSource source;
    private String sourceCode;
    private JavaSourceType[] sourceTypes;
    private Java2HtmlConversionOptions options;
    private static final String NUM_DELIMITERS = " \t\n\r()[]{};:+-/\\*!?#%&|<>=^,";
    private static final String DELIMITERS = " \t\n\r()[]{};:.+-/\\*!?#%&|<>=^";
    private static final String EMPTY_STR = " \t\n\r\f";
    private static final String[] PRIMITIVE_DATATYPES = new String[]{"boolean", "byte", "char", "double", "float", "int", "long", "short", "void"};
    private static final String[] JAVA_KEYWORDS = new String[]{"assert", "abstract", "default", "if", "private", "this", "do", "implements", "protected", "throw", "break", "import", "public", "throws", "else", "instanceof", "return", "transient", "case", "extends", "try", "catch", "final", "interface", "static", "finally", "strictfp", "volatile", "class", "native", "super", "while", "const", "for", "new", "strictfp", "switch", "continue", "goto", "package", "synchronized", "threadsafe", "null", "true", "false", "enum"};
    private static final String[] JAVADOC_KEYWORDS = new String[]{"@author", "@beaninfo", "@docRoot", "@deprecated", "@exception", "@link", "@param", "@return", "@see", "@serial", "@serialData", "@serialField", "@since", "@throws", "@version", "@linkplain", "@inheritDoc", "@value", "@pre", "@post", "@inv", "@published"};
    private static Hashtable tableJavaDocKeywords;
    private static Hashtable tableJavaKeywords;
    private static final short PARSESTATE_FINISHED = -1;
    private static final short COD = 0;
    private static final short CAC = 1;
    private static final short CL = 2;
    private static final short CBJ1 = 3;
    private static final short CBJ2 = 4;
    private static final short CB = 5;
    private static final short CBA = 6;
    private static final short CJ = 7;
    private static final short CJA = 8;
    private static final short QU = 9;
    private static final short QUA = 10;
    private static final short CH1 = 11;
    private static final short CH2 = 12;
    private static final short CH3 = 13;
    private static final short CH4 = 14;
    private static final short CH5 = 15;
    private static final short CH6 = 16;
    private static final short PARSESTATE_START = 0;
    private static final short PARSESTATE_NEUTRAL = 1;
    private static final short PARSESTATE_DA = 2;
    private static final short PARSESTATE_NA = 3;
    private static final short PARSESTATE_EXP = 4;
    private static final short PARSESTATE_HEX = 5;
    private static final short PARSESTATE_HIA = 6;
    private int counter;
    private static final char EOT = '\uffff';
    private short parseState;
    private int parseSourcePos;
    private int parseTypePos;

    public JavaSourceParser() {
        this(Java2HtmlConversionOptions.getDefault());
    }

    public JavaSourceParser(Java2HtmlConversionOptions options) {
        this.buildTables();
        this.options = options;
    }

    private synchronized void buildTables() {
        if (tableJavaDocKeywords != null && tableJavaKeywords != null) {
            return;
        }
        tableJavaDocKeywords = new Hashtable((int)((double)JAVADOC_KEYWORDS.length * 1.5));
        int i = 0;
        while (i < JAVADOC_KEYWORDS.length) {
            tableJavaDocKeywords.put(JAVADOC_KEYWORDS[i], JAVADOC_KEYWORDS[i]);
            ++i;
        }
        tableJavaKeywords = new Hashtable((int)((double)JAVA_KEYWORDS.length * 1.5));
        i = 0;
        while (i < JAVA_KEYWORDS.length) {
            tableJavaKeywords.put(JAVA_KEYWORDS[i], JAVA_KEYWORDS[i]);
            ++i;
        }
    }

    private static final boolean isEmpty(char ch) {
        return EMPTY_STR.indexOf(ch) != -1;
    }

    private boolean isNumberDelimiter(char ch) {
        return NUM_DELIMITERS.indexOf(ch) != -1;
    }

    private static final int indexOf(char ch, String s, int start, int end) {
        if (end < start) {
            return -1;
        }
        int i = start;
        while (i <= end) {
            if (s.charAt(i) == ch) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public JavaSource parse(File file) throws IOException {
        this.source = this.parse(new FileReader(file));
        this.source.setFileName(file.getName());
        return this.source;
    }

    public JavaSource parse(String rawText) {
        if (rawText == null) {
            throw new NullPointerException();
        }
        try {
            return this.parse(new StringReader(rawText));
        }
        catch (IOException e) {
            System.err.println("Unexpected exception while parsing raw text: " + e);
            return new JavaSource("");
        }
    }

    public JavaSource parse(URL url) throws IOException {
        JavaSource javaSource;
        InputStream inputStream = null;
        try {
            inputStream = url.openStream();
            javaSource = this.parse(inputStream);
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            IoUtilities.close(inputStream);
            throw throwable;
        }
        IoUtilities.close(inputStream);
        return javaSource;
    }

    public JavaSource parse(InputStream stream) throws IOException {
        return this.parse(new InputStreamReader(stream));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JavaSource parse(Reader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException("reader may not be null");
        }
        try {
            this.sourceCode = this.readPlainSource(reader);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            IoUtilities.close(reader);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        IoUtilities.close(reader);
        this.replaceTabs();
        this.sourceTypes = new JavaSourceType[this.sourceCode.length()];
        this.source = new JavaSource(this.sourceCode);
        this.source.setClassification(this.sourceTypes);
        this.parseOne();
        this.parseTwo();
        this.parseThree();
        this.doStatistics();
        return this.source;
    }

    private void doStatistics() {
        int index = 0;
        this.source.getStatistic().clear();
        this.source.getStatistic().setCharacterCount(this.sourceCode.length());
        int linesContainingAnything = 0;
        if (this.sourceCode.length() == 0) {
            this.source.getStatistic().setLineCount(0);
        } else {
            StringTokenizer st = new StringTokenizer(this.sourceCode, "\n\r", true);
            while (st.hasMoreTokens()) {
                String line = st.nextToken();
                if (line.charAt(0) == '\r') {
                    ++index;
                    continue;
                }
                if (line.charAt(0) == '\n') {
                    ++index;
                    this.source.getStatistic().setLineCount(this.source.getStatistic().getLineCount() + 1);
                    continue;
                }
                ++linesContainingAnything;
                this.statistics(line, index);
                index += line.length();
            }
            this.source.getStatistic().setLineCount(this.source.getStatistic().getLineCount() + 1);
        }
        this.source.getStatistic().setEmptyLineCount(this.source.getStatistic().getLineCount() - linesContainingAnything);
    }

    private void statistics(String line, int start) {
        if (line.length() > this.source.getStatistic().getMaxLineLength()) {
            this.source.getStatistic().setMaxLineLength(line.length());
        }
        int end = start + line.length();
        boolean containsCode = false;
        boolean containsComment = false;
        int i = start;
        while (i < end) {
            if (this.sourceTypes[i] == JavaSourceType.CODE || this.sourceTypes[i] == JavaSourceType.KEYWORD || this.sourceTypes[i] == JavaSourceType.CODE_TYPE || this.sourceTypes[i] == JavaSourceType.CHAR_CONSTANT || this.sourceTypes[i] == JavaSourceType.NUM_CONSTANT) {
                containsCode = true;
                if (containsComment) {
                    break;
                }
            } else if (this.sourceTypes[i] == JavaSourceType.COMMENT_BLOCK || this.sourceTypes[i] == JavaSourceType.COMMENT_LINE || this.sourceTypes[i] == JavaSourceType.JAVADOC || this.sourceTypes[i] == JavaSourceType.JAVADOC_KEYWORD) {
                containsComment = true;
                if (containsCode) break;
            }
            ++i;
        }
        if (containsCode) {
            this.source.getStatistic().setCodeLineCount(this.source.getStatistic().getCodeLineCount() + 1);
        }
        if (containsComment) {
            this.source.getStatistic().setCommentLineCount(this.source.getStatistic().getCommentLineCount() + 1);
        }
        if (!containsCode && !containsComment) {
            this.source.getStatistic().setEmptyLineCount(this.source.getStatistic().getEmptyLineCount() + 1);
        }
    }

    private String readPlainSource(Reader reader) throws IOException {
        return this.readPlainSource(new BufferedReader(reader));
    }

    private String readPlainSource(BufferedReader reader) throws IOException {
        String line;
        StringBuffer sb = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            sb.append(line);
            sb.append("\r\n");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 2);
        }
        return sb.toString();
    }

    private void replaceTabs() {
        char[] t = new char[this.options.getTabSize()];
        int i = 0;
        while (i < this.options.getTabSize()) {
            t[i] = 32;
            ++i;
        }
        StringBuffer sb = new StringBuffer((int)((double)this.sourceCode.length() * 1.3));
        int i2 = 0;
        while (i2 < this.sourceCode.length()) {
            char ch = this.sourceCode.charAt(i2);
            if (ch == '\t') {
                sb.append(t);
            } else {
                sb.append(ch);
            }
            ++i2;
        }
        this.sourceCode = sb.toString();
    }

    private void parseOne() {
        this.parseState = 0;
        this.parseSourcePos = 0;
        this.parseTypePos = 0;
        while (this.parseState != -1) {
            this.parseOneDo();
        }
    }

    private void parseOneDo() {
        char ch = '\uffff';
        if (this.sourceCode.length() > this.parseSourcePos) {
            ch = this.sourceCode.charAt(this.parseSourcePos++);
        }
        switch (this.parseState) {
            case 0: {
                if (ch == '\uffff') {
                    this.parseState = (short)-1;
                    return;
                }
                if (ch == '/') {
                    this.parseState = 1;
                    return;
                }
                if (ch == '\"') {
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.STRING;
                    this.parseState = (short)9;
                    return;
                }
                if (ch == '\'') {
                    this.parseState = (short)11;
                    return;
                }
                if (JavaSourceParser.isEmpty(ch)) {
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.BACKGROUND;
                    return;
                }
                this.sourceTypes[this.parseTypePos++] = JavaSourceType.CODE;
                return;
            }
            case 1: {
                if (ch == '\uffff') {
                    this.parseState = (short)-1;
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.CODE;
                    return;
                }
                if (ch == '/') {
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.COMMENT_LINE;
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.COMMENT_LINE;
                    this.parseState = (short)2;
                    return;
                }
                if (ch == '*') {
                    this.parseState = (short)3;
                    return;
                }
                if (JavaSourceParser.isEmpty(ch)) {
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.CODE;
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.BACKGROUND;
                    this.parseState = 0;
                    return;
                }
                this.sourceTypes[this.parseTypePos++] = JavaSourceType.CODE;
                this.sourceTypes[this.parseTypePos++] = JavaSourceType.CODE;
                this.parseState = 0;
                return;
            }
            case 2: {
                if (ch == '\uffff') {
                    this.parseState = (short)-1;
                    return;
                }
                if (ch == '\n' || ch == '\r') {
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.BACKGROUND;
                    this.parseState = 0;
                    return;
                }
                if (JavaSourceParser.isEmpty(ch)) {
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.BACKGROUND;
                    return;
                }
                this.sourceTypes[this.parseTypePos++] = JavaSourceType.COMMENT_LINE;
                return;
            }
            case 5: {
                if (ch == '\uffff') {
                    this.parseState = (short)-1;
                    return;
                }
                if (ch == '*') {
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.COMMENT_BLOCK;
                    this.parseState = (short)6;
                    return;
                }
                if (JavaSourceParser.isEmpty(ch)) {
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.BACKGROUND;
                    return;
                }
                this.sourceTypes[this.parseTypePos++] = JavaSourceType.COMMENT_BLOCK;
                return;
            }
            case 6: {
                if (ch == '\uffff') {
                    this.parseState = (short)-1;
                    return;
                }
                if (ch == '/') {
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.COMMENT_BLOCK;
                    this.parseState = 0;
                    return;
                }
                if (ch == '*') {
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.COMMENT_BLOCK;
                    this.parseState = (short)6;
                    return;
                }
                if (JavaSourceParser.isEmpty(ch)) {
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.BACKGROUND;
                    this.parseState = (short)5;
                    return;
                }
                this.sourceTypes[this.parseTypePos++] = JavaSourceType.COMMENT_BLOCK;
                this.parseState = (short)5;
                return;
            }
            case 7: {
                if (ch == '\uffff') {
                    this.parseState = (short)-1;
                    return;
                }
                if (ch == '*') {
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.JAVADOC;
                    this.parseState = (short)8;
                    return;
                }
                if (JavaSourceParser.isEmpty(ch)) {
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.BACKGROUND;
                    return;
                }
                this.sourceTypes[this.parseTypePos++] = JavaSourceType.JAVADOC;
                return;
            }
            case 8: {
                if (ch == '\uffff') {
                    this.parseState = (short)-1;
                    return;
                }
                if (ch == '/') {
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.JAVADOC;
                    this.parseState = 0;
                    return;
                }
                if (ch == '*') {
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.JAVADOC;
                    this.parseState = (short)8;
                    return;
                }
                if (JavaSourceParser.isEmpty(ch)) {
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.BACKGROUND;
                    this.parseState = (short)7;
                    return;
                }
                this.sourceTypes[this.parseTypePos++] = JavaSourceType.JAVADOC;
                this.parseState = (short)7;
                return;
            }
            case 9: {
                if (ch == '\uffff') {
                    this.parseState = (short)-1;
                    return;
                }
                if (ch == '\"') {
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.STRING;
                    this.parseState = 0;
                    return;
                }
                if (ch == '\\') {
                    this.parseState = (short)10;
                    return;
                }
                if (JavaSourceParser.isEmpty(ch)) {
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.BACKGROUND;
                    return;
                }
                this.sourceTypes[this.parseTypePos++] = JavaSourceType.STRING;
                return;
            }
            case 10: {
                if (ch == '\uffff') {
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.STRING;
                    this.parseState = (short)-1;
                    return;
                }
                if (ch == '\\') {
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.STRING;
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.STRING;
                    this.parseState = (short)9;
                    return;
                }
                if (JavaSourceParser.isEmpty(ch)) {
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.STRING;
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.BACKGROUND;
                    this.parseState = (short)9;
                    return;
                }
                this.sourceTypes[this.parseTypePos++] = JavaSourceType.STRING;
                this.sourceTypes[this.parseTypePos++] = JavaSourceType.STRING;
                this.parseState = (short)9;
                return;
            }
            case 3: {
                if (ch == '\uffff') {
                    this.parseState = (short)-1;
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.UNDEFINED;
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.UNDEFINED;
                    return;
                }
                if (ch == '*') {
                    this.parseState = (short)4;
                    return;
                }
                if (JavaSourceParser.isEmpty(ch)) {
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.COMMENT_BLOCK;
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.COMMENT_BLOCK;
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.BACKGROUND;
                    this.parseState = (short)5;
                    return;
                }
                this.sourceTypes[this.parseTypePos++] = JavaSourceType.COMMENT_BLOCK;
                this.sourceTypes[this.parseTypePos++] = JavaSourceType.COMMENT_BLOCK;
                this.sourceTypes[this.parseTypePos++] = JavaSourceType.COMMENT_BLOCK;
                this.parseState = (short)5;
                return;
            }
            case 4: {
                if (ch == '\uffff') {
                    this.parseState = (short)-1;
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.UNDEFINED;
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.UNDEFINED;
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.UNDEFINED;
                    return;
                }
                if (ch == '/') {
                    this.parseState = 0;
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.COMMENT_BLOCK;
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.COMMENT_BLOCK;
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.COMMENT_BLOCK;
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.COMMENT_BLOCK;
                    return;
                }
                if (JavaSourceParser.isEmpty(ch)) {
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.JAVADOC;
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.JAVADOC;
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.JAVADOC;
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.BACKGROUND;
                    this.parseState = (short)7;
                    return;
                }
                this.sourceTypes[this.parseTypePos++] = JavaSourceType.JAVADOC;
                this.sourceTypes[this.parseTypePos++] = JavaSourceType.JAVADOC;
                this.sourceTypes[this.parseTypePos++] = JavaSourceType.JAVADOC;
                this.sourceTypes[this.parseTypePos++] = JavaSourceType.JAVADOC;
                this.parseState = (short)7;
                return;
            }
            case 11: {
                if (ch == '\uffff') {
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.CODE;
                    this.parseState = (short)-1;
                    return;
                }
                if (ch == '\\') {
                    this.parseState = (short)13;
                    return;
                }
                this.parseState = (short)12;
                return;
            }
            case 12: {
                if (ch == '\uffff') {
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.CODE;
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.CODE;
                    this.parseState = (short)-1;
                    return;
                }
                if (ch == '\'') {
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.CHAR_CONSTANT;
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.CHAR_CONSTANT;
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.CHAR_CONSTANT;
                    this.parseState = 0;
                    return;
                }
                this.sourceTypes[this.parseTypePos++] = JavaSourceType.UNDEFINED;
                this.sourceTypes[this.parseTypePos++] = JavaSourceType.UNDEFINED;
                this.sourceTypes[this.parseTypePos++] = JavaSourceType.UNDEFINED;
                this.parseState = 0;
                return;
            }
            case 13: {
                if (ch == '\uffff') {
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.CODE;
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.CODE;
                    this.parseState = (short)-1;
                    return;
                }
                if (ch == 'u') {
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.CHAR_CONSTANT;
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.CHAR_CONSTANT;
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.CHAR_CONSTANT;
                    this.parseState = (short)15;
                    return;
                }
                if (ch >= '1' && ch <= '9') {
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.CHAR_CONSTANT;
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.CHAR_CONSTANT;
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.CHAR_CONSTANT;
                    this.parseState = (short)16;
                    return;
                }
                this.parseState = (short)14;
                return;
            }
            case 14: {
                if (ch == '\uffff') {
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.CODE;
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.CODE;
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.CODE;
                    this.parseState = (short)-1;
                    return;
                }
                if (ch == '\'') {
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.CHAR_CONSTANT;
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.CHAR_CONSTANT;
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.CHAR_CONSTANT;
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.CHAR_CONSTANT;
                    this.parseState = 0;
                    return;
                }
                this.sourceTypes[this.parseTypePos++] = JavaSourceType.CODE;
                this.sourceTypes[this.parseTypePos++] = JavaSourceType.CODE;
                this.sourceTypes[this.parseTypePos++] = JavaSourceType.CODE;
                this.sourceTypes[this.parseTypePos++] = JavaSourceType.CODE;
                this.parseState = 0;
                return;
            }
            case 16: {
                if (ch == '\uffff') {
                    this.parseState = (short)-1;
                    return;
                }
                if (ch == '\'') {
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.CHAR_CONSTANT;
                    this.parseState = 0;
                    return;
                }
                if (ch >= '0' && ch <= '9') {
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.CHAR_CONSTANT;
                    return;
                }
                this.sourceTypes[this.parseTypePos++] = JavaSourceType.UNDEFINED;
                this.parseState = 0;
                return;
            }
            case 15: {
                if (ch == '\uffff') {
                    this.parseState = (short)-1;
                    return;
                }
                if (ch == '\'') {
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.CHAR_CONSTANT;
                    this.parseState = 0;
                    return;
                }
                if (ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F') {
                    this.sourceTypes[this.parseTypePos++] = JavaSourceType.CHAR_CONSTANT;
                    return;
                }
                this.sourceTypes[this.parseTypePos++] = JavaSourceType.UNDEFINED;
                this.parseState = 0;
                return;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void parseTwo() {
        index = 0;
        while (index < this.sourceTypes.length) {
            if (this.sourceTypes[index] == JavaSourceType.CODE && this.isParenthesis(this.sourceCode.charAt(index))) {
                this.mark(index, JavaSourceType.PARENTHESIS);
            }
            ++index;
        }
        start = 0;
        end = 0;
        ** GOTO lbl15
        {
            ++end;
            do {
                if (end < this.sourceTypes.length - 1 && this.sourceTypes[end + 1] == this.sourceTypes[start]) continue block1;
                this.parseTwo(start, end);
                end = start = end + 1;
lbl15:
                // 2 sources

            } while (end < this.sourceTypes.length - 1);
        }
    }

    private boolean isParenthesis(char ch) {
        return ch == '{' || ch == '}' || ch == '[' || ch == ']' || ch == '(' || ch == ')';
    }

    private void parseTwo(int start, int end) {
        if (this.sourceTypes[start] == JavaSourceType.JAVADOC) {
            this.parseTwoCommentBlock(start, end);
            return;
        }
        if (this.sourceTypes[start] == JavaSourceType.CODE) {
            this.parseTwoCode(start, end);
            return;
        }
    }

    private void parseTwoCode(int start, int end) {
        String code = this.sourceCode.substring(start, end + 1);
        int index = start;
        StringTokenizer st = new StringTokenizer(code, DELIMITERS, true);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (tableJavaKeywords.containsKey(s)) {
                int i1;
                this.mark(index, index + s.length(), JavaSourceType.KEYWORD);
                if (s.equals("package") && (i1 = this.sourceCode.indexOf(59, index + 1)) != -1) {
                    this.source.getStatistic().setPackageName(this.sourceCode.substring(index + s.length(), i1).trim());
                }
            } else {
                int i = 0;
                while (i < PRIMITIVE_DATATYPES.length) {
                    if (s.equals(PRIMITIVE_DATATYPES[i])) {
                        this.mark(index, index + s.length(), JavaSourceType.CODE_TYPE);
                        break;
                    }
                    ++i;
                }
            }
            index += s.length();
        }
    }

    private void parseTwoCommentBlock(int start, int end) {
        int i2;
        int i1 = JavaSourceParser.indexOf('@', this.sourceCode, start, end);
        while (i1 != -1 && i1 + 1 < end) {
            i2 = i1 + 1;
            char ch = this.sourceCode.charAt(i2 + 1);
            while (i2 < end && (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z')) {
                ch = this.sourceCode.charAt(++i2 + 1);
            }
            String s = this.sourceCode.substring(i1, i2 + 1);
            if (tableJavaDocKeywords.containsKey(s)) {
                this.mark(i1, i2 + 1, JavaSourceType.JAVADOC_KEYWORD);
            }
            i1 = JavaSourceParser.indexOf('@', this.sourceCode, i2, end);
        }
        i1 = JavaSourceParser.indexOf('<', this.sourceCode, start, end);
        while (i1 != -1 && i1 + 1 < end) {
            i2 = this.sourceCode.indexOf(62, i1 + 1);
            if (i2 == -1) {
                i1 = -1;
                break;
            }
            if (JavaSourceParser.hasTypeOrEmpty(this.sourceTypes, i1, i2 + 1, JavaSourceType.JAVADOC)) {
                this.mark(i1, i2 + 1, JavaSourceType.JAVADOC_HTML_TAG);
            }
            i1 = JavaSourceParser.indexOf('<', this.sourceCode, i2, end);
        }
    }

    private static boolean hasTypeOrEmpty(JavaSourceType[] sourceTypes, int startIndex, int endIndex, JavaSourceType javaSourceType) {
        int i = startIndex;
        while (i <= endIndex) {
            if (!sourceTypes[i].equals(javaSourceType) && !sourceTypes[i].equals(JavaSourceType.BACKGROUND)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private void parseThree() {
        start = 0;
        end = 0;
        ** GOTO lbl10
        {
            ++end;
            do {
                if (end < this.sourceTypes.length - 1 && this.sourceTypes[end + 1] == this.sourceTypes[start]) continue block0;
                if (this.sourceTypes[start] == JavaSourceType.CODE) {
                    this.parseThree(start, end);
                }
                end = start = end + 1;
lbl10:
                // 2 sources

            } while (end < this.sourceTypes.length - 1);
        }
        this.expandJavaDocLinks();
    }

    private void expandJavaDocLinks() {
        this.expandEmbracedJavaDocTag("@link", JavaSourceType.JAVADOC_LINKS);
        this.expandEmbracedJavaDocTag("@linkplain", JavaSourceType.JAVADOC_LINKS);
    }

    private void expandEmbracedJavaDocTag(String tag, JavaSourceType type) {
        String pattern = "{" + tag;
        int index = 0;
        while (index < this.sourceTypes.length) {
            int end;
            char ch;
            int start = this.sourceCode.indexOf(pattern, index);
            if (start == -1 || Character.isLetterOrDigit(ch = this.sourceCode.charAt(start + pattern.length())) || !this.checkRegion(start + 1, start + 1 + tag.length() - 1, new IJavaSourceTypeChecker(){

                public boolean isValid(JavaSourceType type) {
                    return type.equals(JavaSourceType.JAVADOC_KEYWORD);
                }
            }) || (end = this.sourceCode.indexOf(125, start + pattern.length())) == -1) break;
            if (this.checkRegion(start + 1 + tag.length(), end, new IJavaSourceTypeChecker(){

                public boolean isValid(JavaSourceType type) {
                    return type.equals(JavaSourceType.BACKGROUND) || type.equals(JavaSourceType.JAVADOC);
                }
            })) {
                this.markWithoutBackground(start, end, type);
            }
            index = end;
            ++index;
        }
    }

    private boolean checkRegion(int start, int end, IJavaSourceTypeChecker checker) {
        int i = start;
        while (i <= end) {
            if (!checker.isValid(this.sourceTypes[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void markWithoutBackground(int start, int end, JavaSourceType type) {
        int i = start;
        while (i <= end) {
            if (!this.sourceTypes[i].equals(JavaSourceType.BACKGROUND)) {
                this.sourceTypes[i] = type;
            }
            ++i;
        }
    }

    private void parseThree(int start, int end) {
        this.parseState = 0;
        this.parseSourcePos = start;
        this.parseTypePos = start - 1;
        this.counter = 0;
        while (this.parseState != -1) {
            this.parseThreeDo(end);
        }
    }

    private void parseThreeDo(int end) {
        char ch = '\uffff';
        if (this.parseSourcePos <= end) {
            ch = this.sourceCode.charAt(this.parseSourcePos);
        }
        ++this.parseSourcePos;
        ++this.parseTypePos;
        switch (this.parseState) {
            case 0: {
                if (ch == '\uffff') {
                    this.parseState = (short)-1;
                    return;
                }
                if (ch == '.') {
                    ++this.counter;
                    this.parseState = (short)2;
                    return;
                }
                if (ch == '0') {
                    ++this.counter;
                    this.parseState = (short)6;
                    return;
                }
                if (ch >= '1' && ch <= '9') {
                    ++this.counter;
                    this.parseState = (short)3;
                    return;
                }
                if (this.isNumberDelimiter(ch)) {
                    return;
                }
                this.parseState = 1;
                return;
            }
            case 1: {
                if (ch == '\uffff') {
                    this.parseState = (short)-1;
                    return;
                }
                if (this.isNumberDelimiter(ch)) {
                    this.parseState = 0;
                    return;
                }
                return;
            }
            case 2: {
                if (ch == '\uffff') {
                    this.parseState = (short)-1;
                    return;
                }
                if (ch >= '0' && ch <= '9') {
                    ++this.counter;
                    this.parseState = (short)3;
                    return;
                }
                if (this.isNumberDelimiter(ch)) {
                    this.parseState = 0;
                    this.counter = 0;
                    return;
                }
                this.parseState = 1;
                this.counter = 0;
                return;
            }
            case 3: {
                if (ch == '\uffff') {
                    this.parseState = (short)-1;
                    this.mark(this.parseTypePos - this.counter, this.parseTypePos, JavaSourceType.NUM_CONSTANT);
                    return;
                }
                if (ch == '.' || ch >= '0' && ch <= '9') {
                    ++this.counter;
                    return;
                }
                if (ch == 'e') {
                    this.parseState = (short)4;
                    ++this.counter;
                    return;
                }
                if (ch == 'f' || ch == 'F' || ch == 'd' || ch == 'D' || ch == 'l' || ch == 'L') {
                    ++this.counter;
                    this.mark(this.parseTypePos - this.counter + 1, this.parseTypePos + 1, JavaSourceType.NUM_CONSTANT);
                    this.parseState = 1;
                    this.counter = 0;
                    return;
                }
                if (this.isNumberDelimiter(ch)) {
                    this.parseState = 0;
                    this.mark(this.parseTypePos - this.counter, this.parseTypePos, JavaSourceType.NUM_CONSTANT);
                    this.counter = 0;
                    return;
                }
                this.mark(this.parseTypePos - this.counter, this.parseTypePos, JavaSourceType.NUM_CONSTANT);
                this.parseState = 1;
                this.counter = 0;
                return;
            }
            case 6: {
                if (ch == '\uffff') {
                    this.parseState = (short)-1;
                    this.mark(this.parseTypePos - this.counter, this.parseTypePos, JavaSourceType.NUM_CONSTANT);
                    return;
                }
                if (ch == 'x' || ch == 'X') {
                    this.parseState = (short)5;
                    ++this.counter;
                    return;
                }
                if (ch == '.' || ch >= '0' && ch <= '9') {
                    ++this.counter;
                    this.parseState = (short)3;
                    return;
                }
                if (ch == 'f' || ch == 'F' || ch == 'd' || ch == 'D' || ch == 'l' || ch == 'L') {
                    ++this.counter;
                    this.mark(this.parseTypePos - this.counter + 1, this.parseTypePos + 1, JavaSourceType.NUM_CONSTANT);
                    this.parseState = 1;
                    this.counter = 0;
                    return;
                }
                if (this.isNumberDelimiter(ch)) {
                    this.parseState = 0;
                    this.mark(this.parseTypePos - this.counter, this.parseTypePos, JavaSourceType.NUM_CONSTANT);
                    this.counter = 0;
                    return;
                }
                this.mark(this.parseTypePos - this.counter, this.parseTypePos, JavaSourceType.NUM_CONSTANT);
                this.parseState = 1;
                this.counter = 0;
                return;
            }
            case 5: {
                if (ch == '\uffff') {
                    this.parseState = (short)-1;
                    this.mark(this.parseTypePos - this.counter, this.parseTypePos, JavaSourceType.NUM_CONSTANT);
                    return;
                }
                if (ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F') {
                    ++this.counter;
                    this.parseState = (short)5;
                    return;
                }
                if (ch == 'l' || ch == 'L') {
                    ++this.counter;
                    this.mark(this.parseTypePos - this.counter + 1, this.parseTypePos + 1, JavaSourceType.NUM_CONSTANT);
                    this.parseState = 1;
                    this.counter = 0;
                    return;
                }
                if (this.isNumberDelimiter(ch)) {
                    this.parseState = 0;
                    this.mark(this.parseTypePos - this.counter, this.parseTypePos, JavaSourceType.NUM_CONSTANT);
                    this.counter = 0;
                    return;
                }
                this.mark(this.parseTypePos - this.counter, this.parseTypePos, JavaSourceType.NUM_CONSTANT);
                this.parseState = 1;
                this.counter = 0;
                return;
            }
            case 4: {
                if (ch == '\uffff') {
                    this.parseState = (short)-1;
                    this.mark(this.parseTypePos - this.counter, this.parseTypePos - 1, JavaSourceType.NUM_CONSTANT);
                    return;
                }
                if (ch >= '0' && ch <= '9' || ch == '+' || ch == '-') {
                    ++this.counter;
                    this.parseState = (short)3;
                    return;
                }
                if (this.isNumberDelimiter(ch)) {
                    this.parseState = 0;
                    this.mark(this.parseTypePos - this.counter, this.parseTypePos - 1, JavaSourceType.NUM_CONSTANT);
                    this.counter = 0;
                    return;
                }
                this.mark(this.parseTypePos - this.counter, this.parseTypePos - 1, JavaSourceType.NUM_CONSTANT);
                this.parseState = 1;
                this.counter = 0;
                return;
            }
        }
    }

    private void mark(int start, int endPlusOne, JavaSourceType type) {
        int i = start;
        while (i < endPlusOne) {
            this.sourceTypes[i] = type;
            ++i;
        }
    }

    private void mark(int index, JavaSourceType type) {
        this.sourceTypes[index] = type;
    }
}

