/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.program;

import java.io.IOException;
import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSBundle;
import org.eclipse.swt.internal.cocoa.NSDictionary;
import org.eclipse.swt.internal.cocoa.NSDirectoryEnumerator;
import org.eclipse.swt.internal.cocoa.NSEnumerator;
import org.eclipse.swt.internal.cocoa.NSFileManager;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSMutableSet;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSURL;
import org.eclipse.swt.internal.cocoa.NSWorkspace;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Display;

public final class Program {
    String name;
    String fullPath;
    String identifier;
    static final String PREFIX_HTTP = "http://";
    static final String PREFIX_HTTPS = "https://";

    Program() {
    }

    public static Program findProgram(String string) {
        long l;
        byte[] byArray;
        char[] cArray;
        NSAutoreleasePool nSAutoreleasePool;
        block8: {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            try {
                if (string == null) {
                    SWT.error(4);
                }
                if (string.length() != 0) break block8;
                Object var10_2 = null;
            }
            catch (Throwable throwable) {
                Object var10_4 = null;
                nSAutoreleasePool.release();
                throw throwable;
            }
            nSAutoreleasePool.release();
            return null;
        }
        Program program = null;
        if (string.charAt(0) != '.') {
            cArray = new char[string.length()];
            string.getChars(0, cArray.length, cArray, 0);
        } else {
            cArray = new char[string.length() - 1];
            string.getChars(1, string.length(), cArray, 0);
        }
        NSString nSString = NSString.stringWithCharacters(cArray, cArray.length);
        if (nSString != null && OS.LSGetApplicationForInfo(0, 0, nSString.id, -1, byArray = new byte[80], null) == 0L && (l = OS.CFURLCreateFromFSRef(OS.kCFAllocatorDefault(), byArray)) != 0L) {
            NSString nSString2 = new NSURL(l).path();
            NSBundle nSBundle = NSBundle.bundleWithPath(nSString2);
            if (nSBundle != null) {
                program = Program.getProgram(nSBundle);
            }
            OS.CFRelease(l);
        }
        Program program2 = program;
        Object var10_3 = null;
        nSAutoreleasePool.release();
        return program2;
    }

    public static String[] getExtensions() {
        String[] stringArray;
        NSAutoreleasePool nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        try {
            Object object;
            id id2;
            NSObject nSObject;
            Object object2;
            NSMutableSet nSMutableSet = (NSMutableSet)NSMutableSet.set();
            NSWorkspace nSWorkspace = NSWorkspace.sharedWorkspace();
            NSString nSString = NSString.stringWith("CFBundleDocumentTypes");
            NSString nSString2 = NSString.stringWith("CFBundleTypeExtensions");
            NSArray nSArray = new NSArray(OS.NSSearchPathForDirectoriesInDomains(100L, 65535L, true));
            int n = (int)nSArray.count();
            int n2 = 0;
            while (n2 < n) {
                object2 = new NSString(nSArray.objectAtIndex(n2));
                nSObject = NSFileManager.defaultManager();
                id2 = ((NSFileManager)nSObject).enumeratorAtPath((NSString)object2);
                if (id2 != null) {
                    while ((object = ((NSEnumerator)id2).nextObject()) != null) {
                        ((NSDirectoryEnumerator)id2).skipDescendents();
                        NSString nSString3 = new NSString(((id)object).id);
                        NSString nSString4 = ((NSString)object2).stringByAppendingPathComponent(nSString3);
                        if (!nSWorkspace.isFilePackageAtPath(nSString4)) continue;
                        NSBundle nSBundle = NSBundle.bundleWithPath(nSString4);
                        Object object3 = object = nSBundle != null ? nSBundle.infoDictionary().objectForKey(nSString) : null;
                        if (object == null) continue;
                        NSDictionary nSDictionary = new NSDictionary(((id)object).id);
                        NSEnumerator nSEnumerator = nSDictionary.objectEnumerator();
                        while ((object = nSEnumerator.nextObject()) != null) {
                            NSDictionary nSDictionary2 = new NSDictionary(((id)object).id);
                            object = nSDictionary2.objectForKey(nSString2);
                            if (object == null) continue;
                            nSMutableSet.addObjectsFromArray(new NSArray(((id)object).id));
                        }
                    }
                }
                ++n2;
            }
            n2 = 0;
            object2 = new String[(int)nSMutableSet.count()];
            nSObject = nSMutableSet.objectEnumerator();
            while ((id2 = ((NSEnumerator)nSObject).nextObject()) != null) {
                object = new NSString(id2.id).getString();
                if (((String)object).equals("*")) continue;
                object2[n2++] = "." + (String)object;
            }
            if (n2 != ((String[])object2).length) {
                object = new String[n2];
                System.arraycopy(object2, 0, object, 0, n2);
                object2 = object;
            }
            stringArray = object2;
            Object var18_19 = null;
        }
        catch (Throwable throwable) {
            Object var18_20 = null;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
        return stringArray;
    }

    static Program getProgram(NSBundle nSBundle) {
        NSString nSString = NSString.stringWith("CFBundleName");
        NSString nSString2 = NSString.stringWith("CFBundleDisplayName");
        NSString nSString3 = nSBundle.bundlePath();
        NSString nSString4 = nSBundle.bundleIdentifier();
        id id2 = nSBundle.objectForInfoDictionaryKey(nSString2);
        if (id2 == null) {
            id2 = nSBundle.objectForInfoDictionaryKey(nSString);
        }
        if (id2 == null) {
            id2 = nSString3.lastPathComponent().stringByDeletingPathExtension();
        }
        NSString nSString5 = new NSString(id2.id);
        Program program = new Program();
        program.name = nSString5.getString();
        program.fullPath = nSString3.getString();
        program.identifier = nSString4 != null ? nSString4.getString() : "";
        return program;
    }

    public static Program[] getPrograms() {
        Object[] objectArray;
        NSAutoreleasePool nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        try {
            Vector<Program> vector = new Vector<Program>();
            NSWorkspace nSWorkspace = NSWorkspace.sharedWorkspace();
            NSArray nSArray = new NSArray(OS.NSSearchPathForDirectoriesInDomains(100L, 65535L, true));
            int n = (int)nSArray.count();
            int n2 = 0;
            while (n2 < n) {
                NSString nSString = new NSString(nSArray.objectAtIndex(n2));
                NSFileManager nSFileManager = NSFileManager.defaultManager();
                NSDirectoryEnumerator nSDirectoryEnumerator = nSFileManager.enumeratorAtPath(nSString);
                if (nSDirectoryEnumerator != null) {
                    id id2;
                    while ((id2 = nSDirectoryEnumerator.nextObject()) != null) {
                        NSBundle nSBundle;
                        nSDirectoryEnumerator.skipDescendents();
                        NSString nSString2 = nSString.stringByAppendingPathComponent(new NSString(id2.id));
                        if (!nSWorkspace.isFilePackageAtPath(nSString2) || (nSBundle = NSBundle.bundleWithPath(nSString2)) == null) continue;
                        vector.addElement(Program.getProgram(nSBundle));
                    }
                }
                ++n2;
            }
            Object[] objectArray2 = new Program[vector.size()];
            vector.copyInto(objectArray2);
            objectArray = objectArray2;
            Object var12_14 = null;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
        return objectArray;
    }

    static NSURL getURL(String string) {
        String string2 = string.toLowerCase();
        NSString nSString = string2.startsWith(PREFIX_HTTP) || string2.startsWith(PREFIX_HTTPS) ? NSString.stringWith("%#") : NSString.stringWith("%");
        NSString nSString2 = NSString.stringWith(string);
        if (NSFileManager.defaultManager().fileExistsAtPath(nSString2)) {
            nSString2 = NSURL.fileURLWithPath(nSString2).absoluteString();
        }
        long l = OS.CFURLCreateStringByAddingPercentEscapes(0L, nSString2.id, nSString.id, 0L, 0x8000100);
        NSString nSString3 = new NSString(l);
        NSURL nSURL = NSURL.URLWithString(nSString3);
        OS.CFRelease(l);
        return nSURL;
    }

    static boolean isExecutable(String string) {
        long l = OS.malloc(1L);
        NSString nSString = NSString.stringWith(string);
        boolean bl = false;
        NSFileManager nSFileManager = NSFileManager.defaultManager();
        if (nSFileManager.fileExistsAtPath(nSString, l)) {
            byte[] byArray = new byte[1];
            OS.memmove(byArray, l, 1L);
            if (byArray[0] == 0 && nSFileManager.isExecutableFileAtPath(nSString)) {
                NSWorkspace nSWorkspace = NSWorkspace.sharedWorkspace();
                NSString nSString2 = nSWorkspace.typeOfFile(nSString, 0L);
                bl = nSString2 != null && (nSWorkspace.type(nSString2, NSString.stringWith("public.unix-executable")) || OS.UTTypeEqual(nSString2.id, NSString.stringWith((String)"public.shell-script").id));
            }
        }
        OS.free(l);
        return bl;
    }

    public static boolean launch(String string) {
        return Program.launch(string, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean launch(String string, String string2) {
        boolean bl;
        NSAutoreleasePool nSAutoreleasePool;
        block8: {
            block7: {
                if (string == null) {
                    SWT.error(4);
                }
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
                try {
                    if (string2 != null && Program.isExecutable(string)) {
                        try {
                            Compatibility.exec(new String[]{string}, null, string2);
                        }
                        catch (IOException iOException) {
                            Object var5_4 = null;
                            nSAutoreleasePool.release();
                            return false;
                        }
                        Object var5_3 = null;
                        break block7;
                    }
                    NSURL nSURL = Program.getURL(string);
                    NSWorkspace nSWorkspace = NSWorkspace.sharedWorkspace();
                    bl = nSWorkspace.openURL(nSURL);
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    nSAutoreleasePool.release();
                    throw throwable;
                }
            }
            nSAutoreleasePool.release();
            return true;
        }
        Object var5_5 = null;
        nSAutoreleasePool.release();
        return bl;
    }

    public boolean execute(String string) {
        boolean bl;
        if (string == null) {
            SWT.error(4);
        }
        NSAutoreleasePool nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        try {
            NSWorkspace nSWorkspace = NSWorkspace.sharedWorkspace();
            NSURL nSURL = Program.getURL(string);
            NSArray nSArray = NSArray.arrayWithObject(nSURL);
            bl = nSWorkspace.openURLs(nSArray, NSString.stringWith(this.identifier), 0L, null, 0L);
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
        return bl;
    }

    public ImageData getImageData() {
        NSAutoreleasePool nSAutoreleasePool;
        block3: {
            ImageData imageData;
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            try {
                NSImage nSImage;
                NSWorkspace nSWorkspace = NSWorkspace.sharedWorkspace();
                NSString nSString = this.fullPath != null ? NSString.stringWith(this.fullPath) : nSWorkspace.fullPathForApplication(NSString.stringWith(this.name));
                if (nSString == null || (nSImage = nSWorkspace.iconForFile(nSString)) == null) break block3;
                NSSize nSSize = new NSSize();
                nSSize.height = 16.0;
                nSSize.width = 16.0;
                nSImage.setSize(nSSize);
                nSImage.retain();
                Image image = Image.cocoa_new(Display.getCurrent(), 0, nSImage);
                ImageData imageData2 = image.getImageData();
                image.dispose();
                imageData = imageData2;
                Object var8_9 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                nSAutoreleasePool.release();
                throw throwable;
            }
            nSAutoreleasePool.release();
            return imageData;
        }
        Object var8_10 = null;
        nSAutoreleasePool.release();
        return null;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Program) {
            Program program = (Program)object;
            return this.name.equals(program.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "Program {" + this.name + "}";
    }
}

