/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFPage;
import com.sun.pdfview.font.OutlineFont;
import com.sun.pdfview.font.PDFFont;
import com.sun.pdfview.font.PDFGlyph;
import com.sun.pdfview.font.Type3Font;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FontToy
extends JPanel {
    private static FontToy toy;
    private static JComboBox glyphBox;
    private Set fonts;
    private PDFFont font;
    private PDFGlyph glyph;
    private Font gfont;

    public FontToy(PDFFile pdf) throws IOException {
        PDFObject root = pdf.getRoot();
        PDFObject pagesObj = root.getDictRef("Pages");
        this.fonts = this.findFonts(pagesObj, new HashMap());
        this.gfont = new Font("Sans-serif", 0, 10);
    }

    public Set getFonts() {
        return this.fonts;
    }

    public PDFFont getCurrentFont() {
        return this.font;
    }

    public void setCurrentFont(PDFFont font) {
        this.font = font;
    }

    public PDFGlyph getCurrentGlyph() {
        return this.glyph;
    }

    public void setCurrentGlyph(PDFGlyph glyph) {
        this.glyph = glyph;
    }

    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        int width = this.getWidth();
        int height = this.getHeight();
        g2.setColor(Color.WHITE);
        g2.fillRect(0, 0, width, height);
        g2.setColor(Color.BLACK);
        if (this.glyph == null) {
            return;
        }
        GeneralPath gp = this.glyph.getShape();
        PDFPage page = this.glyph.getPage();
        if (gp != null) {
            this.drawShape(g2, gp, width, height);
        } else if (page != null) {
            this.drawPage(g2, page, width, height);
        }
    }

    private void drawShape(Graphics2D g2, GeneralPath gp, int w, int h) {
        double scaleY;
        float curX = 0.0f;
        float curY = 0.0f;
        float startX = 0.0f;
        float startY = 0.0f;
        Rectangle2D border = gp.getBounds2D();
        double scaleX = (double)(w - 20) / border.getWidth();
        if (scaleX < (scaleY = (double)(h - 20) / border.getHeight())) {
            scaleY = scaleX;
        } else {
            scaleX = scaleY;
        }
        double transX = 10.0 - border.getX() * scaleX;
        double transY = (double)(h - 10) + border.getY() * scaleY;
        AffineTransform at = new AffineTransform(scaleX, 0.0, 0.0, -scaleY, transX, transY);
        Rectangle2D borderTrans = gp.createTransformedShape(at).getBounds2D();
        g2.setColor(Color.CYAN);
        g2.fill(gp.createTransformedShape(at));
        g2.setColor(Color.BLACK);
        int num = 0;
        PathIterator pi = gp.getPathIterator(at);
        while (!pi.isDone()) {
            float[] coords = new float[6];
            switch (pi.currentSegment(coords)) {
                case 0: {
                    curX = coords[0];
                    curY = coords[1];
                    this.drawPoint(g2, num++, curX, curY, false);
                    startX = curX;
                    startY = curY;
                    break;
                }
                case 1: {
                    Line2D.Float line = new Line2D.Float(curX, curY, coords[0], coords[1]);
                    g2.draw(line);
                    this.drawPoint(g2, num++, coords[0], coords[1], false);
                    curX = coords[0];
                    curY = coords[1];
                    break;
                }
                case 3: {
                    CubicCurve2D.Float curve = new CubicCurve2D.Float(curX, curY, coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    g2.draw(curve);
                    this.drawPoint(g2, num++, coords[0], coords[1], true);
                    this.drawPoint(g2, num++, coords[2], coords[3], true);
                    this.drawPoint(g2, num++, coords[4], coords[5], false);
                    curX = coords[4];
                    curY = coords[5];
                    break;
                }
                case 2: {
                    QuadCurve2D.Float curveQ = new QuadCurve2D.Float(curX, curY, coords[0], coords[1], coords[2], coords[3]);
                    g2.draw(curveQ);
                    this.drawPoint(g2, num++, coords[0], coords[1], true);
                    this.drawPoint(g2, num++, coords[2], coords[3], false);
                    curX = coords[2];
                    curY = coords[3];
                    break;
                }
                case 4: {
                    Line2D.Float line2 = new Line2D.Float(curX, curY, startX, startY);
                    g2.draw(line2);
                    curX = startX;
                    curY = startY;
                }
            }
            pi.next();
        }
    }

    public void drawPoint(Graphics2D g, int num, float x, float y, boolean curvectl) {
        GeneralPath gp = new GeneralPath();
        if (curvectl) {
            gp.moveTo(x - 1.0f, y - 1.0f);
            gp.lineTo(x + 1.0f, y + 1.0f);
            gp.moveTo(x - 1.0f, y + 1.0f);
            gp.lineTo(x + 1.0f, y - 1.0f);
        } else {
            gp.moveTo(x - 1.0f, y - 1.0f);
            gp.lineTo(x - 1.0f, y + 1.0f);
            gp.lineTo(x + 1.0f, y + 1.0f);
            gp.lineTo(x + 1.0f, y - 1.0f);
            gp.closePath();
        }
        g.setColor(Color.red);
        g.draw(gp);
        g.setColor(Color.blue);
        g.setFont(this.gfont);
        g.drawString(String.valueOf(num), x + 3.0f, y + 3.0f);
    }

    private void drawPage(Graphics2D g2, PDFPage page, int w, int h) {
        Dimension pageSize = page.getUnstretchedSize(w - 20, h - 20, null);
        Image image = page.getImage(pageSize.width, pageSize.height, null, null, true, true);
        g2.drawImage(image, 0, 0, null);
    }

    private Set findFonts(PDFObject pagedict, Map resources) throws IOException {
        PDFObject kidsObj;
        HashSet<PDFFont> outSet = new HashSet<PDFFont>();
        PDFObject rsrcObj = pagedict.getDictRef("Resources");
        if (rsrcObj != null) {
            String key;
            Iterator i;
            HashMap rsrcMap = new HashMap();
            rsrcMap.putAll(resources);
            HashMap rsrc = rsrcObj.getDictionary();
            rsrcMap.putAll(rsrc);
            if (rsrc.containsKey("Font")) {
                PDFObject fontsObj = (PDFObject)rsrc.get("Font");
                i = fontsObj.getDictKeys();
                while (i.hasNext()) {
                    key = (String)i.next();
                    PDFObject fontObj = fontsObj.getDictRef(key);
                    try {
                        PDFFont font = PDFFont.getFont(fontObj, rsrcMap);
                        outSet.add(font);
                    }
                    catch (Exception ex) {
                        System.out.println("Error finding font from " + fontObj);
                        ex.printStackTrace();
                    }
                }
            }
            if (rsrc.containsKey("XObject")) {
                PDFObject xobjsObj = (PDFObject)rsrc.get("XObject");
                i = xobjsObj.getDictKeys();
                while (i.hasNext()) {
                    key = (String)i.next();
                    PDFObject xobj = xobjsObj.getDictRef(key);
                    outSet.addAll(this.findFonts(xobj, new HashMap()));
                }
            }
            resources = rsrcMap;
        }
        if ((kidsObj = pagedict.getDictRef("Kids")) != null) {
            PDFObject[] kids = kidsObj.getArray();
            for (int i = 0; i < kids.length; ++i) {
                outSet.addAll(this.findFonts(kids[i], resources));
            }
        }
        return outSet;
    }

    private static void keyPressed(KeyEvent k) {
        int curIndex;
        int nextIndex = curIndex = glyphBox.getSelectedIndex();
        if (k.getKeyCode() == 37) {
            if (--nextIndex < 0) {
                nextIndex = glyphBox.getItemCount() - 1;
            }
        } else if (k.getKeyCode() == 39 && ++nextIndex >= glyphBox.getItemCount()) {
            nextIndex = 0;
        }
        if (nextIndex != curIndex) {
            glyphBox.setSelectedIndex(nextIndex);
        }
    }

    private static void glyphSelected(Integer glyphID) {
        char glyphChar = (char)glyphID.intValue();
        String s = String.valueOf(glyphChar);
        PDFFont font = toy.getCurrentFont();
        List l = font.getGlyphs(s);
        PDFGlyph glyph = (PDFGlyph)l.get(0);
        toy.setCurrentGlyph(glyph);
        toy.repaint();
    }

    private static void fontSelected(PDFFont font) {
        toy.setCurrentFont(font);
        int start = 0;
        int end = 255;
        if (font instanceof OutlineFont) {
            start = ((OutlineFont)font).getFirstChar();
            end = ((OutlineFont)font).getLastChar();
        } else if (font instanceof Type3Font) {
            start = ((Type3Font)font).getFirstChar();
            end = ((Type3Font)font).getLastChar();
        }
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 255;
        }
        Vector<Integer> objs = new Vector<Integer>(end - start + 1);
        for (int i = start; i <= end; ++i) {
            objs.add(new Integer(i));
        }
        glyphBox.setModel(new DefaultComboBoxModel(objs));
        FontToy.glyphSelected(new Integer(start));
    }

    private static void createUI() throws Exception {
        Box controlPanel = Box.createHorizontalBox();
        glyphBox = new JComboBox();
        glyphBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                if (ie.getStateChange() == 1) {
                    FontToy.glyphSelected((Integer)ie.getItem());
                }
            }
        });
        Object[] fontObjs = toy.getFonts().toArray();
        JComboBox<Object> comboBox = new JComboBox<Object>(fontObjs);
        comboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                if (ie.getStateChange() == 1) {
                    FontToy.fontSelected((PDFFont)ie.getItem());
                }
            }
        });
        comboBox.setMaximumSize(new Dimension(200, 50));
        FontToy.fontSelected((PDFFont)fontObjs[0]);
        controlPanel.add(new JLabel("Fonts:"));
        controlPanel.add(comboBox);
        controlPanel.add(Box.createHorizontalStrut(15));
        controlPanel.add(new JLabel("Glyphs:"));
        controlPanel.add(glyphBox);
        JPanel ftPanel = new JPanel();
        ftPanel.setLayout(new BorderLayout());
        ftPanel.add((Component)controlPanel, "North");
        ftPanel.add((Component)toy, "Center");
        ftPanel.setFocusable(true);
        ftPanel.requestFocus();
        ftPanel.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent k) {
                this.keyPressed(k);
            }
        });
        JFrame jf = new JFrame("Font Toy");
        jf.setContentPane(ftPanel);
        jf.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                System.exit(-1);
            }
        });
        jf.setSize(640, 480);
        jf.show();
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage:");
            System.out.println("    FontToy <pdf-file>");
            System.exit(-1);
        }
        String fileName = args[0];
        try {
            RandomAccessFile raf = new RandomAccessFile(fileName, "r");
            FileChannel channel = raf.getChannel();
            MappedByteBuffer buf = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
            PDFFile file = new PDFFile(buf);
            toy = new FontToy(file);
            FontToy.createUI();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

