/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSBitmapImageRep;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSDockTile;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TaskBar;

public class TaskItem
extends Item {
    TaskBar parent;
    Shell shell;
    NSImage defaultImage;
    int progress;
    int iProgress;
    int progressState = -1;
    Image overlayImage;
    String overlayText = "";
    Menu menu;
    static final int PROGRESS_MAX = 100;
    static final int PROGRESS_TIMER = 350;
    static final int PROGRESS_BARS = 7;

    TaskItem(TaskBar taskBar, int n) {
        super(taskBar, n);
        this.parent = taskBar;
        taskBar.createItem(this, -1);
        this.createWidget();
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void createWidget() {
        NSApplication nSApplication = NSApplication.sharedApplication();
        NSImage nSImage = nSApplication.applicationIconImage();
        this.defaultImage = new NSImage(nSImage.copy());
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    public Image getOverlayImage() {
        this.checkWidget();
        return this.overlayImage;
    }

    public String getOverlayText() {
        this.checkWidget();
        return this.overlayText;
    }

    public TaskBar getParent() {
        this.checkWidget();
        return this.parent;
    }

    public int getProgress() {
        this.checkWidget();
        return this.progress;
    }

    public int getProgressState() {
        this.checkWidget();
        return this.progressState;
    }

    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
        if (this.defaultImage != null) {
            this.defaultImage.release();
        }
        this.defaultImage = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.overlayImage = null;
        this.overlayText = null;
        this.shell = null;
    }

    public void setMenu(Menu menu) {
        this.checkWidget();
        if (menu != null) {
            if (menu.isDisposed()) {
                SWT.error(5);
            }
            if ((menu.style & 8) == 0) {
                this.error(37);
            }
        }
        this.menu = menu;
    }

    public void setOverlayImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.overlayImage = image;
        this.updateOverlayText(image != null ? null : this.overlayText);
        this.updateImage();
    }

    public void setOverlayText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.overlayText = string;
        this.updateOverlayText(string);
        this.updateImage();
    }

    public void setProgress(int n) {
        this.checkWidget();
        n = Math.max(0, Math.min(n, 100));
        if (this.progress == n) {
            return;
        }
        this.progress = n;
        this.updateImage();
    }

    public void setProgressState(int n) {
        this.checkWidget();
        if (this.progressState == n) {
            return;
        }
        this.progressState = n;
        this.updateImage();
    }

    void setShell(Shell shell) {
        this.shell = shell;
        shell.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                if (TaskItem.this.isDisposed()) {
                    return;
                }
                TaskItem.this.dispose();
            }
        });
    }

    void updateImage() {
        boolean bl;
        boolean bl2 = this.progress != 0 && this.progressState != -1;
        boolean bl3 = this.progressState == 2;
        NSApplication nSApplication = NSApplication.sharedApplication();
        NSDockTile nSDockTile = nSApplication.dockTile();
        boolean bl4 = bl = this.overlayImage != null && nSDockTile.badgeLabel() == null;
        if (!(bl || bl2 || bl3)) {
            nSApplication.setApplicationIconImage(this.defaultImage);
            return;
        }
        NSSize nSSize = this.defaultImage.size();
        NSImage nSImage = (NSImage)new NSImage().alloc();
        nSImage = nSImage.initWithSize(nSSize);
        NSBitmapImageRep nSBitmapImageRep = (NSBitmapImageRep)new NSBitmapImageRep().alloc();
        nSBitmapImageRep = nSBitmapImageRep.initWithBitmapDataPlanes(0L, (int)nSSize.width, (int)nSSize.height, 8L, 4L, true, false, OS.NSDeviceRGBColorSpace, 3L, (int)nSSize.width * 4, 32L);
        nSImage.addRepresentation(nSBitmapImageRep);
        nSBitmapImageRep.release();
        NSRect nSRect = new NSRect();
        nSRect.height = nSSize.height;
        nSRect.width = nSSize.width;
        nSImage.lockFocus();
        this.defaultImage.drawInRect(nSRect, nSRect, 2L, 1.0);
        if (bl) {
            NSImage nSImage2 = this.overlayImage.handle;
            NSSize nSSize2 = nSImage2.size();
            NSRect nSRect2 = new NSRect();
            nSRect2.height = nSSize2.height;
            nSRect2.width = nSSize2.width;
            NSRect nSRect3 = new NSRect();
            nSRect3.x = nSSize.width / 2.0;
            nSRect3.height = nSSize.height / 2.0;
            nSRect3.width = nSSize.width / 2.0;
            nSImage2.drawInRect(nSRect3, nSRect2, 2L, 1.0);
        }
        if (bl3 || bl2) {
            int n;
            switch (this.progressState) {
                case 1: {
                    NSColor.colorWithDeviceRed(1.0, 0.0, 0.0, 0.6f).setFill();
                    break;
                }
                case 4: {
                    NSColor.colorWithDeviceRed(1.0, 1.0, 0.0, 0.6f).setFill();
                    break;
                }
                default: {
                    NSColor.colorWithDeviceRed(1.0, 1.0, 1.0, 0.6f).setFill();
                }
            }
            nSRect.width = nSSize.width / 13.0;
            nSRect.height = nSSize.height / 3.0;
            if (bl3) {
                n = this.iProgress;
                this.iProgress = (this.iProgress + 1) % 8;
                this.getDisplay().timerExec(350, new Runnable(){

                    public void run() {
                        TaskItem.this.updateImage();
                    }
                });
            } else {
                n = this.progress * 7 / 100;
            }
            int n2 = 0;
            while (n2 <= n) {
                nSRect.x = (double)(n2 * 2) * nSRect.width;
                NSBezierPath.fillRect(nSRect);
                ++n2;
            }
        }
        nSImage.unlockFocus();
        nSApplication.setApplicationIconImage(nSImage);
        nSImage.release();
    }

    void updateOverlayText(String string) {
        NSApplication nSApplication = NSApplication.sharedApplication();
        NSDockTile nSDockTile = nSApplication.dockTile();
        if (string != null && string.length() > 0) {
            nSDockTile.setBadgeLabel(NSString.stringWith(string));
        } else {
            nSDockTile.setBadgeLabel(null);
        }
    }
}

