/*
 * Decompiled with CFR 0.152.
 */
package javasrc.app;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javasrc.app.HTMLOutputWriter;
import javasrc.app.LineOutputWriter;
import javasrc.symtab.HTMLTag;
import javasrc.symtab.HTMLTagContainer;
import javasrc.symtab.PackageDef;
import javasrc.symtab.SymbolTable;
import javasrc.util.JSCollections;
import javasrc.util.SkipCRInputStream;
import javasrc.xref.FileListener;
import javasrc.xref.JavaXref;

public class Pass1
implements FileListener {
    public static final String DEFAULT_DIR = ".";
    public static final String USAGE = "Usage: java [-Doutdir=<doc dir>][-Dtitle=<title>][-Dverbose=true]javasrc.Pass1 <source dir> [<source dir> <source dir> ...]";
    private HashSet inputFiles = new HashSet();
    private int _currentColumn;
    private int _currentChar;
    private String _outDir;
    private String _title;
    private boolean _doRecurse;
    private boolean _verbose;
    private boolean debug = false;

    public String getOutDir() {
        return this._outDir;
    }

    public void setOutDir(String string) {
        this._outDir = string;
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String string) {
        this._title = string;
    }

    public boolean getRecurse() {
        return this._doRecurse;
    }

    public void setRecurse(boolean bl) {
        this._doRecurse = bl;
    }

    public void setVerbose(boolean bl) {
        this._verbose = bl;
    }

    public boolean getVerbose() {
        return this._verbose;
    }

    public void notify(String string) {
        System.out.println("\t" + string);
        this.inputFiles.add(string);
    }

    public void run(String[] stringArray) {
        try {
            SymbolTable symbolTable = SymbolTable.getSymbolTable();
            if (stringArray.length > 0) {
                this.initializeDefaults();
                System.out.println("outDirPath is " + this.getOutDir());
                symbolTable.setOutDirPath(this.getOutDir());
                System.err.println("Parsing...");
                int n = 0;
                while (n < stringArray.length) {
                    JavaXref.doFile(new File(stringArray[n]), symbolTable, this.getRecurse(), this);
                    ++n;
                }
                System.err.println("Resolving types...");
                symbolTable.resolveTypes();
                symbolTable.resolveRefs();
            } else {
                System.err.println(USAGE);
            }
            Hashtable hashtable = symbolTable.getPackages();
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                PackageDef packageDef = (PackageDef)enumeration.nextElement();
                System.out.println("Processing package " + packageDef.getName());
                HTMLTagContainer hTMLTagContainer = new HTMLTagContainer();
                packageDef.generateTags(hTMLTagContainer);
                Hashtable hashtable2 = hTMLTagContainer.getFileTable();
                Enumeration enumeration2 = hashtable2.keys();
                Vector vector = new Vector();
                while (enumeration2.hasMoreElements()) {
                    vector.clear();
                    File file = (File)enumeration2.nextElement();
                    if (!this.inputFiles.contains(file.getAbsolutePath())) continue;
                    Vector vector2 = (Vector)hashtable2.get(file);
                    vector.addAll(vector2);
                    SymbolTable.createReferenceTags(file, vector);
                    SymbolTable.getCommentTags(file, vector);
                    this.createClassFiles(vector);
                }
                System.out.println("\nPersisting definitions...");
                packageDef.persistDefinitions(this.getOutDir());
            }
            System.out.println("\nPersisting references...");
            symbolTable.persistRefs(this.getOutDir());
        }
        catch (Exception exception) {
            System.err.println("exception: " + exception);
            exception.printStackTrace(System.err);
            System.exit(1);
        }
    }

    public void initializeDefaults() {
        String string = System.getProperty("outdir");
        if (string == null) {
            string = DEFAULT_DIR;
        }
        this.setOutDir(string);
        String string2 = System.getProperty("title");
        if (string2 == null) {
            string2 = "Pass1: " + string;
        }
        this.setTitle(string2);
        boolean bl = true;
        String string3 = System.getProperty("recurse");
        if (string3 != null && ((string3 = string3.trim()).equalsIgnoreCase("off") || string3.equalsIgnoreCase("false") || string3.equalsIgnoreCase("no") || string3.equalsIgnoreCase("0"))) {
            bl = false;
        }
        this.setRecurse(bl);
        boolean bl2 = false;
        String string4 = System.getProperty("verbose");
        if (string4 != null && ((string4 = string4.trim()).equalsIgnoreCase("on") || string4.equalsIgnoreCase("true") || string4.equalsIgnoreCase("yes") || string4.equalsIgnoreCase("1"))) {
            bl2 = true;
        }
        this.setVerbose(bl2);
    }

    public void createDirs(File file) {
        String string = file.getParent();
        File file2 = new File(string);
        if (!file2.exists()) {
            file2.mkdirs();
        }
    }

    public String getBackupPath(Object[] objectArray, int n) {
        HTMLTag hTMLTag = (HTMLTag)objectArray[n];
        String string = hTMLTag.getPackageName();
        if (string.equals("")) {
            File file = hTMLTag.getFile();
            int n2 = Math.min(n + 1, objectArray.length);
            HTMLTag hTMLTag2 = (HTMLTag)objectArray[n2];
            while (hTMLTag2.getFile().equals(file) && n2 < objectArray.length) {
                if (hTMLTag2.getPackageName() != null && hTMLTag2.getPackageName().length() > 0) {
                    string = hTMLTag2.getPackageName();
                    break;
                }
                hTMLTag2 = (HTMLTag)objectArray[++n2];
            }
        }
        return Pass1.getBackupPath(string);
    }

    public static String getBackupPath(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, DEFAULT_DIR);
        String string2 = "";
        int n = 0;
        String string3 = "";
        n = stringTokenizer.countTokens();
        int n2 = 0;
        while (n2 < n) {
            string2 = string2 + ".." + File.separatorChar;
            ++n2;
        }
        string3 = string2;
        return string3;
    }

    public HTMLOutputWriter createClassFile(Object[] objectArray, int n) throws IOException {
        Object object;
        Object object2;
        HTMLTag hTMLTag = (HTMLTag)objectArray[n];
        String string = hTMLTag.getPackageName();
        if (string.equals("")) {
            object2 = hTMLTag.getFile();
            int n2 = Math.min(n + 1, objectArray.length);
            object = (HTMLTag)objectArray[n2];
            while (((HTMLTag)object).getFile().equals(object2) && n2 < objectArray.length) {
                if (((HTMLTag)object).getPackageName() != null && ((HTMLTag)object).getPackageName().length() > 0) {
                    string = ((HTMLTag)object).getPackageName();
                    break;
                }
                object = (HTMLTag)objectArray[++n2];
            }
        }
        object2 = hTMLTag.getFile().toString();
        if (this.debug) {
            System.out.println("Package name=" + hTMLTag.getPackageName());
        }
        String string2 = string.replace('.', File.separatorChar);
        object = string.replace('.', '/');
        String string3 = this.getOutDir() + File.separatorChar + string2;
        int n3 = ((String)object2).lastIndexOf(File.separatorChar);
        if (n3 == -1) {
            n3 = 0;
        }
        String string4 = ((String)object2).substring(n3, ((String)object2).length());
        String string5 = string4.substring(0, string4.lastIndexOf(46)).replace(File.separatorChar, '.');
        string4 = string4.replace('.', '_');
        string4 = string4 + ".html";
        String string6 = string3 + File.separatorChar + string4;
        File file = new File(string6);
        this.createDirs(file);
        LineOutputWriter lineOutputWriter = new LineOutputWriter(new BufferedOutputStream(new FileOutputStream(file)));
        String string7 = this.getBackupPath(objectArray, n);
        String string8 = "<head>\n<LINK rel=\"stylesheet\" type=\"text/css\" name=\"style1\" href=\"" + string7 + "styles.css\">\n" + "</head>\n";
        lineOutputWriter.write(string8, 0, string8.length());
        string2 = string.replace('.', '/');
        String string9 = "<script language=javascript>\n<!-- Hide from non-javascript browsers\nbrowserName=navigator.appName;\nif (browserName.indexOf('Netscape')>=0)\n{\nparent.filenameFrame.document.layers[0].document.clear();\nparent.filenameFrame.document.layers[0].document.open();\nparent.filenameFrame.document.layers[0].document.write(\n'<A HREF=\"" + string2 + "/classList.html\" " + "TARGET=\"packageFrame\">" + string + "</A>: " + SymbolTable.getClassList(hTMLTag.getFile()) + "');" + "parent.filenameFrame.document.layers[0].document.close();\n" + "}\n" + "if (browserName.indexOf('Microsoft')>=0)\n" + "{\n" + "parent.frames.filenameFrame.textDiv.innerHTML=" + "'<A HREF=\"" + string2 + "/classList.html\" " + "TARGET=\"packageFrame\">" + string + "</A>: " + SymbolTable.getClassList(hTMLTag.getFile()) + "';" + "}\n" + "//-->\n" + "</script>";
        lineOutputWriter.write(string9, 0, string9.length());
        lineOutputWriter.write("<pre>\n", 0, 6);
        return lineOutputWriter;
    }

    public void finishFile(LineNumberReader lineNumberReader, HTMLOutputWriter hTMLOutputWriter) throws IOException {
        while (this._currentChar != -1) {
            hTMLOutputWriter.writeHTML(this._currentChar);
            this._currentChar = lineNumberReader.read();
        }
        lineNumberReader.close();
        hTMLOutputWriter.write("</pre>\n", 0, 7);
        hTMLOutputWriter.flush();
        hTMLOutputWriter.close();
    }

    public void writeUntilNextTag(HTMLTag hTMLTag, LineNumberReader lineNumberReader, HTMLOutputWriter hTMLOutputWriter) throws IOException {
        if (this.debug) {
            System.out.print("\nLooking for next tag line:|");
        }
        while (this._currentChar != -1 && lineNumberReader.getLineNumber() + 1 != hTMLTag.getLine()) {
            hTMLOutputWriter.writeHTML(this._currentChar);
            if (this.debug) {
                System.out.write(this._currentChar);
            }
            this._currentChar = lineNumberReader.read();
        }
        hTMLOutputWriter.writeHTML(this._currentChar);
        if (this.debug) {
            System.out.write(this._currentChar);
        }
        this._currentChar = lineNumberReader.read();
        if (this.debug) {
            System.out.println("|");
        }
    }

    public void writeComment(HTMLTag hTMLTag, LineNumberReader lineNumberReader, HTMLOutputWriter hTMLOutputWriter) throws IOException {
        int n = hTMLTag.getLength();
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer(n);
        hTMLOutputWriter.write("<span class=\"comment\">");
        while (n2 < n) {
            hTMLOutputWriter.writeHTML((char)this._currentChar);
            if (this._currentChar == 10) {
                this._currentColumn = 0;
            }
            this._currentChar = lineNumberReader.read();
            ++this._currentColumn;
            ++n2;
        }
        hTMLOutputWriter.write("</span>");
        if (this._currentChar == 10) {
            this._currentColumn = 0;
        }
    }

    public void writeHTMLTag(HTMLTag hTMLTag, LineNumberReader lineNumberReader, HTMLOutputWriter hTMLOutputWriter) throws IOException {
        if (this.debug) {
            System.out.println("\nCurrent column=" + this._currentColumn);
            System.out.print("\nWriting up to tag start:|");
        }
        while (this._currentColumn < hTMLTag.getStartColumn()) {
            hTMLOutputWriter.writeHTML(this._currentChar);
            if (this._currentChar == 10) {
                this._currentColumn = 0;
            }
            if (this.debug) {
                System.out.write(this._currentChar);
            }
            this._currentChar = lineNumberReader.read();
            ++this._currentColumn;
        }
        if (this.debug) {
            System.out.println("|");
        }
        if (hTMLTag.isComment()) {
            this.writeComment(hTMLTag, lineNumberReader, hTMLOutputWriter);
        } else {
            hTMLOutputWriter.write(hTMLTag.getText());
            if (this.debug) {
                System.out.println("Wrote tag:" + hTMLTag.getText());
            }
            int n = hTMLTag.getOrigLength();
            n -= hTMLTag.getNumBreaks();
            if (this.debug) {
                System.out.print("\nSkipping:\"");
            }
            int n2 = 0;
            while (n2 < n) {
                if (this.debug) {
                    System.out.write(this._currentChar);
                }
                if (this._currentChar == 10) {
                    this._currentColumn = 0;
                }
                this._currentChar = lineNumberReader.read();
                ++this._currentColumn;
                ++n2;
            }
            if (this._currentChar == 10) {
                this._currentColumn = 0;
            }
        }
    }

    public void createClassFiles(Vector vector) {
        LineNumberReader lineNumberReader;
        HTMLOutputWriter hTMLOutputWriter;
        Object var4_2 = null;
        Object[] objectArray = JSCollections.sortVector(vector);
        HTMLTag hTMLTag = (HTMLTag)objectArray[0];
        File file = hTMLTag.getFile();
        System.out.println("Writing tags for file " + file.toString());
        try {
            hTMLOutputWriter = this.createClassFile(objectArray, 0);
            lineNumberReader = new LineNumberReader(new InputStreamReader(new SkipCRInputStream(new FileInputStream(file))));
            this._currentChar = lineNumberReader.read();
            this._currentColumn = 1;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
            System.out.println("1: Could not open file:" + file.getAbsolutePath());
            System.out.println("   or html file.");
            return;
        }
        int n = 0;
        while (n < objectArray.length) {
            block16: {
                hTMLTag = (HTMLTag)objectArray[n];
                if (this.debug) {
                    System.out.println("\nTag Text=\"" + hTMLTag.getText() + "\"");
                    System.out.println("Length=" + hTMLTag.getOrigLength());
                    System.out.println("Line,col=" + hTMLTag.getLine() + "," + hTMLTag.getStartColumn());
                }
                String string = file.toString();
                String string2 = hTMLTag.getFile().toString();
                if (this.debug) {
                    System.out.println("cur file=|" + string + "|");
                }
                if (this.debug) {
                    System.out.println("new file=|" + string2 + "|");
                }
                if (!string2.equals(string)) {
                    try {
                        this.finishFile(lineNumberReader, hTMLOutputWriter);
                        file = hTMLTag.getFile();
                        lineNumberReader = new LineNumberReader(new InputStreamReader(new SkipCRInputStream(new FileInputStream(file))));
                        hTMLOutputWriter = this.createClassFile(objectArray, n);
                        this._currentColumn = 1;
                        this._currentChar = lineNumberReader.read();
                    }
                    catch (Exception exception) {
                        System.out.println("2: Error handling tag:" + hTMLTag);
                        System.out.println(exception);
                        exception.printStackTrace();
                        break block16;
                    }
                }
                if (hTMLTag.getLine() != lineNumberReader.getLineNumber() + 1) {
                    this._currentColumn = 1;
                    try {
                        this.writeUntilNextTag(hTMLTag, lineNumberReader, hTMLOutputWriter);
                    }
                    catch (Exception exception) {
                        System.out.println("3: Error handling tag:" + hTMLTag);
                        System.out.println(exception);
                        exception.printStackTrace();
                        break block16;
                    }
                }
                try {
                    this.writeHTMLTag(hTMLTag, lineNumberReader, hTMLOutputWriter);
                }
                catch (Exception exception) {
                    System.out.println("4: Error handling tag:" + hTMLTag);
                    System.out.println(exception);
                    exception.printStackTrace();
                }
            }
            ++n;
        }
        try {
            this.finishFile(lineNumberReader, hTMLOutputWriter);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) {
        Pass1 pass1 = new Pass1();
        pass1.initializeDefaults();
        pass1.run(stringArray);
    }
}

