/*
 * Decompiled with CFR 0.152.
 */
package javasrc.symtab;

import java.io.Externalizable;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Hashtable;
import javasrc.symtab.ClassDef;
import javasrc.symtab.Definition;
import javasrc.symtab.HTMLTag;
import javasrc.symtab.HTMLTagContainer;
import javasrc.symtab.JavaHashtable;
import javasrc.symtab.JavaVector;
import javasrc.symtab.Occurrence;
import javasrc.symtab.PackageDef;
import javasrc.symtab.ScopedDef;
import javasrc.symtab.SymbolTable;
import javasrc.symtab.Visitor;

public class ClassDefProxy
extends ClassDef
implements Externalizable {
    private Throwable whereCreated = new Throwable();
    private ClassDef ref;

    public ClassDef getSuperClass() {
        this.load();
        return this.ref.getSuperClass();
    }

    public boolean isClass() {
        this.load();
        return this.ref.isClass();
    }

    public boolean isInterface() {
        this.load();
        return this.ref.isInterface();
    }

    public HTMLTag getOccurenceTag(Occurrence occurrence) {
        this.load();
        return this.ref.getOccurrenceTag(occurrence);
    }

    public String getSourceName() {
        this.load();
        return this.ref.getSourceName();
    }

    public String getRefName() {
        this.load();
        return this.ref.getRefName();
    }

    String getRelativePath(Occurrence occurrence) {
        this.load();
        return this.ref.getRelativePath(occurrence);
    }

    public Occurrence getOccurrence() {
        this.load();
        return this.ref.getOccurrence();
    }

    public ScopedDef getParentScope() {
        this.load();
        return this.ref.getParentScope();
    }

    public String getPackagePath() {
        this.load();
        return this.ref.getPackagePath();
    }

    public JavaVector getReferences() {
        this.load();
        return null;
    }

    Definition lookup(String string, int n, Class clazz) {
        this.load();
        return this.ref.lookup(string, n, clazz);
    }

    public Hashtable getSymbols() {
        return null;
    }

    public JavaHashtable getElements() {
        this.load();
        return this.ref.getElements();
    }

    boolean hasElements() {
        this.load();
        return this.ref.hasElements();
    }

    public boolean isDefaultOrBaseScope() {
        this.load();
        return this.ref.isDefaultOrBaseScope();
    }

    void resolveTypes() {
    }

    void resolveRefs() {
    }

    void closeImports() {
        new Exception().printStackTrace();
    }

    boolean isTopLevel() {
        return this.packageName != null;
    }

    void setImports(JavaHashtable javaHashtable) {
        this.load();
        this.ref.setImports(javaHashtable);
    }

    void addImplementer(ClassDef classDef) {
    }

    void addSubclass(ClassDef classDef) {
    }

    public JavaVector getImplementers() {
        return null;
    }

    JavaVector getSubClasses() {
        return null;
    }

    public void generateReferences(FileWriter fileWriter) {
    }

    public void generateTags(HTMLTagContainer hTMLTagContainer) {
        this.load();
        this.ref.generateTags(hTMLTagContainer);
    }

    public void addReference(Occurrence occurrence) {
        this.load();
        this.ref.addReference(occurrence);
    }

    public void accept(Visitor visitor) {
        this.load();
        this.ref.accept(visitor);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.getName());
        objectOutput.writeObject(this.packageName);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.setName((String)objectInput.readObject());
        this.packageName = (String)objectInput.readObject();
        if (this.packageName == null) {
            throw new IOException("null packagename: " + this.getName());
        }
    }

    private void load() {
        if (this.packageName == null) {
            System.out.println("null packageName, name=" + this.getName());
            System.exit(1);
        }
        if (this.ref == null) {
            this.ref = ClassDef.findLoadedClass(this.packageName, this.getName());
            if (this.ref == null) {
                PackageDef packageDef = SymbolTable.getSymbolTable().lookupPackage(this.packageName);
                this.ref = packageDef.loadClassDef(this.getName());
            }
        }
        if (this.ref == null) {
            new Exception("cannot load ClassDef for " + this.getName()).printStackTrace();
        }
    }

    public ClassDefProxy() {
    }

    public ClassDefProxy(ClassDef classDef) {
        if (classDef.getName().equals("RuntimeException")) {
            new Exception("what's up with this: " + classDef).printStackTrace();
        }
        this.setName(classDef.getName());
        this.packageName = classDef.getPackageName();
    }
}

