/*
 * Decompiled with CFR 0.152.
 */
package javasrc.symtab;

import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javasrc.symtab.Definition;
import javasrc.symtab.HTMLTag;

public class Occurrence
implements Externalizable {
    private File file;
    private int line;
    private int column;
    private String _packageName = "";
    private String _className = "";
    private String _methodName = "";
    private Definition _myDefinition;

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public File getFile() {
        return this.file;
    }

    public String getPackageName() {
        return this._packageName;
    }

    public String getClassName() {
        return this._className;
    }

    public String getMethodName() {
        return this._methodName;
    }

    public Definition getDefinition() {
        return this._myDefinition;
    }

    public void setPackageName(String string) {
        this._packageName = string != null ? string.intern() : string;
    }

    public void setClassName(String string) {
        this._className = string != null ? string.intern() : string;
    }

    public void setMethodName(String string) {
        this._methodName = string != null ? string.intern() : string;
    }

    public void setDefinition(Definition definition) {
        this._myDefinition = definition;
    }

    public HTMLTag getOccurrenceTag() {
        Definition definition = this.getDefinition();
        return definition.getOccurrenceTag(this);
    }

    public String getLinkReference() {
        String string = this.getFile().getName();
        string = string.replace('.', '_');
        string = string + ".html";
        string = string + "#" + Integer.toString(this.line);
        return string;
    }

    public String getLocation() {
        return "[" + this.file + ":" + this.line + ":" + this.column + "]";
    }

    public String toString() {
        return "Occurrence [" + this.file + "," + this.line + "," + this.column + "]";
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.file.getAbsolutePath());
        objectOutput.writeInt(this.line);
        objectOutput.writeInt(this.column);
        objectOutput.writeObject(this._packageName);
        objectOutput.writeObject(this._className);
        objectOutput.writeObject(this._methodName);
        objectOutput.writeObject(this._myDefinition);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        String string = (String)objectInput.readObject();
        this.file = new File(string);
        this.line = objectInput.readInt();
        this.column = objectInput.readInt();
        this._packageName = (String)objectInput.readObject();
        this._className = (String)objectInput.readObject();
        this._methodName = (String)objectInput.readObject();
        this._myDefinition = (Definition)objectInput.readObject();
    }

    public Occurrence() {
    }

    Occurrence(File file, int n) {
        this.file = file;
        this.line = n;
    }

    Occurrence(File file, int n, int n2) {
        this(file, n);
        this.column = n2;
    }

    Occurrence(File file, int n, int n2, String string) {
        this(file, n, n2);
        this._packageName = string != null ? string.intern() : string;
    }

    Occurrence(File file, int n, int n2, String string, String string2, String string3) {
        this(file, n, n2, string);
        this._className = string2 != null ? string2.intern() : string2;
        this._methodName = string3 != null ? string3.intern() : string3;
    }
}

