/*
 * Decompiled with CFR 0.152.
 */
package javasrc.symtab;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javasrc.symtab.BlockDef;
import javasrc.symtab.ClassDef;
import javasrc.symtab.Definition;
import javasrc.symtab.DummyClass;
import javasrc.symtab.HTMLTag;
import javasrc.symtab.JavaHashtable;
import javasrc.symtab.JavaStack;
import javasrc.symtab.JavaVector;
import javasrc.symtab.LabelDef;
import javasrc.symtab.MethodDef;
import javasrc.symtab.Occurrence;
import javasrc.symtab.PackageDef;
import javasrc.symtab.PrimitiveDef;
import javasrc.symtab.ReferencePersistor;
import javasrc.symtab.ScopedDef;
import javasrc.symtab.StringTable;
import javasrc.symtab.TypedDef;
import javasrc.symtab.VariableDef;
import javasrc.util.JSCollections;
import javasrc.util.SortableString;
import javasrc.xref.JavaToken;

public class SymbolTable {
    public static final boolean debug = false;
    public static SymbolTable singleton = null;
    private static Hashtable _fileClassDefs;
    private static Hashtable _fileReferences;
    private static Hashtable _fileComments;
    static int readLevel;
    private BlockDef baseScope = null;
    private PackageDef defaultPackage = null;
    private StringTable names = new StringTable();
    private JavaStack activeScopes;
    private JavaHashtable packages = new JavaHashtable();
    private Definition qualifiedScope;
    private File currentFile;
    private MethodDef currentMethod;
    private JavaVector demand;
    private JavaHashtable importedClasses;
    private PackageDef javaLang;
    private ClassDef object;
    private String outDirPath = null;
    private static /* synthetic */ Class class$Ljavasrc$symtab$ClassDef;

    public Hashtable getPackages() {
        return this.packages;
    }

    public static void createReferenceTags(File file, Vector vector) {
        Vector vector2 = (Vector)_fileReferences.get(file);
        if (vector2 != null) {
            Enumeration enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                Occurrence occurrence = (Occurrence)enumeration.nextElement();
                HTMLTag hTMLTag = occurrence.getOccurrenceTag();
                if (hTMLTag == null) continue;
                vector.addElement(hTMLTag);
            }
        }
    }

    public static void addFileReference(Occurrence occurrence) {
        File file = occurrence.getFile();
        Vector<Occurrence> vector = (Vector<Occurrence>)_fileReferences.get(file);
        if (vector == null) {
            vector = new Vector<Occurrence>();
            _fileReferences.put(file, vector);
        }
        vector.add(occurrence);
    }

    public static void getCommentTags(File file, Vector vector) {
        Vector vector2 = (Vector)_fileComments.get(file);
        if (vector2 != null) {
            vector.addAll(vector2);
        }
    }

    public JavaHashtable getImports() {
        return this.importedClasses;
    }

    public void setImports(JavaHashtable javaHashtable) {
        this.importedClasses = javaHashtable;
    }

    public JavaVector getDemand() {
        return this.demand;
    }

    public void setDemand(JavaVector javaVector) {
        this.demand = javaVector;
    }

    public static SymbolTable getSymbolTable() {
        if (singleton == null) {
            singleton = new SymbolTable();
        }
        return singleton;
    }

    public void setOutDirPath(String string) {
        this.outDirPath = string;
    }

    public String getOutDirPath() {
        return this.outDirPath;
    }

    void addDemand(PackageDef packageDef) {
        this.demand.addElement(packageDef);
    }

    public static void createDirs(File file) {
        String string = file.getParent();
        File file2 = new File(string);
        if (!file2.exists()) {
            file2.mkdirs();
        }
    }

    public static void addFileClassDef(File file, ClassDef classDef) {
        Vector<ClassDef> vector;
        if (_fileClassDefs == null) {
            _fileClassDefs = new Hashtable(2);
        }
        if ((vector = (Vector<ClassDef>)_fileClassDefs.get(file)) == null) {
            vector = new Vector<ClassDef>(2, 2);
            _fileClassDefs.put(file, vector);
        }
        vector.addElement(classDef);
    }

    public static String getClassList(File file) {
        if (_fileClassDefs == null) {
            return null;
        }
        Vector vector = (Vector)_fileClassDefs.get(file);
        if (vector == null) {
            return null;
        }
        String string = "";
        int n = 0;
        while (n < vector.size()) {
            Definition definition = (Definition)vector.elementAt(n);
            String string2 = definition.getName();
            string = string + string2;
            if (n < vector.size() - 1) {
                string = string + ", ";
            }
            ++n;
        }
        return string;
    }

    public void addImport(JavaToken javaToken, String string, String string2) {
        if (this.importedClasses == null) {
            this.importedClasses = new JavaHashtable();
        }
        if (string2.equals(".") || string2.equals("")) {
            this.importedClasses.put(this.getUniqueName("~default~"), this.getDefaultPackage());
            return;
        }
        string2 = string2.substring(1);
        if (string == null) {
            Definition definition = (Definition)this.packages.get(string2);
            if (definition == null) {
                definition = new PackageDef(this.getUniqueName(string2), new Occurrence(this.currentFile, javaToken.getLine(), javaToken.getColumn()), null);
                this.packages.put(string2, definition);
            }
            this.importedClasses.put(definition.getName(), definition);
        } else {
            this.importedClasses.put(this.getUniqueName(string), new DummyClass(this.getUniqueName(string), new Occurrence(this.currentFile, javaToken.getLine(), javaToken.getColumn()), this.getUniqueName(string2)));
        }
    }

    void addToCurrentScope(Definition definition) {
        this.getCurrentScope().add(definition);
        definition.setParentScope(this.getCurrentScope());
    }

    void closeImports() {
        this.demand = null;
        this.importedClasses = null;
    }

    public Definition defineBlock(JavaToken javaToken) {
        BlockDef blockDef = new BlockDef(null, this.getOccurrence(javaToken), this.getCurrentScope());
        this.addToCurrentScope(blockDef);
        return this.pushScope(blockDef);
    }

    public void defineClass(JavaToken javaToken, JavaToken javaToken2, JavaVector javaVector) {
        ClassDef classDef = new ClassDef(this.getUniqueName(javaToken), this.getOccurrence(javaToken), javaToken2 == null ? null : this.getDummyClass(javaToken2), javaVector, this.getCurrentScope());
        classDef.setType(0);
        classDef.setImports(this.importedClasses);
        this.addToCurrentScope(classDef);
        SymbolTable.addFileClassDef(this.currentFile, classDef);
        this.pushScope(classDef);
    }

    public void defineInterface(JavaToken javaToken, JavaVector javaVector) {
        ClassDef classDef = new ClassDef(this.getUniqueName(javaToken), this.getOccurrence(javaToken), null, javaVector, this.getCurrentScope());
        classDef.setType(1);
        this.addToCurrentScope(classDef);
        SymbolTable.addFileClassDef(this.currentFile, classDef);
        this.pushScope(classDef);
    }

    public void defineLabel(JavaToken javaToken) {
        this.addToCurrentScope(new LabelDef(this.getUniqueName(javaToken), this.getOccurrence(javaToken), this.getCurrentScope()));
    }

    public void defineComment(int n, int n2, String string) {
        int n3 = string.length();
        String string2 = this.getCurrentPackageName();
        HTMLTag hTMLTag = new HTMLTag(this.currentFile, n, n2, string2, n3);
        Vector<HTMLTag> vector = (Vector<HTMLTag>)_fileComments.get(this.currentFile);
        if (vector == null) {
            vector = new Vector<HTMLTag>();
            _fileComments.put(this.currentFile, vector);
        }
        vector.addElement(hTMLTag);
    }

    public void defineMethod(JavaToken javaToken, JavaToken javaToken2) {
        String string = null;
        if (javaToken2 == null) {
            String string2 = javaToken.getText();
            string = javaToken.getText();
            this.currentMethod = new MethodDef(this.getUniqueName(string2), string, this.getOccurrence(javaToken), this.getDummyClass(javaToken2), this.getCurrentScope());
        } else {
            if (javaToken == null) {
                javaToken = javaToken2;
                javaToken2 = null;
            }
            String string3 = javaToken.getText();
            this.currentMethod = new MethodDef(this.getUniqueName(string3), this.getOccurrence(javaToken), this.getDummyClass(javaToken2), this.getCurrentScope());
        }
        this.addToCurrentScope(this.currentMethod);
        this.pushScope(this.currentMethod);
    }

    public void definePackage(JavaToken javaToken) {
        this.definePackage(this.getUniqueName(javaToken));
    }

    PackageDef definePackage(String string) {
        PackageDef packageDef = this.lookupPackage(string);
        this.pushScope(packageDef);
        return packageDef;
    }

    public void defineVar(JavaToken javaToken, JavaToken javaToken2) {
        VariableDef variableDef = new VariableDef(this.getUniqueName(javaToken), this.getOccurrence(javaToken), this.getDummyClass(javaToken2), this.getCurrentScope());
        if (this.currentMethod != null) {
            this.currentMethod.add(variableDef);
        } else {
            this.addToCurrentScope(variableDef);
        }
    }

    public void endMethodHead(JavaVector javaVector) {
        this.currentMethod.setExceptions(javaVector);
        this.currentMethod = null;
    }

    Definition findInImports(String string, Class clazz) {
        PackageDef packageDef;
        Object object;
        Definition definition = null;
        if (this.importedClasses != null) {
            definition = (Definition)this.importedClasses.get(string);
        }
        if (definition instanceof DummyClass && (object = ((DummyClass)definition).getPackage()) != null) {
            packageDef = (PackageDef)this.packages.get(object);
            definition = packageDef.lookup(definition.getName(), clazz);
        }
        if (definition == null && this.demand != null && string.charAt(0) != '~') {
            object = this.demand.elements();
            while (definition == null && object.hasMoreElements()) {
                packageDef = (PackageDef)object.nextElement();
                definition = packageDef.lookup(string, clazz);
            }
        }
        return definition;
    }

    Definition findPackage(String string) {
        return (Definition)this.packages.get(string);
    }

    PackageDef lookupPackage(String string) {
        PackageDef packageDef = (PackageDef)this.packages.get(string);
        if (packageDef == null) {
            packageDef = new PackageDef(this.getUniqueName(string), null, null);
            this.packages.put(string, packageDef);
        }
        return packageDef;
    }

    ScopedDef getCurrentScope() {
        if (this.activeScopes.empty()) {
            return null;
        }
        return (ScopedDef)this.activeScopes.peek();
    }

    PackageDef getDefaultPackage() {
        if (this.defaultPackage == null) {
            this.defaultPackage = new PackageDef(this.getUniqueName("~default~"), null, null);
            this.packages.put(this.getUniqueName("~default~"), this.defaultPackage);
            this.defaultPackage.setDefaultOrBaseScope(true);
        }
        return this.defaultPackage;
    }

    public DummyClass getDummyClass(JavaToken javaToken) {
        if (javaToken == null) {
            return null;
        }
        return new DummyClass(this.getUniqueName(javaToken), this.getOccurrence(javaToken));
    }

    ClassDef getObject() {
        if (this.object == null) {
            this.object = new DummyClass();
            this.object.setType(0);
            this.javaLang.add(this.object);
        }
        return this.object;
    }

    Occurrence getOccurrence(JavaToken javaToken) {
        if (javaToken == null) {
            return new Occurrence(null, 0);
        }
        return new Occurrence(this.currentFile, javaToken.getLine(), javaToken.getColumn(), this.getCurrentPackageName(), this.getCurrentClassName(), this.getCurrentMethodName());
    }

    Definition getScope() {
        return this.qualifiedScope;
    }

    String getUniqueName(JavaToken javaToken) {
        return this.getUniqueName(javaToken.getText());
    }

    String getUniqueName(String string) {
        return this.names.getName(string);
    }

    Definition lookup(String string, Class clazz) {
        return this.lookup(string, -1, clazz);
    }

    Definition lookup(String string, int n, Class clazz) {
        String string2;
        Definition definition = null;
        StringTokenizer stringTokenizer = null;
        String string3 = null;
        boolean bl = false;
        if (string.indexOf(46) > 0) {
            string2 = null;
            stringTokenizer = new StringTokenizer(string, ".");
            if (bl) {
                System.out.println("SymbolTable.lookup " + string);
            }
            boolean bl2 = false;
            while (stringTokenizer.hasMoreElements()) {
                String string4 = (String)stringTokenizer.nextElement();
                PackageDef packageDef = null;
                if (string2 == null) {
                    string2 = string4;
                    if (bl) {
                        System.out.println("calling findInImports " + string2);
                    }
                    definition = this.findInImports(string2, clazz);
                    if (bl) {
                        System.out.println("findInImports returned " + definition);
                    }
                    if (definition != null) {
                        if (bl) {
                            System.out.println("Found in imports:" + definition.getName());
                        }
                        bl2 = true;
                        string4 = (String)stringTokenizer.nextElement();
                    }
                } else {
                    string2 = string2 + "." + string4;
                }
                packageDef = (PackageDef)this.packages.get(string2);
                if (bl) {
                    System.out.println("doneWithPackage=" + bl2 + " testIt=" + (packageDef == null ? "null" : packageDef.getName()) + " afterPackage=" + string3);
                }
                if (!bl2 && packageDef != null) {
                    definition = packageDef;
                    string3 = null;
                    continue;
                }
                string3 = string3 == null ? string4 : string3 + "." + string4;
            }
        } else if (n == -1) {
            definition = this.findInImports(string, clazz);
            if (bl) {
                System.out.print("lookup:findInImports returned " + definition);
                if (definition != null && definition.getParentScope() != null) {
                    System.out.println(" parentScope" + definition.getParentScope());
                } else {
                    System.out.println(" ");
                }
            }
            if (definition != null) {
                return definition;
            }
        }
        if (bl) {
            System.out.print("lookup:def=");
            if (definition == null) {
                System.out.println("null");
            } else {
                System.out.println(definition.getName());
            }
        }
        if (bl) {
            System.out.println("lookup:afterpackage=" + string3);
        }
        if (definition != null && string3 != null) {
            if (bl) {
                System.out.println("Setting scope=" + definition.getName());
            }
            this.setScope(definition);
        } else {
            if (bl) {
                System.out.println("afterPackage=" + string);
            }
            string3 = string;
        }
        if (string3 != null) {
            stringTokenizer = new StringTokenizer(string3, ".");
            while (stringTokenizer.hasMoreElements()) {
                string2 = (String)stringTokenizer.nextElement();
                if (this.qualifiedScope != null) {
                    if (bl) {
                        System.out.println("Checking qualified scope:" + this.qualifiedScope);
                    }
                    definition = this.qualifiedScope.lookup(string2, n, clazz);
                    this.resetScope();
                } else {
                    if (bl) {
                        System.out.println("Checking activeScopes for:" + string2);
                    }
                    if ((definition = this.activeScopes.lookup(string2, n, clazz)) == null) {
                        definition = this.activeScopes.lookup(string2, -1, clazz);
                    }
                }
                if (definition == null) {
                    if (!bl) break;
                    System.out.println(string2 + " Not found in activescopes");
                    break;
                }
                if (!stringTokenizer.hasMoreElements()) continue;
                this.setScope(definition);
            }
        }
        if (definition == null) {
            if (bl) {
                System.out.println("lookup returning null:" + string);
            }
        } else if (bl) {
            System.out.println("lookup returning:" + definition.getQualifiedName());
        }
        return definition;
    }

    ClassDef lookupDummy(Definition definition) {
        String string;
        String string2 = ((DummyClass)definition).getPackage();
        Definition definition2 = null;
        if (string2 == null) {
            string = definition.getName();
        } else {
            string = string2 + "." + definition.getName();
            if (this.packages.get(string2) == null) {
                this.packages.put(string2, new PackageDef(string2, null, null));
            }
        }
        definition2 = this.lookup(string, class$Ljavasrc$symtab$ClassDef != null ? class$Ljavasrc$symtab$ClassDef : (class$Ljavasrc$symtab$ClassDef = SymbolTable.class$("javasrc.symtab.ClassDef")));
        if (definition2 != null && !(definition2 instanceof ClassDef)) {
            new Exception("newD is a " + definition2).printStackTrace();
        }
        return (ClassDef)definition2;
    }

    void openImports(JavaHashtable javaHashtable) {
        this.demand = new JavaVector();
        this.demand.addElement(this.javaLang);
        this.importedClasses = new JavaHashtable();
        if (javaHashtable != null) {
            Enumeration enumeration = javaHashtable.elements();
            while (enumeration.hasMoreElements()) {
                ClassDef classDef;
                Definition definition = (Definition)enumeration.nextElement();
                if (definition instanceof PackageDef) {
                    this.addDemand((PackageDef)definition);
                    continue;
                }
                if (definition instanceof DummyClass && (classDef = this.lookupDummy(definition)) != null) {
                    definition = classDef;
                }
                this.importedClasses.put(definition.getName(), definition);
            }
        }
    }

    public void popAllScopes() {
        while (this.activeScopes.peek() != this.baseScope) {
            this.activeScopes.pop();
        }
        this.importedClasses = null;
    }

    public void popScope() {
        this.activeScopes.pop();
    }

    Definition pushScope(Definition definition) {
        if (!(definition instanceof ScopedDef)) {
            throw new RuntimeException("Not a ScopedDef");
        }
        this.activeScopes.push(definition);
        return definition;
    }

    String getCurrentPackageName() {
        String string = "";
        if (this.activeScopes == null) {
            return string;
        }
        Enumeration enumeration = this.activeScopes.elements();
        while (enumeration.hasMoreElements()) {
            ScopedDef scopedDef = (ScopedDef)enumeration.nextElement();
            if (!(scopedDef instanceof PackageDef)) continue;
            string = scopedDef.getName();
            break;
        }
        return string;
    }

    String getCurrentClassName() {
        String string = "?";
        if (this.activeScopes == null) {
            return string;
        }
        Enumeration enumeration = this.activeScopes.elements();
        while (enumeration.hasMoreElements()) {
            ScopedDef scopedDef = (ScopedDef)enumeration.nextElement();
            if (!(scopedDef instanceof ClassDef)) continue;
            string = scopedDef.getName();
            break;
        }
        return string;
    }

    String getCurrentMethodName() {
        String string = "?";
        if (this.activeScopes == null) {
            return string;
        }
        Enumeration enumeration = this.activeScopes.elements();
        while (enumeration.hasMoreElements()) {
            ScopedDef scopedDef = (ScopedDef)enumeration.nextElement();
            if (!(scopedDef instanceof MethodDef)) continue;
            string = scopedDef.getName();
            break;
        }
        return string;
    }

    public void reference(JavaToken javaToken) {
        javaToken.setFile(this.currentFile);
        javaToken.setPackageName(this.getCurrentPackageName());
        javaToken.setClassName(this.getCurrentClassName());
        javaToken.setMethodName(this.getCurrentMethodName());
        this.getCurrentScope().addUnresolved(javaToken);
    }

    public Hashtable generatePackageTags() {
        Hashtable<SortableString, Vector> hashtable = new Hashtable<SortableString, Vector>(2);
        Enumeration enumeration = this.packages.elements();
        while (enumeration.hasMoreElements()) {
            PackageDef packageDef = (PackageDef)enumeration.nextElement();
            Vector vector = packageDef.generateClassList();
            if (vector == null) continue;
            Vector vector2 = JSCollections.sortEnumeration(vector.elements());
            hashtable.put(new SortableString(packageDef.getScopedClassName()), vector2);
        }
        return hashtable;
    }

    void resetScope() {
        this.setScope((Definition)null);
    }

    public void resolveTypes() {
        if (this.defaultPackage != null) {
            this.defaultPackage.resolveTypes(this);
        }
        this.packages.resolveTypes(this);
    }

    public void resolveRefs() {
        if (this.defaultPackage != null) {
            this.defaultPackage.resolveRefs(this);
        }
        this.packages.resolveRefs(this);
    }

    public void persistRefs(String string) {
        ReferencePersistor referencePersistor = new ReferencePersistor(string);
        if (this.defaultPackage != null) {
            this.defaultPackage.accept(referencePersistor);
        }
        this.packages.accept(referencePersistor);
        referencePersistor.done();
    }

    public void setFile(File file) {
        this.currentFile = file;
    }

    public void setNearestClassScope() {
        this.setScope(this.activeScopes.findTopmostClass());
    }

    void setScope(JavaToken javaToken) {
        Definition definition = this.lookup(javaToken.getText(), null);
        if (definition != null) {
            definition.addReference(this.getOccurrence(javaToken));
            this.setScope(definition);
        }
    }

    void setScope(Definition definition) {
        while (definition != null && definition instanceof TypedDef) {
            definition = ((TypedDef)((Object)definition)).getType();
        }
        if (definition == null || definition instanceof ScopedDef) {
            this.qualifiedScope = definition;
        }
    }

    void setScope(String string) {
        Definition definition = this.lookup(string, null);
        if (definition != null) {
            this.setScope(definition);
        }
    }

    public String toString() {
        String string = "";
        Enumeration enumeration = this.packages.elements();
        while (enumeration.hasMoreElements()) {
            PackageDef packageDef = (PackageDef)enumeration.nextElement();
            string = string + packageDef.toString();
        }
        return string;
    }

    public void useDefaultPackage() {
        this.pushScope(this.getDefaultPackage());
    }

    public static void startReadExternal(String string) {
    }

    public static void endReadExternal() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private SymbolTable() {
        this.activeScopes = new JavaStack();
        this.javaLang = new PackageDef(this.getUniqueName("java.lang"), new Occurrence(null, 0), null);
        this.baseScope = new BlockDef(null, null, null);
        this.pushScope(this.baseScope);
        this.baseScope.setDefaultOrBaseScope(true);
        PrimitiveDef primitiveDef = new PrimitiveDef(this.getUniqueName("boolean"), this.getObject(), (ScopedDef)this.baseScope);
        PrimitiveDef primitiveDef2 = new PrimitiveDef(this.getUniqueName("double"), this.getObject(), (ScopedDef)this.baseScope);
        PrimitiveDef primitiveDef3 = new PrimitiveDef(this.getUniqueName("float"), primitiveDef2, (ScopedDef)this.baseScope);
        PrimitiveDef primitiveDef4 = new PrimitiveDef(this.getUniqueName("long"), primitiveDef3, (ScopedDef)this.baseScope);
        PrimitiveDef primitiveDef5 = new PrimitiveDef(this.getUniqueName("int"), primitiveDef4, (ScopedDef)this.baseScope);
        PrimitiveDef primitiveDef6 = new PrimitiveDef(this.getUniqueName("short"), primitiveDef5, (ScopedDef)this.baseScope);
        PrimitiveDef primitiveDef7 = new PrimitiveDef(this.getUniqueName("byte"), primitiveDef6, (ScopedDef)this.baseScope);
        PrimitiveDef primitiveDef8 = new PrimitiveDef(this.getUniqueName("char"), primitiveDef5, (ScopedDef)this.baseScope);
        PrimitiveDef primitiveDef9 = new PrimitiveDef(this.getUniqueName("void"), this.getObject(), (ScopedDef)this.baseScope);
        this.baseScope.add(primitiveDef);
        this.baseScope.add(primitiveDef2);
        this.baseScope.add(primitiveDef3);
        this.baseScope.add(primitiveDef4);
        this.baseScope.add(primitiveDef5);
        this.baseScope.add(primitiveDef6);
        this.baseScope.add(primitiveDef7);
        this.baseScope.add(primitiveDef8);
        this.baseScope.add(primitiveDef9);
    }

    static {
        _fileReferences = new Hashtable();
        _fileComments = new Hashtable();
        readLevel = 0;
    }
}

