/*
 * Decompiled with CFR 0.152.
 */
package com.centeredwork.xilize;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Files {
    private static final String ROOT_CONFIG = "root.xilconfig";
    private static final String DIR_CONFIG = "dir.xilconfig";
    private static final String USELESS_PATHEND = File.separator + ".";

    private Files() {
    }

    public static String normalizePath(String string) {
        return string.replace('\\', '/');
    }

    public static String trimDirPath(File file) {
        String string = file.getAbsolutePath();
        if (string.endsWith(USELESS_PATHEND)) {
            return string.substring(0, string.length() - USELESS_PATHEND.length());
        }
        return string;
    }

    public static File localFile(String string, String string2) {
        return Files.isAbsolute(string) ? new File(string) : new File(string2 + File.separator + string);
    }

    public static boolean isAbsolute(String string) {
        return string.matches("(([a-zA-Z]:)|(/|\\\\)).*");
    }

    public static boolean isSubDir(File file, File file2) {
        String string = file.getAbsolutePath();
        return file2.getAbsolutePath().regionMatches(0, string, 0, string.length());
    }

    public static File findRoot(File file) {
        File file2;
        if (file == null) {
            return null;
        }
        if (file.isDirectory() && (file2 = new File(file, ROOT_CONFIG)).exists()) {
            return file2.getParentFile();
        }
        return Files.findRoot(file.getParentFile());
    }

    public static File findTopDirConfig(File file) {
        File file2;
        if (file == null) {
            return null;
        }
        if (file.isDirectory() && (file2 = new File(file, DIR_CONFIG)).exists()) {
            File file3 = Files.findTopDirConfig(file.getParentFile());
            return file3 == null ? file2.getParentFile() : file3;
        }
        return Files.findTopDirConfig(file.getParentFile());
    }

    public static File getProjectRoot(File file) {
        if (file == null) {
            return null;
        }
        File file2 = Files.findRoot(file);
        if (file2 != null) {
            return file2;
        }
        return Files.findTopDirConfig(file);
    }

    public static String read(File file) throws IOException, FileNotFoundException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        StringBuilder stringBuilder = new StringBuilder((int)file.length());
        int n = -1;
        while ((n = ((Reader)bufferedReader).read()) != -1) {
            stringBuilder.append((char)n);
        }
        ((Reader)bufferedReader).close();
        return stringBuilder.toString();
    }

    public static String read(File file, int n) throws IOException, FileNotFoundException {
        int n2;
        int n3;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        StringBuilder stringBuilder = new StringBuilder((int)file.length());
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            if (n < 1) {
                stringBuilder.append(string);
                continue;
            }
            do {
                if (n > string.length()) {
                    stringBuilder.append(string);
                    stringBuilder.append('\n');
                    string = "";
                    continue;
                }
                n3 = string.lastIndexOf(32, n);
                if (n3 == -1) {
                    stringBuilder.append(string + '\n');
                    string = "";
                    continue;
                }
                stringBuilder.append(string.substring(0, n3));
                stringBuilder.append('\n');
                string = n3 < string.length() - 1 ? string.substring(n3 + 1) : "";
            } while (!string.equals(""));
        }
        bufferedReader.close();
        n3 = stringBuilder.length();
        while (--n3 > 0 && stringBuilder.charAt(n3) == '\n') {
        }
        for (n2 = 0; n2 < stringBuilder.length() && stringBuilder.charAt(n2) == '\n'; ++n2) {
        }
        return stringBuilder.toString().substring(n2, n3 + 1);
    }

    public static ArrayList<File> listFiles(File file, final String string) {
        Object[] objectArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return !file.isDirectory() && file.getName().matches(string);
            }
        });
        Arrays.sort(objectArray);
        return new ArrayList<Object>(Arrays.asList(objectArray));
    }

    public static ArrayList<File> listDirs(File file, final String string) {
        Object[] objectArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() && file.getName().matches(string);
            }
        });
        Arrays.sort(objectArray);
        return new ArrayList<Object>(Arrays.asList(objectArray));
    }
}

