/*
 * Decompiled with CFR 0.152.
 */
package com.centeredwork.xilize;

import com.centeredwork.xilize.Block;
import com.centeredwork.xilize.Modifiers;
import com.centeredwork.xilize.Signature;
import com.centeredwork.xilize.Task;
import java.util.ArrayList;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SigList
extends Signature {
    private Task task;
    private Stack<List> stack = new Stack();
    private static final String LIST_REGEX = " *((?:\\(((\\w|[#,-]|\\d)+)\\)|\\{([\\S &&[^}]]+)\\}|\\[([a-zA-Z0-9-]+)\\]|\\{\\{([\\S &&[^}]]+)\\}\\}|\\\\(\\d+)|/(\\d+)|_|-|\\^|~|>|<|=|\\(+|\\)+)*)([*#]+)((?:\\(((\\w|[#,-]|\\d)+)\\)|\\{([\\S &&[^}]]+)\\}|\\[([a-zA-Z0-9-]+)\\]|\\{\\{([\\S &&[^}]]+)\\}\\}|\\\\(\\d+)|/(\\d+)|_|-|\\^|~|>|<|=|\\(+|\\)+)* )? *(.*)?";
    private static final Pattern LIST_PATTERN = Pattern.compile(" *((?:\\(((\\w|[#,-]|\\d)+)\\)|\\{([\\S &&[^}]]+)\\}|\\[([a-zA-Z0-9-]+)\\]|\\{\\{([\\S &&[^}]]+)\\}\\}|\\\\(\\d+)|/(\\d+)|_|-|\\^|~|>|<|=|\\(+|\\)+)*)([*#]+)((?:\\(((\\w|[#,-]|\\d)+)\\)|\\{([\\S &&[^}]]+)\\}|\\[([a-zA-Z0-9-]+)\\]|\\{\\{([\\S &&[^}]]+)\\}\\}|\\\\(\\d+)|/(\\d+)|_|-|\\^|~|>|<|=|\\(+|\\)+)* )? *(.*)?");

    public SigList() {
        super("list");
    }

    public String translate(Task task, Block block) {
        this.task = task;
        block.setWriteChildren(false);
        List list = new List(0, '!', 0, null);
        this.stack.push(list);
        for (String string : block.getLines()) {
            int n = block.getLineNumber(string);
            Matcher matcher = LIST_PATTERN.matcher(string);
            if (!matcher.matches()) {
                task.error(n, "problem with list signature");
                continue;
            }
            Modifiers.Sig sig = new Modifiers.Sig(task, matcher.group(1));
            int n2 = matcher.group(9).length();
            char c = matcher.group(9).charAt(0);
            Modifiers.Sig sig2 = new Modifiers.Sig(task, matcher.group(10));
            String string2 = matcher.group(18);
            TextItem textItem = new TextItem(n, sig2, string2);
            if (this.stack.peek().level == n2) {
                this.stack.peek().add(textItem);
                continue;
            }
            if (this.stack.peek().level > n2) {
                do {
                    this.stack.pop();
                } while (this.stack.peek().level > n2);
                this.stack.peek().add(textItem);
                continue;
            }
            List list2 = this.stack.peek();
            for (int i = list2.level + 1; i < n2; ++i) {
                List list3 = new List(i, c, n, null);
                list2.add(list3);
                this.stack.push(list3);
                list2 = this.stack.peek();
            }
            List list4 = new List(n2, c, n, sig);
            list4.add(textItem);
            this.stack.peek().add(list4);
            this.stack.push(list4);
        }
        StringBuilder stringBuilder = new StringBuilder();
        list.firstSublist().write(0, stringBuilder);
        return stringBuilder.toString();
    }

    private static void indent(int n, StringBuilder stringBuilder) {
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("  ");
        }
    }

    private class List {
        int level;
        Modifiers mods;
        char type;
        int lineNum;
        ArrayList<Item> items = new ArrayList();

        List(int n, char c, int n2, Modifiers modifiers) {
            this.level = n;
            this.mods = modifiers;
            this.type = c;
            this.lineNum = n2;
        }

        void add(Item item) {
            this.items.add(item);
        }

        void add(List list) {
            if (this.items.size() <= 0) {
                this.add(new TextItem(this.lineNum));
            }
            this.items.get((int)(this.items.size() - 1)).sublist = list;
        }

        void write(int n, StringBuilder stringBuilder) {
            SigList.indent(n, stringBuilder);
            if (this.type == '#') {
                stringBuilder.append("<ol");
            } else {
                stringBuilder.append("<ul");
            }
            if (this.mods != null) {
                stringBuilder.append(this.mods.tagAttributes());
            }
            stringBuilder.append(">\n");
            for (Item item : this.items) {
                item.write(n + 1, stringBuilder);
            }
            SigList.indent(n, stringBuilder);
            if (this.type == '#') {
                stringBuilder.append("</ol>");
            } else {
                stringBuilder.append("</ul>");
            }
            stringBuilder.append('\n');
        }

        public String toString() {
            return this.type + "[" + this.level + ":" + this.lineNum + "]" + this.items.size();
        }

        List firstSublist() {
            return this.items.get((int)0).sublist;
        }
    }

    private class TextItem
    extends Item {
        String text;

        TextItem(int n) {
            super(n, null);
            this.text = "";
        }

        TextItem(int n, Modifiers modifiers, String string) {
            super(n, modifiers);
            this.text = SigList.this.task.markup(string);
        }

        void write(int n, StringBuilder stringBuilder) {
            SigList.indent(n, stringBuilder);
            stringBuilder.append("<li");
            if (this.mods != null) {
                stringBuilder.append(this.mods.tagAttributes());
            }
            stringBuilder.append(">" + this.text);
            if (this.sublist != null) {
                stringBuilder.append("\n");
                this.sublist.write(n + 1, stringBuilder);
                SigList.indent(n, stringBuilder);
            }
            stringBuilder.append("</li>\n");
        }

        public String toString() {
            return this.text;
        }
    }

    private abstract class Item {
        Modifiers mods;
        List sublist;
        int lineNum;

        Item(int n, Modifiers modifiers) {
            this.lineNum = n;
            this.mods = modifiers;
        }

        abstract void write(int var1, StringBuilder var2);
    }
}

