/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.javasource;

public class JavaSourceType {
    private String name;
    private int id;
    private boolean displayRelevant;
    public static final JavaSourceType UNDEFINED = new JavaSourceType("Undefined", false, 15);
    public static final JavaSourceType CODE = new JavaSourceType("Others", true, 10);
    public static final JavaSourceType KEYWORD = new JavaSourceType("Keywords", true, 4);
    public static final JavaSourceType CODE_TYPE = new JavaSourceType("Primitive Types", true, 9);
    public static final JavaSourceType STRING = new JavaSourceType("Strings", true, 5);
    public static final JavaSourceType COMMENT_LINE = new JavaSourceType("Single-line comments", true, 3);
    public static final JavaSourceType COMMENT_BLOCK = new JavaSourceType("Multi-line comments", true, 2);
    public static final JavaSourceType JAVADOC = new JavaSourceType("Javadoc others", true, 14);
    public static final JavaSourceType JAVADOC_KEYWORD = new JavaSourceType("Javadoc keywords", true, 11);
    public static final JavaSourceType BACKGROUND = new JavaSourceType("Background", false, 0);
    public static final JavaSourceType NUM_CONSTANT = new JavaSourceType("Numeric constants", true, 7);
    public static final JavaSourceType CHAR_CONSTANT = new JavaSourceType("Character constants", true, 6);
    public static final JavaSourceType PARENTHESIS = new JavaSourceType("Parenthesis", true, 8);
    public static final JavaSourceType JAVADOC_HTML_TAG = new JavaSourceType("Javadoc HTML tags", true, 12);
    public static final JavaSourceType JAVADOC_LINKS = new JavaSourceType("Javadoc links", true, 13);
    public static final JavaSourceType LINE_NUMBERS = new JavaSourceType("Line numbers", true, 1);
    private static final JavaSourceType[] ALL_TYPES = new JavaSourceType[]{BACKGROUND, LINE_NUMBERS, COMMENT_BLOCK, COMMENT_LINE, KEYWORD, STRING, CHAR_CONSTANT, NUM_CONSTANT, PARENTHESIS, CODE_TYPE, CODE, JAVADOC_KEYWORD, JAVADOC_HTML_TAG, JAVADOC_LINKS, JAVADOC, UNDEFINED};

    private JavaSourceType(String name, boolean displayRelevant, int id) {
        this.id = id;
        this.name = name;
        this.displayRelevant = displayRelevant;
    }

    public static JavaSourceType[] getAll() {
        return ALL_TYPES;
    }

    public String getName() {
        return this.toString();
    }

    public int getID() {
        return this.id;
    }

    public String toString() {
        return this.name;
    }

    public boolean isDisplayRelevant() {
        return this.displayRelevant;
    }
}

