/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.launcher;

import com.samskivert.swing.util.SwingUtil;
import com.threerings.getdown.Log;
import com.threerings.getdown.data.Application;
import com.threerings.getdown.data.Build;
import com.threerings.getdown.data.EnvConfig;
import com.threerings.getdown.data.Resource;
import com.threerings.getdown.data.SysProps;
import com.threerings.getdown.launcher.AbortPanel;
import com.threerings.getdown.launcher.MultipleGetdownRunning;
import com.threerings.getdown.launcher.ProxyPanel;
import com.threerings.getdown.launcher.ProxyUtil;
import com.threerings.getdown.launcher.RotatingBackgrounds;
import com.threerings.getdown.launcher.StatusPanel;
import com.threerings.getdown.net.Downloader;
import com.threerings.getdown.tools.Patcher;
import com.threerings.getdown.util.Config;
import com.threerings.getdown.util.FileUtil;
import com.threerings.getdown.util.LaunchUtil;
import com.threerings.getdown.util.MessageUtil;
import com.threerings.getdown.util.ProgressAggregator;
import com.threerings.getdown.util.ProgressObserver;
import com.threerings.getdown.util.StringUtil;
import com.threerings.getdown.util.VersionUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLayeredPane;

public abstract class Getdown
implements Application.StatusDisplay,
RotatingBackgrounds.ImageLoader {
    protected ProgressObserver _progobs = new ProgressObserver(){

        public void progress(int percent) {
            Getdown.this.setStatusAsync(null, Getdown.this.stepToGlobalPercent(percent), -1L, false);
        }
    };
    protected Application _app;
    protected Application.UpdateInterface _ifc = new Application.UpdateInterface(Config.EMPTY);
    protected ResourceBundle _msgs;
    protected Container _container;
    protected JLayeredPane _layers;
    protected StatusPanel _status;
    protected JButton _patchNotes;
    protected AbortPanel _abort;
    protected RotatingBackgrounds _background;
    protected boolean _dead;
    protected boolean _silent;
    protected boolean _launchInSilent;
    protected boolean _noUpdate;
    protected long _startup;
    protected Set<Resource> _toInstallResources;
    protected boolean _readyToInstall;
    protected boolean _enableTracking = true;
    protected int _reportedProgress = 0;
    protected int _delay;
    protected int _stepMaxPercent;
    protected int _stepMinPercent;
    protected int _lastGlobalPercent;
    protected int _uiDisplayPercent;
    protected static final int MAX_LOOPS = 5;
    protected static final long FALLBACK_CHECK_TIME = 1000L;

    public static void run(final Getdown getdown) {
        new Thread("Getdown"){

            @Override
            public void run() {
                getdown.run();
            }
        }.start();
    }

    public Getdown(EnvConfig envc) {
        try {
            this._silent = SysProps.silent();
            if (this._silent) {
                this._launchInSilent = SysProps.launchInSilent();
                this._noUpdate = SysProps.noUpdate();
            }
            if (!this._silent && GraphicsEnvironment.isHeadless()) {
                Log.log.info((Object)"Running in headless JVM, will attempt to operate without UI.", new Object[0]);
                this._silent = true;
                this._launchInSilent = true;
            }
            this._delay = SysProps.startDelay();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            this._msgs = ResourceBundle.getBundle("com.threerings.getdown.messages");
        }
        catch (Exception e) {
            String dir = envc.appDir.toString();
            if (".".equals(dir)) {
                dir = System.getProperty("user.dir");
            }
            String errmsg = "The directory in which this application is installed:\n" + dir + "\nis invalid (" + e.getMessage() + "). If the full path to the app directory contains the '!' character, this will trigger this error.";
            this.fail(errmsg);
        }
        this._app = new Application(envc);
        this._startup = System.currentTimeMillis();
    }

    public boolean isUpdateAvailable() {
        return this._readyToInstall && !this._toInstallResources.isEmpty();
    }

    public void install() throws IOException {
        if (SysProps.noInstall()) {
            Log.log.info((Object)"Skipping install due to 'no_install' sysprop.", new Object[0]);
        } else if (this.isUpdateAvailable()) {
            Log.log.info((Object)("Installing " + this._toInstallResources.size() + " downloaded resources:"), new Object[0]);
            for (Resource resource : this._toInstallResources) {
                resource.install(true);
            }
            this._toInstallResources.clear();
            this._readyToInstall = false;
            Log.log.info((Object)"Install completed.", new Object[0]);
        } else {
            Log.log.info((Object)"Nothing to install.", new Object[0]);
        }
    }

    public void configProxy(String host, String port, String username, String password) {
        Log.log.info((Object)"User configured proxy", new Object[]{"host", host, "port", port});
        ProxyUtil.configProxy(this._app, host, port, username, password);
        this.disposeContainer();
        this._container = null;
        Getdown.run(this);
    }

    protected void run() {
        if (this._msgs == null) {
            return;
        }
        Log.log.info((Object)"Getdown starting", new Object[]{"version", Build.version(), "built", Build.time()});
        File instdir = this._app.getLocalPath("");
        if (!instdir.canWrite()) {
            String path = instdir.getPath();
            if (".".equals(path)) {
                path = System.getProperty("user.dir");
            }
            this.fail(MessageUtil.tcompose((String)"m.readonly_error", (String[])new String[]{path}));
            return;
        }
        this._dead = false;
        if (this.detectProxy() || this._app.allowOffline()) {
            this.getdown();
        } else {
            this.requestProxyInfo(false);
        }
    }

    protected boolean detectProxy() {
        Log.log.info((Object)"Checking whether we need to use a proxy...", new Object[0]);
        try {
            this.readConfig(true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        boolean tryNoProxy = SysProps.tryNoProxyFirst();
        if (!tryNoProxy && ProxyUtil.autoDetectProxy(this._app)) {
            return true;
        }
        this.updateStatus("m.detecting_proxy");
        URL configURL = this._app.getConfigResource().getRemote();
        if (!ProxyUtil.canLoadWithoutProxy(configURL, tryNoProxy ? 2 : 5)) {
            return tryNoProxy ? ProxyUtil.autoDetectProxy(this._app) : false;
        }
        Log.log.info((Object)"No proxy appears to be needed.", new Object[0]);
        if (!tryNoProxy) {
            ProxyUtil.saveProxy(this._app, null, null);
        }
        return true;
    }

    protected void readConfig(boolean preloads) throws IOException {
        Config config = this._app.init(true);
        if (preloads) {
            this.doPredownloads(this._app.getResources());
        }
        this._ifc = new Application.UpdateInterface(config);
    }

    protected void requestProxyInfo(boolean reinitAuth) {
        if (this._silent) {
            Log.log.warning((Object)"Need a proxy, but we don't want to bother anyone. Exiting.", new Object[0]);
            return;
        }
        this._container = this.createContainer();
        this._dead = true;
        this.configureContainer();
        ProxyPanel panel = new ProxyPanel(this, this._msgs, reinitAuth);
        String[] hostPort = ProxyUtil.loadProxy(this._app);
        panel.setProxy(hostPort[0], hostPort[1]);
        this._container.add((Component)panel, "Center");
        this.showContainer();
    }

    protected void doPredownloads(Collection<Resource> resources) {
        ArrayList<Resource> predownloads = new ArrayList<Resource>();
        for (Resource rsrc : resources) {
            if (!rsrc.shouldPredownload() || rsrc.getLocal().exists()) continue;
            predownloads.add(rsrc);
        }
        if (!predownloads.isEmpty()) {
            try {
                this.download(predownloads);
                for (Resource rsrc : predownloads) {
                    rsrc.install(false);
                }
            }
            catch (IOException ioe) {
                Log.log.warning((Object)"Failed to predownload resources. Continuing...", new Object[]{ioe});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getdown() {
        try {
            try {
                this.readConfig(true);
            }
            catch (IOException ioe) {
                Log.log.warning((Object)("Failed to initialize: " + ioe), new Object[0]);
                this._app.attemptRecovery((Application.StatusDisplay)this);
                this.readConfig(true);
                this.createInterfaceAsync(true);
            }
            if (!this._noUpdate && !this._app.lockForUpdates()) {
                throw new MultipleGetdownRunning();
            }
            File config = this._app.getLocalPath("getdown.txt");
            if (!config.setLastModified(System.currentTimeMillis())) {
                Log.log.warning((Object)"Unable to set modtime on config file, will be unable to check for another instance of getdown running while this one waits.", new Object[0]);
            }
            if (this._delay > 0) {
                this._app.releaseLock();
                long lastConfigModtime = config.lastModified();
                Log.log.info((Object)("Waiting " + this._delay + " minutes before beginning actual work."), new Object[0]);
                TimeUnit.MINUTES.sleep(this._delay);
                if (lastConfigModtime < config.lastModified()) {
                    Log.log.warning((Object)"getdown.txt was modified while getdown was waiting.", new Object[0]);
                    throw new MultipleGetdownRunning();
                }
            }
            if (this._noUpdate) {
                Log.log.info((Object)"Launching without update!", new Object[0]);
                this.launch();
                return;
            }
            int[] alreadyValid = new int[1];
            HashSet unpacked = new HashSet();
            this._toInstallResources = new HashSet<Resource>();
            this._readyToInstall = false;
            for (int ii = 0; ii < 5; ++ii) {
                this.setStep(Application.UpdateInterface.Step.VERIFY_METADATA);
                this.setStatusAsync("m.validating", -1, -1L, false);
                if (this._app.verifyMetadata((Application.StatusDisplay)this)) {
                    Log.log.info((Object)"Application requires update.", new Object[0]);
                    this.update();
                    List cleanupPatterns = this._app.cleanupPatterns();
                    if (cleanupPatterns.isEmpty()) continue;
                    this.cleanupResources(cleanupPatterns);
                    continue;
                }
                this.setStep(Application.UpdateInterface.Step.VERIFY_RESOURCES);
                this.setStatusAsync("m.validating", -1, -1L, false);
                HashSet<Resource> toDownload = new HashSet<Resource>();
                this._app.verifyResources(this._progobs, alreadyValid, unpacked, this._toInstallResources, toDownload);
                if (toDownload.size() > 0) {
                    this._toInstallResources.addAll(toDownload);
                    try {
                        this._enableTracking = alreadyValid[0] == 0;
                        this.reportTrackingEvent("app_start", -1);
                        Log.log.info((Object)(toDownload.size() + " of " + this._app.getAllActiveResources().size() + " rsrcs require update (" + alreadyValid[0] + " assumed valid)."), new Object[0]);
                        this.setStep(Application.UpdateInterface.Step.REDOWNLOAD_RESOURCES);
                        this.download(toDownload);
                        this.reportTrackingEvent("app_complete", -1);
                        continue;
                    }
                    finally {
                        this._enableTracking = false;
                    }
                }
                if (!this._app.haveValidJavaVersion()) {
                    Log.log.info((Object)"Attempting to update Java VM...", new Object[0]);
                    this.setStep(Application.UpdateInterface.Step.UPDATE_JAVA);
                    this._enableTracking = true;
                    try {
                        this.updateJava();
                        continue;
                    }
                    finally {
                        this._enableTracking = false;
                    }
                }
                if (Boolean.getBoolean("check_unpacked")) {
                    File ufile = this._app.getLocalPath("unpacked.dat");
                    long version = -1L;
                    long aversion = this._app.getVersion();
                    if (!ufile.exists()) {
                        ufile.createNewFile();
                    } else {
                        version = VersionUtil.readVersion((File)ufile);
                    }
                    if (version < aversion) {
                        Log.log.info((Object)"Performing unpack", new Object[]{"version", version, "aversion", aversion});
                        this.setStep(Application.UpdateInterface.Step.UNPACK);
                        this.updateStatus("m.validating");
                        this._app.unpackResources(this._progobs, unpacked);
                        try {
                            VersionUtil.writeVersion((File)ufile, (long)aversion);
                        }
                        catch (IOException ioe) {
                            Log.log.warning((Object)"Failed to update unpacked version", new Object[]{ioe});
                        }
                    }
                }
                this._readyToInstall = true;
                this.install();
                if (!this._silent || this._launchInSilent) {
                    this._app.lockForUpdates();
                    this.launch();
                }
                return;
            }
            Log.log.warning((Object)"Pants! We couldn't get the job done.", new Object[0]);
            throw new IOException("m.unable_to_repair");
        }
        catch (Exception e) {
            switch (this._app.conn.state) {
                case NEED_PROXY: {
                    this.requestProxyInfo(false);
                    break;
                }
                case NEED_PROXY_AUTH: {
                    this.requestProxyInfo(true);
                    break;
                }
                default: {
                    Log.log.warning((Object)"getdown() failed.", new Object[]{e});
                    this.fail(e);
                    this._app.releaseLock();
                }
            }
            return;
        }
    }

    public void updateStatus(String message) {
        this.setStatusAsync(message, -1, -1L, true);
    }

    @Override
    public BufferedImage loadImage(String path) {
        if (StringUtil.isBlank((String)path)) {
            return null;
        }
        File imgpath = null;
        try {
            String localeStr = Locale.getDefault().getLanguage();
            imgpath = this._app.getLocalPath(path.replace(".", "_" + localeStr + "."));
            return ImageIO.read(imgpath);
        }
        catch (IOException localeStr) {
            try {
                imgpath = this._app.getLocalPath(path);
                return ImageIO.read(imgpath);
            }
            catch (IOException ioe2) {
                Log.log.warning((Object)"Failed to load image", new Object[]{"path", imgpath, "error", ioe2});
                return null;
            }
        }
    }

    protected void updateJava() throws IOException {
        Resource vmjar = this._app.getJavaVMResource();
        if (vmjar == null) {
            throw new IOException("m.java_download_failed");
        }
        File javaLocalDir = this._app.getJavaLocalDir();
        File javaDll = new File(javaLocalDir, "bin" + File.separator + "java.dll");
        if (javaDll.exists() && !javaDll.renameTo(javaDll)) {
            Log.log.info((Object)"Cannot update local Java VM as it is in use.", new Object[0]);
            return;
        }
        this.reportTrackingEvent("jvm_start", -1);
        this.updateStatus("m.downloading_java");
        ArrayList<Resource> list = new ArrayList<Resource>();
        list.add(vmjar);
        this.download(list);
        this.reportTrackingEvent("jvm_unpack", -1);
        this.updateStatus("m.unpacking_java");
        try {
            vmjar.install(true);
        }
        catch (IOException ioe) {
            throw new IOException("m.java_unpack_failed", ioe);
        }
        FileUtil.makeExecutable((File)new File(javaLocalDir, "bin/java"));
        FileUtil.makeExecutable((File)new File(javaLocalDir, "lib/jspawnhelper"));
        FileUtil.makeExecutable((File)new File(javaLocalDir, "lib/amd64/jspawnhelper"));
        String vmpath = LaunchUtil.getJVMBinaryPath((File)javaLocalDir, (boolean)false);
        String[] command = new String[]{vmpath, "-Xshare:dump"};
        try {
            Log.log.info((Object)("Regenerating classes.jsa for " + vmpath + "..."), new Object[0]);
            Runtime.getRuntime().exec(command);
        }
        catch (Exception e) {
            Log.log.warning((Object)"Failed to regenerate .jsa dump file", new Object[]{"error", e});
        }
        this.reportTrackingEvent("jvm_complete", -1);
    }

    protected void update() throws IOException {
        this._app.clearValidationMarkers();
        Resource patch = this._app.getPatchResource(null);
        if (patch != null) {
            ArrayList<Resource> list = new ArrayList<Resource>();
            list.add(patch);
            for (Application.AuxGroup aux : this._app.getAuxGroups()) {
                if (!this._app.isAuxGroupActive(aux.name) || (patch = this._app.getPatchResource(aux.name)) == null) continue;
                list.add(patch);
            }
            if (!StringUtil.isBlank((String)this._ifc.patchNotesUrl)) {
                this.createInterfaceAsync(false);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Getdown.this._patchNotes.setVisible(true);
                    }
                });
            }
            this.setStep(Application.UpdateInterface.Step.DOWNLOAD);
            this.download(list);
            this.setStep(Application.UpdateInterface.Step.PATCH);
            this.updateStatus("m.patching");
            long[] sizes = new long[list.size()];
            Arrays.fill(sizes, 1L);
            ProgressAggregator pragg = new ProgressAggregator(this._progobs, sizes);
            int ii = 0;
            for (Resource prsrc : list) {
                ProgressObserver pobs = pragg.startElement(ii++);
                try {
                    if (!prsrc.getLocalNew().exists()) continue;
                    prsrc.install(false);
                    Patcher patcher = new Patcher();
                    patcher.patch(prsrc.getLocal().getParentFile(), prsrc.getLocal(), pobs);
                }
                catch (Exception e) {
                    Log.log.warning((Object)"Failed to apply patch", new Object[]{"prsrc", prsrc, e});
                }
                if (FileUtil.deleteHarder((File)prsrc.getLocal())) continue;
                Log.log.warning((Object)("Failed to delete '" + prsrc + "'."), new Object[0]);
            }
        }
        this._app.updateMetadata();
        this.readConfig(false);
    }

    protected void download(Collection<Resource> resources) throws IOException {
        this.createInterfaceAsync(false);
        Downloader dl = new Downloader(this._app.conn){
            protected int _lastCheck;
            {
                this._lastCheck = -1;
            }

            protected void resolvingDownloads() {
                Getdown.this.updateStatus("m.resolving");
            }

            protected void downloadProgress(int percent, long remaining) {
                if (this._lastCheck == -1 || percent >= this._lastCheck + 10) {
                    if (Getdown.this._delay > 0) {
                        boolean locked = Getdown.this._app.lockForUpdates();
                        Getdown.this._app.releaseLock();
                        if (locked) {
                            this.abort();
                        }
                    }
                    this._lastCheck = percent;
                }
                Getdown.this.setStatusAsync("m.downloading", Getdown.this.stepToGlobalPercent(percent), remaining, true);
                if (percent > 0) {
                    Getdown.this.reportTrackingEvent("progress", percent);
                }
            }

            protected void downloadFailed(Resource rsrc, Exception e) {
                Getdown.this.updateStatus(MessageUtil.tcompose((String)"m.failure", (String[])new String[]{e.getMessage()}));
                Log.log.warning((Object)"Download failed", new Object[]{"rsrc", rsrc, e});
            }

            protected void resourceMissing(Resource rsrc) {
                Log.log.warning((Object)"Resource missing (got 404)", new Object[]{"rsrc", rsrc});
            }
        };
        if (!dl.download(resources, this._app.maxConcurrentDownloads())) {
            throw new MultipleGetdownRunning();
        }
    }

    void cleanupResources(List<String> cleanupPatterns) {
        String applicationPath = this._app.getAppDir().getAbsolutePath();
        HashSet filesFromGlob = new HashSet();
        for (String string : cleanupPatterns) {
            filesFromGlob.addAll(FileUtil.getFilePathsByGlob((String)applicationPath, (String)string));
        }
        HashSet<Path> rsrcs = new HashSet<Path>();
        for (Resource resource : this._app.getAllActiveResources()) {
            rsrcs.add(resource.getLocal().toPath().toAbsolutePath());
        }
        HashSet<Path> hashSet = new HashSet<Path>();
        for (Path path : filesFromGlob) {
            if (rsrcs.contains(path)) continue;
            hashSet.add(path);
        }
        if (!hashSet.isEmpty()) {
            for (Path path : hashSet) {
                path.toFile().delete();
            }
        }
    }

    protected void launch() {
        this.setStep(Application.UpdateInterface.Step.LAUNCH);
        this.setStatusAsync("m.launching", this.stepToGlobalPercent(100), -1L, false);
        try {
            if (this.invokeDirect()) {
                this.disposeContainer();
                this._app.releaseLock();
                this._app.invokeDirect();
            } else {
                Process proc;
                if (this._app.hasOptimumJvmArgs()) {
                    proc = this._app.createProcess(true);
                    long fallback = System.currentTimeMillis() + 1000L;
                    boolean error = false;
                    while (fallback > System.currentTimeMillis()) {
                        try {
                            error = proc.exitValue() != 0;
                            break;
                        }
                        catch (IllegalThreadStateException e) {
                            Thread.yield();
                        }
                    }
                    if (error) {
                        Log.log.info((Object)"Failed to launch with optimum arguments; falling back.", new Object[0]);
                        proc = this._app.createProcess(false);
                    }
                } else {
                    proc = this._app.createProcess(false);
                }
                proc.getInputStream().close();
                proc.getOutputStream().close();
                final InputStream stderr = proc.getErrorStream();
                if (LaunchUtil.mustMonitorChildren()) {
                    this.disposeContainer();
                    this._container = null;
                    Getdown.copyStream(stderr, System.err);
                    Log.log.info((Object)("Process exited: " + proc.waitFor()), new Object[0]);
                } else {
                    Thread t = new Thread(){

                        @Override
                        public void run() {
                            Getdown.copyStream(stderr, System.err);
                        }
                    };
                    t.setDaemon(true);
                    t.start();
                }
            }
            long uptime = System.currentTimeMillis() - this._startup;
            long minshow = (long)this._ifc.minShowSeconds * 1000L;
            if (this._container != null && uptime < minshow) {
                try {
                    TimeUnit.MILLISECONDS.sleep(minshow - uptime);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.setStatusAsync(null, 100, -1L, false);
            this.exit(0);
        }
        catch (Exception e) {
            Log.log.warning((Object)"launch() failed.", new Object[]{e});
        }
    }

    protected void createInterfaceAsync(final boolean reinit) {
        if (this._silent || this._container != null && !reinit) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (Getdown.this._container == null || reinit) {
                    if (Getdown.this._container == null) {
                        Getdown.this._container = Getdown.this.createContainer();
                    } else {
                        Getdown.this._container.removeAll();
                    }
                    Getdown.this.configureContainer();
                    Getdown.this._layers = new JLayeredPane();
                    Getdown.this._container.add((Component)Getdown.this._layers, "Center");
                    Getdown.this._patchNotes = new JButton(new AbstractAction(Getdown.this._msgs.getString("m.patch_notes")){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                            Getdown.this.showDocument(Getdown.this._ifc.patchNotesUrl);
                        }
                    });
                    Getdown.this._patchNotes.setFont(StatusPanel.FONT);
                    Getdown.this._layers.add(Getdown.this._patchNotes);
                    Getdown.this._status = new StatusPanel(Getdown.this._msgs);
                    Getdown.this._layers.add(Getdown.this._status);
                    Getdown.this.initInterface();
                }
                Getdown.this.showContainer();
            }
        });
    }

    protected void initInterface() {
        RotatingBackgrounds newBackgrounds = this.getBackground();
        if (this._background == null || newBackgrounds.getNumImages() > 0) {
            this._background = newBackgrounds;
        }
        this._status.init(this._ifc, this._background, this.getProgressImage());
        Dimension size = this._status.getPreferredSize();
        this._status.setSize(size);
        this._layers.setPreferredSize(size);
        this._patchNotes.setBounds(this._ifc.patchNotes.x, this._ifc.patchNotes.y, this._ifc.patchNotes.width, this._ifc.patchNotes.height);
        this._patchNotes.setVisible(false);
        this._uiDisplayPercent = this._lastGlobalPercent;
        this._lastGlobalPercent = 0;
        this._stepMinPercent = 0;
    }

    protected RotatingBackgrounds getBackground() {
        if (this._ifc.rotatingBackgrounds != null) {
            if (this._ifc.backgroundImage != null) {
                Log.log.warning((Object)"ui.background_image and ui.rotating_background were both specified. The rotating images are being used.", new Object[0]);
            }
            return new RotatingBackgrounds(this._ifc.rotatingBackgrounds, this._ifc.errorBackground, this);
        }
        if (this._ifc.backgroundImage != null) {
            return new RotatingBackgrounds(this.loadImage(this._ifc.backgroundImage));
        }
        return new RotatingBackgrounds();
    }

    protected Image getProgressImage() {
        return this.loadImage(this._ifc.progressImage);
    }

    protected void handleWindowClose() {
        if (this._dead) {
            this.exit(0);
        } else {
            if (this._abort == null) {
                this._abort = new AbortPanel(this, this._msgs);
            }
            this._abort.pack();
            SwingUtil.centerWindow((Window)this._abort);
            this._abort.setVisible(true);
            this._abort.setState(0);
            this._abort.requestFocus();
        }
    }

    private void fail(Exception e) {
        String msg = e.getMessage();
        if (msg == null) {
            msg = MessageUtil.compose((String)"m.unknown_error", (String[])new String[]{this._ifc.installError});
        } else if (!msg.startsWith("m.")) {
            msg = MessageUtil.taint((Object)msg);
            msg = e instanceof FileNotFoundException ? MessageUtil.compose((String)"m.missing_resource", (String[])new String[]{msg, this._ifc.installError}) : MessageUtil.compose((String)"m.init_error", (String[])new String[]{msg, this._ifc.installError});
        }
        this.fail(msg);
    }

    protected void fail(String message) {
        this._dead = true;
        this.setStatusAsync(message, this.stepToGlobalPercent(0), -1L, true);
    }

    protected void setStep(Application.UpdateInterface.Step step) {
        int finalPercent = -1;
        for (Integer perc : (List)this._ifc.stepPercentages.get(step)) {
            if (perc <= this._stepMaxPercent) continue;
            finalPercent = perc;
            break;
        }
        if (finalPercent == -1) {
            return;
        }
        this._stepMaxPercent = finalPercent;
        this._stepMinPercent = this._lastGlobalPercent;
    }

    protected int stepToGlobalPercent(int percent) {
        int adjustedMaxPercent = (this._stepMaxPercent - this._uiDisplayPercent) * 100 / (100 - this._uiDisplayPercent);
        this._lastGlobalPercent = Math.max(this._lastGlobalPercent, this._stepMinPercent + percent * (adjustedMaxPercent - this._stepMinPercent) / 100);
        return this._lastGlobalPercent;
    }

    protected void setStatusAsync(final String message, final int percent, final long remaining, boolean createUI) {
        if (this._status == null && createUI) {
            this.createInterfaceAsync(false);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (Getdown.this._status == null) {
                    if (message != null) {
                        Log.log.info((Object)("Dropping status '" + message + "'."), new Object[0]);
                    }
                    return;
                }
                if (message != null) {
                    Getdown.this._status.setStatus(message, Getdown.this._dead);
                }
                if (Getdown.this._dead) {
                    Getdown.this._status.setProgress(0, -1L);
                } else if (percent >= 0) {
                    Getdown.this._status.setProgress(percent, remaining);
                }
            }
        });
    }

    protected void reportTrackingEvent(String event, int progress) {
        if (!this._enableTracking) {
            return;
        }
        if (progress > 0) {
            do {
                URL url;
                if ((url = this._app.getTrackingProgressURL(++this._reportedProgress)) == null) continue;
                this.reportProgress(url);
            } while (this._reportedProgress <= progress);
        } else {
            URL url = this._app.getTrackingURL(event);
            if (url != null) {
                this.reportProgress(url);
            }
        }
    }

    protected abstract Container createContainer();

    protected abstract void configureContainer();

    protected abstract void showContainer();

    protected abstract void disposeContainer();

    protected boolean invokeDirect() {
        return SysProps.direct();
    }

    protected abstract void showDocument(String var1);

    protected abstract void exit(int var1);

    protected static void copyStream(InputStream in, PrintStream out) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            while ((line = reader.readLine()) != null) {
                out.print(line);
                out.flush();
            }
        }
        catch (IOException ioe) {
            Log.log.warning((Object)"Failure copying", new Object[]{"in", in, "out", out, "error", ioe});
        }
    }

    protected void reportProgress(final URL url) {
        Thread reporter = new Thread("Progress reporter"){

            @Override
            public void run() {
                try {
                    String val;
                    HttpURLConnection ucon = Getdown.this._app.conn.openHttp(url, 0, 0);
                    if (Getdown.this._app.getTrackingCookieName() != null && Getdown.this._app.getTrackingCookieProperty() != null && (val = System.getProperty(Getdown.this._app.getTrackingCookieProperty())) != null) {
                        ucon.setRequestProperty("Cookie", Getdown.this._app.getTrackingCookieName() + "=" + val);
                    }
                    ucon.connect();
                    try {
                        if (ucon.getResponseCode() != 200) {
                            Log.log.warning((Object)"Failed to report tracking event", new Object[]{"url", url, "rcode", ucon.getResponseCode()});
                        }
                    }
                    finally {
                        ucon.disconnect();
                    }
                }
                catch (IOException ioe) {
                    Log.log.warning((Object)"Failed to report tracking event", new Object[]{"url", url, "error", ioe});
                }
            }
        };
        reporter.setDaemon(true);
        reporter.start();
    }
}

