/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.launcher;

import com.samskivert.swing.util.SwingUtil;
import com.threerings.getdown.Log;
import com.threerings.getdown.data.EnvConfig;
import com.threerings.getdown.data.SysProps;
import com.threerings.getdown.launcher.Getdown;
import com.threerings.getdown.util.LaunchUtil;
import com.threerings.getdown.util.StringUtil;
import java.awt.Color;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.KeyStroke;

public class GetdownApp {
    public static void main(String[] argv) {
        try {
            GetdownApp.start(argv);
        }
        catch (Exception e) {
            Log.log.warning((Object)"main() failed.", new Object[]{e});
        }
    }

    public static Getdown start(String[] argv) throws Exception {
        ArrayList notes = new ArrayList();
        EnvConfig envc = EnvConfig.create((String[])argv, notes);
        if (envc == null) {
            if (!notes.isEmpty()) {
                for (EnvConfig.Note n : notes) {
                    System.err.println(n.message);
                }
            } else {
                System.err.println("Usage: java -jar getdown.jar [app_dir] [app_id] [app args]");
            }
            System.exit(-1);
        }
        if (!SysProps.noLogRedir() && !SysProps.debug()) {
            File logFile = new File(envc.appDir, "launcher.log");
            try {
                PrintStream logOut = new PrintStream(new BufferedOutputStream(new FileOutputStream(logFile)), true);
                System.setOut(logOut);
                System.setErr(logOut);
            }
            catch (IOException ioe) {
                Log.log.warning((Object)("Unable to redirect output to '" + logFile + "': " + ioe), new Object[0]);
            }
        }
        boolean abort = false;
        for (EnvConfig.Note note : notes) {
            switch (note.level) {
                case INFO: {
                    Log.log.info((Object)note.message, new Object[0]);
                    break;
                }
                case WARN: {
                    Log.log.warning((Object)note.message, new Object[0]);
                    break;
                }
                case ERROR: {
                    Log.log.error((Object)note.message, new Object[0]);
                    abort = true;
                }
            }
        }
        if (abort) {
            System.exit(-1);
        }
        Log.log.info((Object)"------------------ VM Info ------------------", new Object[0]);
        Log.log.info((Object)("-- OS Name: " + System.getProperty("os.name")), new Object[0]);
        Log.log.info((Object)("-- OS Arch: " + System.getProperty("os.arch")), new Object[0]);
        Log.log.info((Object)("-- OS Vers: " + System.getProperty("os.version")), new Object[0]);
        Log.log.info((Object)("-- Java Vers: " + System.getProperty("java.version")), new Object[0]);
        Log.log.info((Object)("-- Java Home: " + System.getProperty("java.home")), new Object[0]);
        Log.log.info((Object)("-- User Name: " + System.getProperty("user.name")), new Object[0]);
        Log.log.info((Object)("-- User Home: " + System.getProperty("user.home")), new Object[0]);
        Log.log.info((Object)("-- Cur dir: " + System.getProperty("user.dir")), new Object[0]);
        Log.log.info((Object)"---------------------------------------------", new Object[0]);
        Getdown getdown = new Getdown(envc){
            protected JFrame _frame;

            @Override
            protected Container createContainer() {
                if (this._frame == null) {
                    this._frame = new JFrame("");
                    this._frame.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent evt) {
                            this.handleWindowClose();
                        }
                    });
                    String cancelId = "Cancel";
                    this._frame.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), cancelId);
                    this._frame.getRootPane().getActionMap().put(cancelId, new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            this.handleWindowClose();
                        }
                    });
                    this._frame.setUndecorated(this._ifc.hideDecorations);
                    this._frame.setResizable(false);
                } else {
                    this._frame.getContentPane().removeAll();
                }
                this._frame.setDefaultCloseOperation(0);
                return this._frame.getContentPane();
            }

            @Override
            protected void configureContainer() {
                if (this._frame == null) {
                    return;
                }
                this._frame.setTitle(this._ifc.name);
                try {
                    this._frame.setBackground(new Color(this._ifc.background, true));
                }
                catch (Exception e) {
                    Log.log.warning((Object)"Failed to set background", new Object[]{"bg", this._ifc.background, e});
                }
                if (this._ifc.iconImages != null) {
                    ArrayList<BufferedImage> icons = new ArrayList<BufferedImage>();
                    for (String path : this._ifc.iconImages) {
                        BufferedImage img = this.loadImage(path);
                        if (img == null) {
                            Log.log.warning((Object)"Error loading icon image", new Object[]{"path", path});
                            continue;
                        }
                        icons.add(img);
                    }
                    if (icons.isEmpty()) {
                        Log.log.warning((Object)"Failed to load any icons", new Object[]{"iconImages", this._ifc.iconImages});
                    } else {
                        this._frame.setIconImages(icons);
                    }
                }
            }

            @Override
            protected void showContainer() {
                if (this._frame != null) {
                    this._frame.pack();
                    SwingUtil.centerWindow((Window)this._frame);
                    this._frame.setVisible(true);
                }
            }

            @Override
            protected void disposeContainer() {
                if (this._frame != null) {
                    this._frame.dispose();
                    this._frame = null;
                }
            }

            @Override
            protected void showDocument(String url) {
                String osName;
                if (!StringUtil.couldBeValidUrl((String)url)) {
                    Log.log.warning((Object)"Invalid document URL.", new Object[]{"url", url});
                    return;
                }
                String[] cmdarray = LaunchUtil.isWindows() ? ((osName = System.getProperty("os.name", "")).contains("9") || osName.contains("Me") ? new String[]{"command.com", "/c", "start", "\"" + url + "\""} : new String[]{"cmd.exe", "/c", "start", "\"\"", "\"" + url + "\""}) : (LaunchUtil.isMacOS() ? new String[]{"open", url} : new String[]{"firefox", url});
                try {
                    Runtime.getRuntime().exec(cmdarray);
                }
                catch (Exception e) {
                    Log.log.warning((Object)"Failed to open browser.", new Object[]{"cmdarray", cmdarray, e});
                }
            }

            @Override
            protected void exit(int exitCode) {
                if (this.invokeDirect()) {
                    this.disposeContainer();
                } else {
                    System.exit(exitCode);
                }
            }

            @Override
            protected void fail(String message) {
                super.fail(message);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (_frame != null && _frame.isUndecorated()) {
                            _frame.dispose();
                            Color bg = _frame.getBackground();
                            if (bg != null && bg.getAlpha() < 255) {
                                _frame.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
                            }
                            _frame.setUndecorated(false);
                            this.showContainer();
                        }
                    }
                });
            }
        };
        Getdown.run(getdown);
        return getdown;
    }
}

