/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.launcher;

import com.samskivert.swing.GroupLayout;
import com.samskivert.swing.Spacer;
import com.samskivert.swing.VGroupLayout;
import com.threerings.getdown.Log;
import com.threerings.getdown.launcher.Getdown;
import com.threerings.getdown.util.MessageUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public final class ProxyPanel
extends JPanel
implements ActionListener {
    protected final Getdown _getdown;
    protected final ResourceBundle _msgs;
    protected final boolean _updateAuth;
    protected JTextField _host;
    protected JTextField _port;
    protected JCheckBox _useAuth;
    protected JTextField _username;
    protected JPasswordField _password;

    public ProxyPanel(Getdown getdown, ResourceBundle msgs, boolean updateAuth) {
        this._getdown = getdown;
        this._msgs = msgs;
        this._updateAuth = updateAuth;
        this.setLayout((LayoutManager)new VGroupLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        String title = this.get(updateAuth ? "m.update_proxy_auth" : "m.configure_proxy");
        this.add(new SaneLabelField(title));
        this.add((Component)new Spacer(5, 5));
        JPanel row = new JPanel(new GridLayout());
        row.add((Component)new SaneLabelField(this.get("m.proxy_host")), "West");
        this._host = new SaneTextField();
        row.add(this._host);
        this.add(row);
        row = new JPanel(new GridLayout());
        row.add((Component)new SaneLabelField(this.get("m.proxy_port")), "West");
        this._port = new SaneTextField();
        row.add(this._port);
        this.add(row);
        this.add((Component)new Spacer(5, 5));
        row = new JPanel(new GridLayout());
        row.add((Component)new SaneLabelField(this.get("m.proxy_auth_required")), "West");
        this._useAuth = new JCheckBox();
        row.add(this._useAuth);
        this._useAuth.setSelected(updateAuth);
        this.add(row);
        row = new JPanel(new GridLayout());
        row.add((Component)new SaneLabelField(this.get("m.proxy_username")), "West");
        this._username = new SaneTextField();
        this._username.setEnabled(updateAuth);
        row.add(this._username);
        this.add(row);
        row = new JPanel(new GridLayout());
        row.add((Component)new SaneLabelField(this.get("m.proxy_password")), "West");
        this._password = new SanePasswordField();
        this._password.setEnabled(updateAuth);
        row.add(this._password);
        this.add(row);
        this._useAuth.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                boolean selected = event.getStateChange() == 1;
                ProxyPanel.this._username.setEnabled(selected);
                ProxyPanel.this._password.setEnabled(selected);
            }
        });
        this.add((Component)new Spacer(5, 5));
        row = GroupLayout.makeButtonBox((GroupLayout.Justification)GroupLayout.CENTER, (Component[])new Component[0]);
        JButton button = new JButton(this.get("m.proxy_ok"));
        row.add(button);
        button.setActionCommand("ok");
        button.addActionListener(this);
        button = new JButton(this.get("m.proxy_cancel"));
        row.add(button);
        button.setActionCommand("cancel");
        button.addActionListener(this);
        this.add(row);
    }

    public void setProxy(String host, String port) {
        if (host != null) {
            this._host.setText(host);
        }
        if (port != null) {
            this._port.setText(port);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this._updateAuth) {
            this._username.requestFocusInWindow();
        } else {
            this._host.requestFocusInWindow();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(500, 320);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if ("ok".equals(cmd)) {
            String user = null;
            String pass = null;
            if (this._useAuth.isSelected()) {
                user = this._username.getText();
                pass = new String(this._password.getPassword());
            }
            this._getdown.configProxy(this._host.getText(), this._port.getText(), user, pass);
        } else {
            System.exit(0);
        }
    }

    protected String get(String key) {
        if (MessageUtil.isTainted((String)key)) {
            return MessageUtil.untaint((String)key);
        }
        try {
            return this._msgs.getString(key);
        }
        catch (MissingResourceException mre) {
            Log.log.warning((Object)("Missing translation message '" + key + "'."), new Object[0]);
            return key;
        }
    }

    protected static Dimension clampWidth(Dimension dim, int minWidth) {
        dim.width = Math.max(dim.width, minWidth);
        return dim;
    }

    protected static class SanePasswordField
    extends JPasswordField {
        protected SanePasswordField() {
        }

        @Override
        public Dimension getPreferredSize() {
            return ProxyPanel.clampWidth(super.getPreferredSize(), 150);
        }
    }

    protected static class SaneTextField
    extends JTextField {
        protected SaneTextField() {
        }

        @Override
        public Dimension getPreferredSize() {
            return ProxyPanel.clampWidth(super.getPreferredSize(), 150);
        }
    }

    protected static class SaneLabelField
    extends JLabel {
        public SaneLabelField(String message) {
            super(message);
        }

        @Override
        public Dimension getPreferredSize() {
            return ProxyPanel.clampWidth(super.getPreferredSize(), 200);
        }
    }
}

