/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.launcher;

import ca.beq.util.win32.registry.RegistryKey;
import ca.beq.util.win32.registry.RegistryValue;
import ca.beq.util.win32.registry.RootKey;
import com.threerings.getdown.Log;
import com.threerings.getdown.data.Application;
import com.threerings.getdown.net.Connector;
import com.threerings.getdown.spi.ProxyAuth;
import com.threerings.getdown.util.Config;
import com.threerings.getdown.util.LaunchUtil;
import com.threerings.getdown.util.StringUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.script.Bindings;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

public final class ProxyUtil {
    protected static final String PROXY_REGISTRY = "Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings";

    public static boolean autoDetectProxy(Application app) {
        String host = null;
        String port = null;
        if (System.getProperty("https.proxyHost") != null) {
            host = System.getProperty("https.proxyHost");
            port = System.getProperty("https.proxyPort");
        }
        if (StringUtil.isBlank(host) && System.getProperty("http.proxyHost") != null) {
            host = System.getProperty("http.proxyHost");
            port = System.getProperty("http.proxyPort");
        }
        if (StringUtil.isBlank((String)host) && LaunchUtil.isWindows()) {
            try {
                String rhost = null;
                String rport = null;
                boolean enabled = false;
                RegistryKey.initialize();
                RegistryKey r = new RegistryKey(RootKey.HKEY_CURRENT_USER, PROXY_REGISTRY);
                Iterator iter = r.values();
                block2: while (iter.hasNext()) {
                    RegistryValue value = (RegistryValue)iter.next();
                    if ("ProxyEnable".equals(value.getName())) {
                        enabled = "1".equals(value.getStringValue());
                    }
                    if (value.getName().equals("ProxyServer")) {
                        String[] hostPort = ProxyUtil.splitHostPort(value.getStringValue());
                        rhost = hostPort[0];
                        rport = hostPort[1];
                    }
                    if (!value.getName().equals("AutoConfigURL")) continue;
                    String acurl = value.getStringValue();
                    InputStreamReader acjs = new InputStreamReader(new URL(acurl).openStream());
                    URL configURL = app.getConfigResource().getRemote();
                    for (String proxy : ProxyUtil.findPACProxiesForURL(acjs, configURL)) {
                        if (!proxy.startsWith("PROXY ")) continue;
                        String[] hostPort = ProxyUtil.splitHostPort(proxy.substring(6));
                        rhost = hostPort[0];
                        rport = hostPort[1];
                        enabled = true;
                        continue block2;
                    }
                }
                if (enabled) {
                    host = rhost;
                    port = rport;
                } else {
                    Log.log.info((Object)"Detected no proxy settings in the registry.", new Object[0]);
                }
            }
            catch (Throwable t) {
                Log.log.info((Object)"Failed to find proxy settings in Windows registry", new Object[]{"error", t});
            }
        }
        if (StringUtil.isBlank((String)host)) {
            String[] hostPort = ProxyUtil.loadProxy(app);
            host = hostPort[0];
            port = hostPort[1];
        }
        if (StringUtil.isBlank((String)host)) {
            return false;
        }
        ProxyUtil.initProxy(app, host, port, null, null);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean canLoadWithoutProxy(URL rurl, int timeoutSeconds) {
        Log.log.info((Object)("Attempting to fetch without proxy: " + rurl), new Object[0]);
        try {
            URLConnection conn = Connector.DEFAULT.open(rurl, timeoutSeconds, timeoutSeconds);
            if (!(conn instanceof HttpURLConnection)) {
                return true;
            }
            HttpURLConnection hcon = (HttpURLConnection)conn;
            try {
                hcon.setRequestMethod("HEAD");
                hcon.connect();
                int rcode = hcon.getResponseCode();
                if (rcode == 407 || rcode == 403) {
                    Log.log.warning((Object)"Got an 'HTTP credentials needed' response", new Object[]{"code", rcode});
                    return false;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                hcon.disconnect();
            }
        }
        catch (IOException ioe) {
            Log.log.info((Object)("Failed to HEAD " + rurl + ": " + ioe), new Object[0]);
            Log.log.info((Object)"We probably need a proxy, but auto-detection failed.", new Object[0]);
        }
        return false;
    }

    public static void configProxy(Application app, String host, String port, String username, String password) {
        ProxyUtil.saveProxy(app, host, port);
        if (!StringUtil.isBlank((String)username) && !StringUtil.isBlank((String)password)) {
            ServiceLoader<ProxyAuth> loader = ServiceLoader.load(ProxyAuth.class);
            Iterator<ProxyAuth> iterator = loader.iterator();
            String appDir = app.getAppDir().getAbsolutePath();
            while (iterator.hasNext()) {
                iterator.next().saveCredentials(appDir, username, password);
            }
        }
        ProxyUtil.initProxy(app, host, port, username, password);
    }

    public static String[] loadProxy(Application app) {
        File pfile = app.getLocalPath("proxy.txt");
        if (pfile.exists()) {
            try {
                Config pconf = Config.parseConfig((File)pfile, (Config.ParseOpts)Config.createOpts((boolean)false));
                return new String[]{pconf.getString("host"), pconf.getString("port")};
            }
            catch (IOException ioe) {
                Log.log.warning((Object)("Failed to read '" + pfile + "': " + ioe), new Object[0]);
            }
        }
        return new String[]{null, null};
    }

    public static void saveProxy(Application app, String host, String port) {
        File pfile = app.getLocalPath("proxy.txt");
        try (PrintStream pout = new PrintStream(new FileOutputStream(pfile));){
            if (!StringUtil.isBlank((String)host)) {
                pout.println("host = " + host);
            }
            if (!StringUtil.isBlank((String)port)) {
                pout.println("port = " + port);
            }
        }
        catch (IOException ioe) {
            Log.log.warning((Object)("Error creating proxy file '" + pfile + "': " + ioe), new Object[0]);
        }
    }

    public static void initProxy(Application app, String host, String port, String username, String password) {
        boolean haveCreds;
        ProxyAuth.Credentials creds;
        String appDir = app.getAppDir().getAbsolutePath();
        ServiceLoader<ProxyAuth> loader = ServiceLoader.load(ProxyAuth.class);
        Iterator<ProxyAuth> iter = loader.iterator();
        ProxyAuth.Credentials credentials = creds = iter.hasNext() ? iter.next().loadCredentials(appDir) : null;
        if (creds != null) {
            username = creds.username;
            password = creds.password;
        }
        boolean bl = haveCreds = !StringUtil.isBlank((String)username) && !StringUtil.isBlank((String)password);
        if (StringUtil.isBlank((String)host)) {
            Log.log.info((Object)"Using no proxy", new Object[0]);
            app.conn = new Connector();
        } else {
            int pp = StringUtil.isBlank((String)port) ? 80 : Integer.valueOf(port);
            Log.log.info((Object)"Using proxy", new Object[]{"host", host, "port", pp, "haveCreds", haveCreds});
            app.conn = new Connector(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, pp)));
        }
        if (haveCreds) {
            final String fuser = username;
            final char[] fpass = password.toCharArray();
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(fuser, fpass);
                }
            });
        }
    }

    public static String[] findPACProxiesForURL(Reader pac, URL url) {
        try {
            ScriptEngineManager manager = new ScriptEngineManager();
            ScriptEngine engine = manager.getEngineByName("javascript");
            Bindings globals = engine.createBindings();
            globals.put("resolver", (Object)new Resolver());
            engine.setBindings(globals, 200);
            URL utils = ProxyUtil.class.getResource("PacUtils.js");
            if (utils == null) {
                Log.log.error((Object)"Unable to load PacUtils.js", new Object[0]);
                return new String[0];
            }
            engine.eval(new InputStreamReader(utils.openStream()));
            Object res = engine.eval(pac);
            if (engine instanceof Invocable) {
                Object[] args = new Object[]{url.toString(), url.getHost()};
                res = ((Invocable)((Object)engine)).invokeFunction("FindProxyForURL", args);
            }
            String[] proxies = res.toString().split(";");
            for (int ii = 0; ii < proxies.length; ++ii) {
                proxies[ii] = proxies[ii].trim();
            }
            return proxies;
        }
        catch (Exception | NoClassDefFoundError e) {
            Log.log.warning((Object)"Failed to resolve PAC proxy", new Object[]{e});
            return new String[0];
        }
    }

    private static String[] splitHostPort(String hostPort) {
        int cidx = hostPort.indexOf(":");
        if (cidx == -1) {
            return new String[]{hostPort, null};
        }
        return new String[]{hostPort.substring(0, cidx), hostPort.substring(cidx + 1)};
    }

    public static class Resolver {
        public String dnsResolve(String host) {
            try {
                return InetAddress.getByName(host).getHostAddress();
            }
            catch (UnknownHostException uhe) {
                return null;
            }
        }

        public String myIpAddress() {
            try {
                return InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException uhe) {
                return null;
            }
        }
    }
}

