/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.launcher;

import com.threerings.getdown.Log;
import java.awt.Image;
import java.util.List;

public final class RotatingBackgrounds {
    protected long currentDisplayStart;
    protected int current = -1;
    protected Image[] images;
    protected Image errorImage;
    protected int[] percentages;
    protected int[] minDisplayTime;

    public RotatingBackgrounds() {
        this.makeEmpty();
    }

    public RotatingBackgrounds(Image background) {
        this.percentages = new int[]{0};
        this.minDisplayTime = new int[]{0};
        this.images = new Image[]{background};
        this.errorImage = this.images[0];
    }

    public RotatingBackgrounds(List<String> backgrounds, String errorBackground, ImageLoader loader) {
        this.percentages = new int[backgrounds.size()];
        this.minDisplayTime = new int[backgrounds.size()];
        this.images = new Image[backgrounds.size()];
        for (int ii = 0; ii < backgrounds.size(); ++ii) {
            String background = backgrounds.get(ii);
            String[] pieces = background.split(";");
            if (pieces.length != 2) {
                Log.log.warning((Object)("Unable to parse background image '" + background + "'"), new Object[0]);
                this.makeEmpty();
                return;
            }
            this.images[ii] = loader.loadImage(pieces[0]);
            try {
                this.minDisplayTime[ii] = Integer.parseInt(pieces[1]);
            }
            catch (NumberFormatException e) {
                Log.log.warning((Object)("Unable to parse background image display time '" + background + "'"), new Object[0]);
                this.makeEmpty();
                return;
            }
            this.percentages[ii] = (int)((float)ii / (float)backgrounds.size() * 100.0f);
        }
        this.errorImage = errorBackground == null ? this.images[0] : loader.loadImage(errorBackground);
    }

    public Image getImage(int progress) {
        if (this.images.length == 0) {
            return null;
        }
        long now = System.currentTimeMillis();
        if (this.current != this.images.length - 1 && (this.current == -1 || progress >= this.percentages[this.current + 1] && (now - this.currentDisplayStart) / 1000L > (long)this.minDisplayTime[this.current])) {
            ++this.current;
            this.currentDisplayStart = now;
        }
        return this.images[this.current];
    }

    public Image getErrorImage() {
        return this.errorImage;
    }

    public int getNumImages() {
        return this.images.length;
    }

    protected void makeEmpty() {
        this.percentages = new int[0];
        this.minDisplayTime = new int[0];
        this.images = new Image[0];
    }

    public static interface ImageLoader {
        public Image loadImage(String var1);
    }
}

