/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.launcher;

import com.samskivert.swing.Label;
import com.samskivert.swing.util.SwingUtil;
import com.samskivert.util.Throttle;
import com.threerings.getdown.Log;
import com.threerings.getdown.data.Application;
import com.threerings.getdown.launcher.RotatingBackgrounds;
import com.threerings.getdown.util.MessageUtil;
import com.threerings.getdown.util.Rectangle;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.ImageObserver;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.Timer;

public final class StatusPanel
extends JComponent
implements ImageObserver {
    protected Image _barimg;
    protected RotatingBackgrounds _bg;
    protected Dimension _psize;
    protected ResourceBundle _msgs;
    protected int _progress = -1;
    protected String _status;
    protected int _statusDots = 1;
    protected boolean _displayError;
    protected Label _label;
    protected Label _newlab;
    protected Label _plabel;
    protected Label _newplab;
    protected Label _rlabel;
    protected Label _newrlab;
    protected Application.UpdateInterface _ifc;
    protected Timer _timer;
    protected long[] _remain = new long[4];
    protected int _ridx;
    protected Throttle _rthrottle = new Throttle(1, 1000L);
    protected static final Font FONT = new Font("SansSerif", 1, 12);

    public StatusPanel(ResourceBundle msgs) {
        this._msgs = msgs;
        this._timer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (StatusPanel.this._status != null && !StatusPanel.this._displayError) {
                    StatusPanel.this._statusDots = StatusPanel.this._statusDots % 3 + 1;
                    StatusPanel.this.updateStatusLabel();
                }
            }
        });
    }

    public void init(Application.UpdateInterface ifc, RotatingBackgrounds bg, Image barimg) {
        int height;
        this._ifc = ifc;
        this._bg = bg;
        Image img = this._bg.getImage(this._progress);
        int width = img == null ? -1 : img.getWidth(this);
        int n = height = img == null ? -1 : img.getHeight(this);
        if (width == -1 || height == -1) {
            Rectangle bounds = ifc.progress.union(ifc.status);
            this._psize = new Dimension(bounds.x + bounds.width + bounds.x, bounds.y + bounds.height + bounds.x);
        } else {
            this._psize = new Dimension(width, height);
        }
        this._barimg = barimg;
        this.invalidate();
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        boolean updated = false;
        if ((infoflags & 1) != 0) {
            this._psize.width = width;
            updated = true;
        }
        if ((infoflags & 2) != 0) {
            this._psize.height = height;
            updated = true;
        }
        if (updated) {
            this.invalidate();
            this.setSize(this._psize);
            this.getParent().setSize(this._psize);
        }
        return (infoflags & 0x20) == 0;
    }

    public void setProgress(int percent, long remaining) {
        boolean needsRepaint = false;
        if (this._progress != percent) {
            this._progress = percent;
            if (!this._ifc.hideProgressText) {
                String msg = MessageFormat.format(this.get("m.complete"), percent);
                this._newplab = this.createLabel(msg, new Color(this._ifc.progressText, true));
            }
            needsRepaint = true;
        }
        if (remaining > 1L) {
            if (!this._rthrottle.throttleOp()) {
                this._remain[this._ridx++ % this._remain.length] = remaining;
            }
            remaining = 0L;
            int values = Math.min(this._ridx, this._remain.length);
            for (int ii = 0; ii < values; ++ii) {
                remaining += this._remain[ii];
            }
            remaining /= (long)values;
            if (!this._ifc.hideProgressText) {
                int minutes = (int)(remaining / 60L);
                int seconds = (int)(remaining % 60L);
                String remstr = minutes + ":" + (seconds < 10 ? "0" : "") + seconds;
                String msg = MessageFormat.format(this.get("m.remain"), remstr);
                this._newrlab = this.createLabel(msg, new Color(this._ifc.statusText, true));
            }
            needsRepaint = true;
        } else if (this._rlabel != null || this._newrlab != null) {
            this._rthrottle = new Throttle(1, 1000L);
            this._ridx = 0;
            this._rlabel = null;
            this._newrlab = null;
            needsRepaint = true;
        }
        if (needsRepaint) {
            this.repaint();
        }
    }

    public void setStatus(String status, boolean displayError) {
        this._status = this.xlate(status);
        this._displayError = displayError;
        this.updateStatusLabel();
    }

    public void stopThrob() {
        this._timer.stop();
        this._statusDots = 3;
        this.updateStatusLabel();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this._timer.start();
    }

    @Override
    public void removeNotify() {
        this._timer.stop();
        super.removeNotify();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D gfx = (Graphics2D)g;
        Image img = this._displayError ? this._bg.getErrorImage() : this._bg.getImage(this._progress);
        if (img != null) {
            gfx.drawImage(img, 0, 0, this);
        }
        Object oalias = SwingUtil.activateAntiAliasing((Graphics2D)gfx);
        if (this._newlab != null) {
            this._newlab.layout(gfx);
            this._label = this._newlab;
            this._newlab = null;
        }
        if (this._newplab != null) {
            this._newplab.layout(gfx);
            this._plabel = this._newplab;
            this._newplab = null;
        }
        if (this._newrlab != null) {
            this._newrlab.layout(gfx);
            this._rlabel = this._newrlab;
            this._newrlab = null;
        }
        if (this._barimg != null) {
            gfx.setClip(this._ifc.progress.x, this._ifc.progress.y, this._progress * this._ifc.progress.width / 100, this._ifc.progress.height);
            gfx.drawImage(this._barimg, this._ifc.progress.x, this._ifc.progress.y, null);
            gfx.setClip(null);
        } else {
            gfx.setColor(new Color(this._ifc.progressBar, true));
            gfx.fillRect(this._ifc.progress.x, this._ifc.progress.y, this._progress * this._ifc.progress.width / 100, this._ifc.progress.height);
        }
        if (this._plabel != null) {
            int xmarg = (this._ifc.progress.width - this._plabel.getSize().width) / 2;
            int ymarg = (this._ifc.progress.height - this._plabel.getSize().height) / 2;
            this._plabel.render(gfx, (float)(this._ifc.progress.x + xmarg), (float)(this._ifc.progress.y + ymarg));
        }
        if (this._label != null) {
            this._label.render(gfx, (float)this._ifc.status.x, (float)this.getStatusY(this._label));
        }
        if (this._rlabel != null) {
            int x = this._ifc.status.x + this._ifc.status.width - this._rlabel.getSize().width;
            this._rlabel.render(gfx, (float)x, (float)this.getStatusY(this._rlabel));
        }
        SwingUtil.restoreAntiAliasing((Graphics2D)gfx, (Object)oalias);
    }

    @Override
    public Dimension getPreferredSize() {
        return this._psize;
    }

    protected void updateStatusLabel() {
        String status = this._status;
        if (!this._displayError) {
            for (int ii = 0; ii < this._statusDots; ++ii) {
                status = status + " .";
            }
        }
        this._newlab = this.createLabel(status, new Color(this._ifc.statusText, true));
        int width = this._ifc.status.width;
        if (width == 0) {
            width = this.getWidth();
        }
        if (width > 0) {
            this._newlab.setTargetWidth(width);
        }
        this.repaint();
    }

    protected int getStatusY(Label label) {
        if (this._ifc.status.y > this._ifc.progress.y) {
            return this._ifc.status.y;
        }
        return this._ifc.status.y + (this._ifc.status.height - label.getSize().height);
    }

    protected Label createLabel(String text, Color color) {
        Label label = new Label(text, color, FONT);
        if (this._ifc.textShadow != 0) {
            label.setAlternateColor(new Color(this._ifc.textShadow, true));
            label.setStyle(4);
        }
        return label;
    }

    protected String xlate(String compoundKey) {
        int tidx = compoundKey.indexOf(124);
        if (tidx == -1) {
            return this.get(compoundKey);
        }
        String key = compoundKey.substring(0, tidx);
        String argstr = compoundKey.substring(tidx + 1);
        String[] args = argstr.split("\\|");
        for (int i = 0; i < args.length; ++i) {
            args[i] = MessageUtil.isTainted((String)args[i]) ? MessageUtil.unescape((String)MessageUtil.untaint((String)args[i])) : this.xlate(MessageUtil.unescape((String)args[i]));
        }
        return this.get(key, args);
    }

    protected String get(String key, String[] args) {
        String msg = this.get(key);
        if (msg != null) {
            return MessageFormat.format(MessageUtil.escape((String)msg), args);
        }
        return key + Arrays.asList(args);
    }

    protected String get(String key) {
        if (this._msgs == null) {
            return key;
        }
        if (MessageUtil.isTainted((String)key)) {
            return MessageUtil.untaint((String)key);
        }
        try {
            return this._msgs.getString(key);
        }
        catch (MissingResourceException mre) {
            Log.log.warning((Object)("Missing translation message '" + key + "'."), new Object[0]);
            return key;
        }
    }
}

