/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.data;

import com.threerings.getdown.Log;
import com.threerings.getdown.data.SysProps;
import com.threerings.getdown.data.g;
import com.threerings.getdown.util.FileUtil;
import com.threerings.getdown.util.ProgressObserver;
import com.threerings.getdown.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Resource
implements Comparable<Resource> {
    public static final EnumSet<Attr> NORMAL = EnumSet.noneOf(Attr.class);
    public static final EnumSet<Attr> UNPACK = EnumSet.of(Attr.UNPACK);
    public static final EnumSet<Attr> EXEC = EnumSet.of(Attr.EXEC);
    public static final EnumSet<Attr> PRELOAD = EnumSet.of(Attr.PRELOAD);
    public static final EnumSet<Attr> NATIVE = EnumSet.of(Attr.NATIVE);
    protected String _path;
    protected URL _remote;
    protected File _local;
    protected File _localNew;
    protected File _marker;
    protected File _unpacked;
    protected EnumSet<Attr> _attrs;
    protected boolean _isZip;
    protected static final Comparator<ZipEntry> ENTRY_COMP = new g();
    protected static final int DIGEST_BUFFER_SIZE = 5125;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String computeDigest(int n2, File file, MessageDigest messageDigest, ProgressObserver progressObserver) throws IOException {
        messageDigest.reset();
        byte[] byArray = new byte[5125];
        int n3 = Resource.isJar(file) || Resource.isZip(file) ? 1 : 0;
        if (n3 != 0) {
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(file);
                ArrayList<? extends ZipEntry> arrayList = Collections.list(zipFile.entries());
                Collections.sort(arrayList, ENTRY_COMP);
                for (ZipEntry zipEntry : arrayList) {
                    block25: {
                        if (n2 < 2 && zipEntry.getName().startsWith("META-INF")) {
                            Resource.updateProgress(progressObserver, 0L, arrayList.size());
                            continue;
                        }
                        InputStream inputStream = zipFile.getInputStream(zipEntry);
                        Throwable throwable = null;
                        try {
                            while ((n3 = inputStream.read(byArray)) != -1) {
                                messageDigest.update(byArray, 0, n3);
                            }
                            if (inputStream == null) break block25;
                        }
                        catch (Throwable throwable2) {
                            try {
                                Throwable throwable3 = throwable2;
                                throwable = throwable2;
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                if (inputStream == null) throw throwable4;
                                if (throwable == null) {
                                    inputStream.close();
                                    throw throwable4;
                                }
                                try {
                                    inputStream.close();
                                    throw throwable4;
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                    throw throwable4;
                                }
                            }
                        }
                        inputStream.close();
                    }
                    Resource.updateProgress(progressObserver, 0L, arrayList.size());
                }
            }
            catch (Throwable throwable) {
                if (zipFile == null) throw throwable;
                try {
                    zipFile.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    Log.log.warning("Error closing", "path", file, "zip", zipFile, "error", iOException);
                }
                throw throwable;
            }
            try {
                zipFile.close();
                return StringUtil.hexlate(messageDigest.digest());
            }
            catch (IOException iOException) {
                Log.log.warning("Error closing", "path", file, "zip", zipFile, "error", iOException);
                return StringUtil.hexlate(messageDigest.digest());
            }
        }
        long l2 = file.length();
        long l3 = 0L;
        FileInputStream fileInputStream = new FileInputStream(file);
        Throwable throwable = null;
        try {
            while ((n3 = fileInputStream.read(byArray)) != -1) {
                messageDigest.update(byArray, 0, n3);
                Resource.updateProgress(progressObserver, l3 += (long)n3, l2);
            }
        }
        catch (Throwable throwable6) {
            try {
                Throwable throwable7 = throwable6;
                Throwable throwable8 = throwable6;
                throw throwable7;
            }
            catch (Throwable throwable9) {
                if (throwable == null) {
                    fileInputStream.close();
                    throw throwable9;
                }
                try {
                    fileInputStream.close();
                    throw throwable9;
                }
                catch (Throwable throwable10) {
                    throwable.addSuppressed(throwable10);
                    throw throwable9;
                }
            }
        }
        fileInputStream.close();
        return StringUtil.hexlate(messageDigest.digest());
    }

    public static boolean isZip(File object) {
        return ((String)(object = ((File)object).getName())).endsWith(".zip") || ((String)object).endsWith(".zip_new");
    }

    public static boolean isJar(File object) {
        return ((String)(object = ((File)object).getName())).endsWith(".jar") || ((String)object).endsWith(".jar_new");
    }

    public Resource(String string, URL uRL, File file, EnumSet<Attr> enumSet) {
        this._path = string;
        this._remote = uRL;
        this._local = file;
        this._localNew = new File(file.toString() + "_new");
        this._marker = new File(this._local.getPath() + "v");
        this._attrs = enumSet;
        this._isZip = Resource.isJar(file) || Resource.isZip(file);
        boolean bl = enumSet.contains((Object)Attr.UNPACK);
        if (bl && this._isZip) {
            this._unpacked = this._local.getParentFile();
        }
    }

    public String getPath() {
        return this._path;
    }

    public File getLocal() {
        return this._local;
    }

    public File getLocalNew() {
        return this._localNew;
    }

    public File getUnpacked() {
        return this._unpacked;
    }

    public File getFinalTarget() {
        if (this.shouldUnpack()) {
            return this.getUnpacked();
        }
        return this.getLocal();
    }

    public URL getRemote() {
        return this._remote;
    }

    public boolean shouldUnpack() {
        return this._attrs.contains((Object)Attr.UNPACK) && !SysProps.noUnpack();
    }

    public boolean shouldPredownload() {
        return this._attrs.contains((Object)Attr.PRELOAD);
    }

    public boolean isNative() {
        return this._attrs.contains((Object)Attr.NATIVE);
    }

    public String computeDigest(int n2, MessageDigest messageDigest, ProgressObserver progressObserver) throws IOException {
        File file = !this._local.toString().toLowerCase(Locale.ROOT).endsWith("getdown.txt") && this._localNew.exists() ? this._localNew : this._local;
        return Resource.computeDigest(n2, file, messageDigest, progressObserver);
    }

    public boolean isMarkedValid() {
        if (!this._local.exists()) {
            this.clearMarker();
            return false;
        }
        return this._marker.exists();
    }

    public void markAsValid() throws IOException {
        this._marker.createNewFile();
    }

    public void clearMarker() {
        if (this._marker.exists() && !FileUtil.deleteHarder(this._marker)) {
            Log.log.warning("Failed to erase marker file '" + this._marker + "'.", new Object[0]);
        }
    }

    public void install(boolean bl) throws IOException {
        File file = this.getLocalNew();
        File file2 = this.getLocal();
        Log.log.info("- " + file, new Object[0]);
        if (!FileUtil.renameTo(file, file2)) {
            throw new IOException("Failed to rename " + file + " to " + file2);
        }
        this.applyAttrs();
        if (bl) {
            this.markAsValid();
        }
    }

    public void unpack() throws IOException {
        if (!this._isZip) {
            throw new IOException("Requested to unpack non-jar file '" + this._local + "'.");
        }
        ZipFile zipFile = new ZipFile(this._local);
        Throwable throwable = null;
        try {
            FileUtil.unpackJar(zipFile, this._unpacked, this._attrs.contains((Object)Attr.CLEAN));
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (throwable != null) {
                    try {
                        zipFile.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    zipFile.close();
                }
                throw throwable4;
            }
        }
        zipFile.close();
        return;
    }

    public void applyAttrs() throws IOException {
        if (this.shouldUnpack()) {
            this.unpack();
        }
        if (this._attrs.contains((Object)Attr.EXEC)) {
            FileUtil.makeExecutable(this._local);
        }
    }

    public void erase() {
        this.clearMarker();
        if (this._local.exists() && !FileUtil.deleteHarder(this._local)) {
            Log.log.warning("Failed to erase resource '" + this._local + "'.", new Object[0]);
        }
    }

    @Override
    public int compareTo(Resource resource) {
        return this._path.compareTo(resource._path);
    }

    public boolean equals(Object object) {
        if (object instanceof Resource) {
            return this._path.equals(((Resource)object)._path);
        }
        return false;
    }

    public int hashCode() {
        return this._path.hashCode();
    }

    public String toString() {
        return this._path;
    }

    protected static void updateProgress(ProgressObserver progressObserver, long l2, long l3) {
        if (progressObserver != null) {
            progressObserver.progress((int)(100L * l2 / l3));
        }
    }

    public static enum Attr {
        UNPACK,
        CLEAN,
        EXEC,
        PRELOAD,
        NATIVE;

    }
}

