/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.util;

import com.threerings.getdown.Log;
import com.threerings.getdown.util.FileUtil;
import com.threerings.getdown.util.HostWhitelist;
import com.threerings.getdown.util.Rectangle;
import com.threerings.getdown.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class Config {
    public static final Config EMPTY = new Config(new HashMap<String, Object>());
    private final Map<String, Object> _data;

    public static ParseOpts createOpts(boolean bl) {
        ParseOpts parseOpts = new ParseOpts();
        if (bl) {
            parseOpts.osname = StringUtil.deNull(System.getProperty("os.name")).toLowerCase(Locale.ROOT);
            parseOpts.osarch = StringUtil.deNull(System.getProperty("os.arch")).toLowerCase(Locale.ROOT);
        }
        return parseOpts;
    }

    public static List<String[]> parsePairs(Reader object, ParseOpts parseOpts) throws IOException {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        for (String string : FileUtil.readLines((Reader)object)) {
            int n2 = string.indexOf(35);
            if (parseOpts.strictComments ? n2 == 0 : n2 != -1) {
                string = string.substring(0, n2);
            }
            if (StringUtil.isBlank(string = string.trim())) continue;
            String[] stringArray = new String[2];
            int n3 = parseOpts.biasToKey ? string.lastIndexOf(61) : string.indexOf(61);
            if (n3 != -1) {
                stringArray[0] = string.substring(0, n3).trim();
                stringArray[1] = string.substring(n3 + 1).trim();
            } else {
                stringArray[0] = string;
                stringArray[1] = "";
            }
            if (stringArray[1].startsWith("[")) {
                int n4 = stringArray[1].indexOf(93);
                if (n4 == -1) {
                    Log.log.warning("Bogus platform specifier", "key", stringArray[0], "value", stringArray[1]);
                    continue;
                }
                String string2 = stringArray[1].substring(1, n4);
                if (parseOpts.osname != null && !Config.checkQualifiers(string2, parseOpts.osname, parseOpts.osarch)) {
                    Log.log.debug("Skipping", "quals", string2, "osname", parseOpts.osname, "osarch", parseOpts.osarch, "key", stringArray[0], "value", stringArray[1]);
                    continue;
                }
                stringArray[1] = stringArray[1].substring(n4 + 1).trim();
            }
            arrayList.add(stringArray);
        }
        return arrayList;
    }

    /*
     * Loose catch block
     */
    public static List<String[]> parsePairs(File object, ParseOpts object2) throws IOException {
        object = new FileInputStream((File)object);
        Throwable throwable = null;
        Object object3 = new InputStreamReader((InputStream)object, StandardCharsets.UTF_8);
        Throwable throwable2 = null;
        object2 = Config.parsePairs((Reader)object3, (ParseOpts)object2);
        ((InputStreamReader)object3).close();
        ((FileInputStream)object).close();
        return object2;
        {
            catch (Throwable throwable3) {
                try {
                    try {
                        try {
                            object2 = throwable3;
                            throwable2 = throwable3;
                            throw object2;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 != null) {
                                try {
                                    ((InputStreamReader)object3).close();
                                }
                                catch (Throwable throwable5) {
                                    throwable2.addSuppressed(throwable5);
                                }
                            } else {
                                ((InputStreamReader)object3).close();
                            }
                            throw throwable4;
                        }
                    }
                    catch (Throwable throwable6) {
                        object3 = throwable6;
                        throwable = throwable6;
                        throw object3;
                    }
                }
                catch (Throwable throwable7) {
                    if (throwable != null) {
                        try {
                            ((FileInputStream)object).close();
                        }
                        catch (Throwable throwable8) {
                            throwable.addSuppressed(throwable8);
                        }
                    } else {
                        ((FileInputStream)object).close();
                    }
                    throw throwable7;
                }
            }
        }
    }

    public static Rectangle parseRect(String string, String string2) {
        if (!StringUtil.isBlank(string2)) {
            int[] nArray = StringUtil.parseIntArray(string2);
            if (nArray != null && nArray.length == 4) {
                return new Rectangle(nArray[0], nArray[1], nArray[2], nArray[3]);
            }
            Log.log.warning("Ignoring invalid rect '" + string + "' config '" + string2 + "'.", new Object[0]);
        }
        return null;
    }

    public static Integer parseColor(String string) {
        if (!StringUtil.isBlank(string)) {
            try {
                int n2 = string.length() > 6 ? 0 : -16777216;
                return Integer.parseInt(string, 16) | n2;
            }
            catch (NumberFormatException numberFormatException) {
                Log.log.warning("Ignoring invalid color", "hexValue", string, "exception", numberFormatException);
            }
        }
        return null;
    }

    public static Map<String, Object> parseData(Reader object, ParseOpts stringArray2) throws IOException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (String[] stringArray2 : Config.parsePairs((Reader)object, (ParseOpts)stringArray2)) {
            Object object2 = hashMap.get(stringArray2[0]);
            if (object2 == null) {
                hashMap.put(stringArray2[0], stringArray2[1]);
                continue;
            }
            if (object2 instanceof String) {
                hashMap.put(stringArray2[0], new String[]{(String)object2, stringArray2[1]});
                continue;
            }
            if (!(object2 instanceof String[])) continue;
            object2 = (String[])object2;
            String[] stringArray3 = new String[((String[])object2).length + 1];
            System.arraycopy(object2, 0, stringArray3, 0, ((V)object2).length);
            stringArray3[((V)object2).length] = stringArray2[1];
            hashMap.put(stringArray2[0], stringArray3);
        }
        return hashMap;
    }

    /*
     * Exception decompiling
     */
    public static Config parseConfig(File var0, ParseOpts var1_3) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Config(Map<String, Object> map) {
        this._data = map;
    }

    public boolean hasValue(String string) {
        return this._data.containsKey(string);
    }

    public Object getRaw(String string) {
        return this._data.get(string);
    }

    public String getString(String string) {
        return (String)this._data.get(string);
    }

    public String getString(String string, String string2) {
        if ((string = (String)this._data.get(string)) == null) {
            return string2;
        }
        return string;
    }

    public boolean getBoolean(String string) {
        return Boolean.parseBoolean(this.getString(string));
    }

    public <T extends Enum<T>> T getEnum(String string, Class<T> clazz, T t2) {
        String string2 = this.getString(string, t2.toString());
        try {
            return Enum.valueOf(clazz, string2.toUpperCase());
        }
        catch (Exception exception) {
            Log.log.warning("Invalid value for '" + string + "' config: '" + string2 + "'.", new Object[0]);
            return t2;
        }
    }

    public String[] getMultiValue(String object) {
        if ((object = this._data.get(object)) instanceof String) {
            return new String[]{(String)object};
        }
        return (String[])object;
    }

    public Rectangle getRect(String object, Rectangle rectangle) {
        String string = this.getString((String)object);
        if ((object = Config.parseRect((String)object, string)) == null) {
            return rectangle;
        }
        return object;
    }

    public int getInt(String string, int n2) {
        String string2 = this.getString(string);
        try {
            if (string2 == null) {
                return n2;
            }
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            Log.log.warning("Ignoring invalid int '" + string + "' config '" + string2 + "',", new Object[0]);
            return n2;
        }
    }

    public long getLong(String string, long l2) {
        String string2 = this.getString(string);
        try {
            if (string2 == null) {
                return l2;
            }
            return Long.parseLong(string2);
        }
        catch (Exception exception) {
            Log.log.warning("Ignoring invalid long '" + string + "' config '" + string2 + "',", new Object[0]);
            return l2;
        }
    }

    public int getColor(String object, int n2) {
        object = this.getString((String)object);
        if ((object = Config.parseColor((String)object)) == null) {
            return n2;
        }
        return (Integer)object;
    }

    public String[] getList(String string) {
        if ((string = this.getString(string)) == null) {
            return new String[0];
        }
        return StringUtil.parseStringArray(string);
    }

    public String getUrl(String string, String string2) {
        String string3 = this.getString(string + "." + Locale.getDefault().getLanguage());
        if (StringUtil.isBlank(string3)) {
            string3 = this.getString(string);
        }
        if (StringUtil.isBlank(string3)) {
            string3 = string2;
        }
        if (!StringUtil.isBlank(string3)) {
            try {
                HostWhitelist.verify(new URL(string3));
            }
            catch (MalformedURLException malformedURLException) {
                Log.log.warning("Invalid URL.", "url", string3, malformedURLException);
                string3 = null;
            }
        }
        return string3;
    }

    protected static boolean checkQualifiers(String stringArray, String string, String string2) {
        if (stringArray.startsWith("!")) {
            if (stringArray.contains(",")) {
                Log.log.warning("Multiple qualifiers cannot be used when one of the qualifiers is negative", "quals", stringArray);
                return false;
            }
            return !Config.checkQualifier(stringArray.substring(1), string, string2);
        }
        for (String string3 : stringArray.split(",")) {
            if (!Config.checkQualifier(string3, string, string2)) continue;
            return true;
        }
        return false;
    }

    protected static boolean checkQualifier(String object, String string, String string2) {
        object = object.trim().toLowerCase(Locale.ROOT).split("-");
        String string3 = object[0];
        Object object2 = object = ((String[])object).length > 1 ? object[1] : "";
        return string.contains(string3) && string2.contains((CharSequence)object);
    }

    public static class ParseOpts {
        public boolean biasToKey = false;
        public boolean strictComments = false;
        public String osname = null;
        public String osarch = null;
    }
}

