/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.util;

import com.threerings.getdown.Log;
import com.threerings.getdown.util.StreamUtil;
import com.threerings.getdown.util.a;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class FileUtil {
    public static boolean renameTo(File file, File file2) {
        if (file.renameTo(file2)) {
            return true;
        }
        if (file2.exists()) {
            File file3 = new File(file2.getPath() + "_old");
            if (file3.exists() && !FileUtil.deleteHarder(file3)) {
                Log.log.warning("Failed to delete old intermediate file " + file3 + ".", new Object[0]);
            }
            if (file2.renameTo(file3) && file.renameTo(file2)) {
                if (!FileUtil.deleteHarder(file3)) {
                    Log.log.warning("Failed to delete intermediate file " + file3 + ".", new Object[0]);
                }
                return true;
            }
        }
        try {
            FileUtil.copy(file, file2);
        }
        catch (IOException iOException) {
            Log.log.warning("Failed to copy " + file + " to " + file2 + ": " + iOException, new Object[0]);
            return false;
        }
        if (!FileUtil.deleteHarder(file)) {
            Log.log.warning("Failed to delete " + file + " after brute force copy to " + file2 + ".", new Object[0]);
        }
        return true;
    }

    public static boolean deleteHarder(File file) {
        boolean bl = file.delete() || file.delete();
        if (!bl) {
            file.deleteOnExit();
        }
        return bl;
    }

    public static boolean deleteDirHarder(File file) {
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                FileUtil.deleteDirHarder(file2);
            }
        }
        return FileUtil.deleteHarder(file);
    }

    public static List<String> readLines(Reader reader) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        reader = new BufferedReader(reader);
        Throwable throwable = null;
        try {
            String string;
            while ((string = ((BufferedReader)reader).readLine()) != null) {
                arrayList.add(string);
            }
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (throwable != null) {
                    try {
                        ((BufferedReader)reader).close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    ((BufferedReader)reader).close();
                }
                throw throwable4;
            }
        }
        ((BufferedReader)reader).close();
        return arrayList;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void unpackJar(ZipFile zipFile, File serializable, boolean bl) throws IOException {
        File file;
        Object object;
        void var2_5;
        if (var2_5 != false) {
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                if (!((ZipEntry)object).isDirectory() || !(file = new File((File)serializable, ((ZipEntry)object).getName())).exists()) continue;
                FileUtil.deleteDirHarder(file);
            }
        }
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            file = new File((File)serializable, ((ZipEntry)object).getName());
            if (((ZipEntry)object).isDirectory()) {
                if (file.exists() || file.mkdir()) continue;
                Log.log.warning("Failed to create jar entry path", "jar", zipFile, "entry", object);
                continue;
            }
            Object object2 = new File(file.getParent());
            if (!((File)object2).exists() && !((File)object2).mkdirs()) {
                Log.log.warning("Failed to create jar entry parent", "jar", zipFile, "parent", object2);
                continue;
            }
            try {
                block21: {
                    object2 = new BufferedOutputStream(new FileOutputStream(file));
                    Throwable throwable = null;
                    try {
                        object = zipFile.getInputStream((ZipEntry)object);
                        Throwable throwable2 = null;
                        try {
                            StreamUtil.copy((InputStream)object, object2);
                            if (object == null) break block21;
                        }
                        catch (Throwable throwable3) {
                            try {
                                Throwable throwable4 = throwable3;
                                throwable2 = throwable3;
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                if (object == null) throw throwable5;
                                if (throwable2 == null) {
                                    ((InputStream)object).close();
                                    throw throwable5;
                                }
                                try {
                                    ((InputStream)object).close();
                                    throw throwable5;
                                }
                                catch (Throwable throwable6) {
                                    throwable2.addSuppressed(throwable6);
                                    throw throwable5;
                                }
                            }
                        }
                        ((InputStream)object).close();
                    }
                    catch (Throwable throwable7) {
                        try {
                            object = throwable7;
                            throwable = throwable7;
                            throw object;
                        }
                        catch (Throwable throwable8) {
                            if (throwable == null) {
                                ((FilterOutputStream)object2).close();
                                throw throwable8;
                            }
                            try {
                                ((FilterOutputStream)object2).close();
                                throw throwable8;
                            }
                            catch (Throwable throwable9) {
                                throwable.addSuppressed(throwable9);
                                throw throwable8;
                            }
                        }
                    }
                }
                ((FilterOutputStream)object2).close();
            }
            catch (Exception exception) {
                throw new IOException(Log.format("Failure unpacking", "jar", zipFile, "entry", file), exception);
            }
        }
    }

    public static void copy(File object, File object2) throws IOException {
        object = new FileInputStream((File)object);
        Throwable throwable = null;
        try {
            object2 = new FileOutputStream((File)object2);
            Throwable throwable2 = null;
            try {
                StreamUtil.copy((InputStream)object, object2);
            }
            catch (Throwable throwable3) {
                try {
                    Throwable throwable4 = throwable3;
                    throwable2 = throwable3;
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    if (throwable2 != null) {
                        try {
                            ((FileOutputStream)object2).close();
                        }
                        catch (Throwable throwable6) {
                            throwable2.addSuppressed(throwable6);
                        }
                    } else {
                        ((FileOutputStream)object2).close();
                    }
                    throw throwable5;
                }
            }
            ((FileOutputStream)object2).close();
        }
        catch (Throwable throwable7) {
            try {
                object2 = throwable7;
                throwable = throwable7;
                throw object2;
            }
            catch (Throwable throwable8) {
                if (throwable != null) {
                    try {
                        ((FileInputStream)object).close();
                    }
                    catch (Throwable throwable9) {
                        throwable.addSuppressed(throwable9);
                    }
                } else {
                    ((FileInputStream)object).close();
                }
                throw throwable8;
            }
        }
        ((FileInputStream)object).close();
        return;
    }

    public static void makeExecutable(File file) {
        try {
            if (file.exists() && !file.setExecutable(true, false)) {
                Log.log.warning("Failed to mark as executable", "file", file);
            }
            return;
        }
        catch (Exception exception) {
            Log.log.warning("Failed to mark as executable", "file", file, "error", exception);
            return;
        }
    }

    public static void walkTree(File object, Visitor visitor) {
        if ((object = ((File)object).listFiles()) == null) {
            return;
        }
        object = new ArrayDeque<File>(Arrays.asList(object));
        while (!object.isEmpty()) {
            File[] fileArray = (File[])object.pop();
            if (!fileArray.exists()) continue;
            visitor.visit((File)fileArray);
            if ((fileArray = fileArray.listFiles()) == null) continue;
            for (File file : fileArray) {
                object.push(file);
            }
        }
    }

    public static Set<Path> getFilePathsByGlob(String string, String string2) {
        Object object = string2.replace("\\", "/");
        object = String.format("glob:%s%s%s", string.replace("\\", "/"), ((String)object).startsWith("/") ? "" : "/", object);
        object = FileSystems.getDefault().getPathMatcher((String)object);
        HashSet<Path> hashSet = new HashSet<Path>();
        try {
            Files.walkFileTree(Paths.get(string, new String[0]), new a((PathMatcher)object, hashSet));
        }
        catch (Exception exception) {
            Log.log.warning(String.format("Failed to get file list with path %s with glob %s", string, string2), "error", exception);
            return Collections.emptySet();
        }
        return hashSet;
    }

    public static interface Visitor {
        public void visit(File var1);
    }
}

