package models.contactix;

import java.text.SimpleDateFormat;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import com.avaje.ebean.Model;
import com.fasterxml.jackson.databind.node.ObjectNode;

import play.libs.Json;

@Entity
@Table(name = "addresses")
public class Address extends Model {
	@Id
	public Integer id;

	@Column(name = "created_at")
	public Date createdAt = new Date();
	@Column(name = "updated_at")
	public Date updatedAt = new Date();

	public String location;
	public String street;
	public String pobox;
	public String postalcode;
	public String locality;
	public String region;
	public String country;
	public String delivery;

	@Column(columnDefinition = "tinyint(1) NULL")
	public boolean preferred;

	@ManyToOne
	@JoinColumn(name = "user_id")
	private User user;

	private final static SimpleDateFormat DATETIME_FORMAT = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
	
	public static Finder<Integer, Address> find = new Finder<Integer, Address>("contactix", Integer.class, Address.class);
	
	public void setUser(final User user) {
		this.user = user;
	}

	public User getUser() {
		return this.user;
	}
	
	public String toString(){
		return street+"\n"+postalcode+" "+locality+"\n"+country;
	}
	
	public ObjectNode toJson() {
		ObjectNode result = Json.newObject();
		result.put("id", id);
		result.put("createdAt", DATETIME_FORMAT.format(createdAt));
		result.put("updatedAt", DATETIME_FORMAT.format(updatedAt));
		if(user != null) {
			result.set("user", user.toJson());		
		} 
		result.put("location", location);
		result.put("street", street);
		result.put("pobox", pobox);
		result.put("postalcode", postalcode);
		result.put("locality", locality);
		result.put("region", region);
		result.put("country", country);
		result.put("delivery", delivery);
		result.put("preferred", preferred);
		return result;
	}
}
