package models.contactix;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import com.avaje.ebean.Model;
import com.fasterxml.jackson.databind.node.ObjectNode;

import play.libs.Json;

@Entity
@Table(name = "phone_numbers")
public class PhoneNumber extends Model {
	@Id
	public Integer id;

	@Column(name = "created_at")
	public Date createdAt = new Date();
	@Column(name = "updated_at")
	public Date updatedAt = new Date();

	public String capability;
	public String location;
	public String value;

	@Column(columnDefinition = "tinyint(1) NULL")
	public boolean preferred;

	@ManyToOne
	@JoinColumn(name = "user_id")
	private User user;

	public List<String> getCapabilities(){
		if(capability != null){
			return Arrays.asList(capability.split(","));
		}
		return new ArrayList<String>();
	}
	
	private final static SimpleDateFormat DATETIME_FORMAT = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
	
	public static Finder<Integer, PhoneNumber> find = new Finder<Integer, PhoneNumber>("contactix", PhoneNumber.class);

	public void setUser(final User user) {
		this.user = user;
	}
	
	public String toString() {
		return "(" + location + ")" + value;
	}
	
	public ObjectNode toJson() {
		ObjectNode result = Json.newObject();
		result.put("id", id);
		result.put("createdAt", DATETIME_FORMAT.format(createdAt));
		result.put("updatedAt", DATETIME_FORMAT.format(updatedAt));
		if(user != null) {
			result.set("user", user.toJson());		
		}
		result.put("capability", capability);
		result.put("location", location);
		result.put("value", value);
		return result;
	}
}
