/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.play.metrics;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.json.MetricsModule;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import com.codahale.metrics.logback.InstrumentedAppender;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.concurrent.TimeUnit;
import play.api.Application;
import play.api.Configuration;
import play.api.Logger$;
import play.api.Plugin;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001I4A!\u0001\u0002\u0001\u0017\tiQ*\u001a;sS\u000e\u001c\b\u000b\\;hS:T!a\u0001\u0003\u0002\u000f5,GO]5dg*\u0011QAB\u0001\u0005a2\f\u0017P\u0003\u0002\b\u0011\u000591.\u001a8tQ>|'\"A\u0005\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001a!\u0003\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\t\u0003']i\u0011\u0001\u0006\u0006\u0003+Y\t1!\u00199j\u0015\u0005)\u0011B\u0001\r\u0015\u0005\u0019\u0001F.^4j]\"A!\u0004\u0001BC\u0002\u0013\u00051$A\u0002baB,\u0012\u0001\b\t\u0003'uI!A\b\u000b\u0003\u0017\u0005\u0003\b\u000f\\5dCRLwN\u001c\u0005\tA\u0001\u0011\t\u0011)A\u00059\u0005!\u0011\r\u001d9!\u0011\u0015\u0011\u0003\u0001\"\u0001$\u0003\u0019a\u0014N\\5u}Q\u0011AE\n\t\u0003K\u0001i\u0011A\u0001\u0005\u00065\u0005\u0002\r\u0001\b\u0005\bQ\u0001\u0011\r\u0011\"\u0001*\u0003)1\u0018\r\\5e+:LGo]\u000b\u0002UA\u0019QbK\u0017\n\u00051r!\u0001B*p[\u0016\u00042AL\u001a6\u001b\u0005y#B\u0001\u00192\u0003%IW.\\;uC\ndWM\u0003\u00023\u001d\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005Qz#aA*fiB\u0011agO\u0007\u0002o)\u0011\u0001(O\u0001\u0005Y\u0006twMC\u0001;\u0003\u0011Q\u0017M^1\n\u0005q:$AB*ue&tw\r\u0003\u0004?\u0001\u0001\u0006IAK\u0001\fm\u0006d\u0017\u000eZ+oSR\u001c\b\u0005C\u0004A\u0001\t\u0007I\u0011A!\u0002\r5\f\u0007\u000f]3s+\u0005\u0011\u0005CA\"K\u001b\u0005!%BA#G\u0003!!\u0017\r^1cS:$'BA$I\u0003\u001dQ\u0017mY6t_:T!!\u0013\u0005\u0002\u0013\u0019\f7\u000f^3sq6d\u0017BA&E\u00051y%M[3di6\u000b\u0007\u000f]3s\u0011\u0019i\u0005\u0001)A\u0005\u0005\u00069Q.\u00199qKJ\u0004\u0003\"B(\u0001\t\u0003\u0001\u0016\u0001\u0004:fO&\u001cHO]=OC6,W#A)\u0011\u0005I+fBA\u0007T\u0013\t!f\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003yYS!\u0001\u0016\b\t\u000ba\u0003A1A-\u0002!M$(/\u001b8h)>$\u0016.\\3V]&$HC\u0001.c!\tY\u0006-D\u0001]\u0015\tif,\u0001\u0006d_:\u001cWO\u001d:f]RT!aX\u001d\u0002\tU$\u0018\u000e\\\u0005\u0003Cr\u0013\u0001\u0002V5nKVs\u0017\u000e\u001e\u0005\u0006G^\u0003\r!U\u0001\u0002g\")Q\r\u0001C!M\u00069qN\\*uCJ$H#A4\u0011\u00055A\u0017BA5\u000f\u0005\u0011)f.\u001b;\t\u000b-\u0004A\u0011\t4\u0002\r=t7\u000b^8q\u0011\u0015i\u0007\u0001\"\u0011o\u0003\u001d)g.\u00192mK\u0012,\u0012a\u001c\t\u0003\u001bAL!!\u001d\b\u0003\u000f\t{w\u000e\\3b]\u0002")
public class MetricsPlugin
implements Plugin {
    private final Application app;
    private final Some<Set<String>> validUnits;
    private final ObjectMapper mapper;

    public Application app() {
        return this.app;
    }

    public Some<Set<String>> validUnits() {
        return this.validUnits;
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    public String registryName() {
        Configuration qual$1 = this.app().configuration();
        String x$1 = "metrics.name";
        Option x$2 = qual$1.getString$default$2();
        return (String)qual$1.getString(x$1, x$2).getOrElse((Function0)new Serializable(this){

            public final String apply() {
                return "default";
            }
        });
    }

    public TimeUnit stringToTimeUnit(String s) {
        return TimeUnit.valueOf(s);
    }

    public void onStart() {
        if (this.enabled()) {
            MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)this.registryName());
            String rateUnit = (String)this.app().configuration().getString("metrics.rateUnit", this.validUnits()).getOrElse((Function0)new Serializable(this){

                public final String apply() {
                    return "SECONDS";
                }
            });
            String durationUnit = (String)this.app().configuration().getString("metrics.durationUnit", this.validUnits()).getOrElse((Function0)new Serializable(this){

                public final String apply() {
                    return "SECONDS";
                }
            });
            boolean showSamples = BoxesRunTime.unboxToBoolean((Object)this.app().configuration().getBoolean("metrics.showSamples").getOrElse((Function0)new Serializable(this){

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return false;
                }
            }));
            this.setupJvmMetrics$1(registry);
            this.setupLogbackMetrics$1(registry);
            MetricsModule module = new MetricsModule(this.stringToTimeUnit(rateUnit), this.stringToTimeUnit(durationUnit), showSamples);
            this.mapper().registerModule((Module)module);
        }
    }

    public void onStop() {
        if (this.enabled()) {
            SharedMetricRegistries.remove((String)this.registryName());
        }
    }

    public boolean enabled() {
        return BoxesRunTime.unboxToBoolean((Object)this.app().configuration().getBoolean("metrics.enabled").getOrElse((Function0)new Serializable(this){

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return true;
            }
        }));
    }

    private final void setupJvmMetrics$1(MetricRegistry registry) {
        boolean jvmMetricsEnabled = BoxesRunTime.unboxToBoolean((Object)this.app().configuration().getBoolean("metrics.jvm").getOrElse((Function0)new Serializable(this){

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return true;
            }
        }));
        if (jvmMetricsEnabled) {
            registry.registerAll((MetricSet)new GarbageCollectorMetricSet());
            registry.registerAll((MetricSet)new MemoryUsageGaugeSet());
            registry.registerAll((MetricSet)new ThreadStatesGaugeSet());
        }
    }

    private final void setupLogbackMetrics$1(MetricRegistry registry) {
        boolean logbackEnabled = BoxesRunTime.unboxToBoolean((Object)this.app().configuration().getBoolean("metrics.logback").getOrElse((Function0)new Serializable(this){

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return true;
            }
        }));
        if (logbackEnabled) {
            InstrumentedAppender appender = new InstrumentedAppender(registry);
            Logger logger = (Logger)Logger$.MODULE$.logger();
            appender.setContext((Context)logger.getLoggerContext());
            appender.start();
            logger.addAppender((Appender)appender);
        }
    }

    public MetricsPlugin(Application app) {
        this.app = app;
        Plugin.class.$init$((Plugin)this);
        this.validUnits = new Some((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"NANOSECONDS", "MICROSECONDS", "MILLISECONDS", "SECONDS", "MINUTES", "HOURS", "DAYS"})));
        this.mapper = new ObjectMapper();
    }
}

