/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CircularByteBuffer {
    public static final int DEFAULT_SIZE = 1023;
    protected byte[] buf;
    protected int readPos = 0;
    protected int writePos = 0;
    protected final CircularByteBufferInputStream inputStream = new CircularByteBufferInputStream();
    protected final CircularByteBufferOutputStream outputStream = new CircularByteBufferOutputStream();

    public CircularByteBuffer() {
        this(1023);
    }

    public CircularByteBuffer(int initialCapacity) {
        this.buf = new byte[initialCapacity + 1];
    }

    public void clear() {
        this.writePos = 0;
        this.readPos = 0;
    }

    public int read() {
        int available = this.available();
        if (available < 1) {
            return -1;
        }
        int val = this.buf[this.readPos] & 0xFF;
        this.readPos = (this.readPos + 1) % this.buf.length;
        return val;
    }

    public int read(byte[] out, int offset, int len) {
        int available = this.available();
        if (len > available) {
            len = available;
        } else if (len == 0) {
            return 0;
        }
        if (this.readPos + len < this.buf.length) {
            System.arraycopy(this.buf, this.readPos, out, offset, len);
            this.readPos += len;
        } else {
            int firstLen = this.buf.length - this.readPos;
            int secondLen = len - firstLen;
            System.arraycopy(this.buf, this.readPos, out, offset, firstLen);
            System.arraycopy(this.buf, 0, out, offset + firstLen, secondLen);
            this.readPos = secondLen % this.buf.length;
        }
        return len;
    }

    public int read(byte[] out) {
        return this.read(out, 0, out.length);
    }

    public int write(int i) {
        int free = this.freeCapacity();
        if (free < 1) {
            this.resize(this.totalCapacity() + 1);
        }
        this.buf[this.writePos] = (byte)(i & 0xFF);
        this.writePos = (this.writePos + 1) % this.buf.length;
        return 1;
    }

    public int write(byte[] in, int offset, int len) {
        if (len == 0) {
            return 0;
        }
        int free = this.freeCapacity();
        if (free < len) {
            this.resize(this.totalCapacity() + len);
        }
        if (this.writePos + len < this.buf.length) {
            System.arraycopy(in, offset, this.buf, this.writePos, len);
            this.writePos += len;
        } else {
            int firstLen = this.buf.length - this.writePos;
            int secondLen = len - firstLen;
            System.arraycopy(in, offset, this.buf, this.writePos, firstLen);
            System.arraycopy(in, offset + firstLen, this.buf, 0, secondLen);
            this.writePos = secondLen % this.buf.length;
        }
        return len;
    }

    public long skip(long len) {
        int available = this.available();
        if (len > (long)available) {
            len = available;
        } else if (len == 0L) {
            return 0L;
        }
        if ((long)this.readPos + len < (long)this.buf.length) {
            this.readPos = (int)((long)this.readPos + len);
        } else {
            int firstLen = this.buf.length - this.readPos;
            int secondLen = (int)len - firstLen;
            this.readPos = secondLen % this.buf.length;
        }
        return len;
    }

    public int peek(byte[] out, int offset, int len) {
        int available = this.available();
        if (len > available) {
            len = available;
        } else if (len == 0) {
            return 0;
        }
        if (this.readPos + len < this.buf.length) {
            System.arraycopy(this.buf, this.readPos, out, offset, len);
        } else {
            int firstLen = this.buf.length - this.readPos;
            int secondLen = len - firstLen;
            System.arraycopy(this.buf, this.readPos, out, offset, firstLen);
            System.arraycopy(this.buf, 0, out, offset + firstLen, secondLen);
        }
        return len;
    }

    public int peek(byte[] out) {
        return this.peek(out, 0, out.length);
    }

    public void resize(int newSize) {
        if (newSize < this.available()) {
            throw new IllegalArgumentException("new size too small to hold contents");
        }
        byte[] newBuf = new byte[newSize + 1];
        if (this.writePos >= this.readPos) {
            System.arraycopy(this.buf, this.readPos, newBuf, 0, this.writePos - this.readPos);
        } else {
            System.arraycopy(this.buf, this.readPos, newBuf, 0, this.buf.length - this.readPos);
            System.arraycopy(this.buf, 0, newBuf, this.buf.length - this.readPos, this.writePos);
        }
        int available = this.available();
        this.buf = newBuf;
        this.readPos = 0;
        this.writePos = available;
    }

    public int available() {
        if (this.writePos >= this.readPos) {
            return this.writePos - this.readPos;
        }
        return this.buf.length - (this.readPos - this.writePos);
    }

    public boolean hasAvailable() {
        return this.available() > 0;
    }

    public int totalCapacity() {
        return this.buf.length - 1;
    }

    public int freeCapacity() {
        if (this.writePos >= this.readPos) {
            return this.buf.length - 1 - (this.writePos - this.readPos);
        }
        return this.readPos - this.writePos - 1;
    }

    public CircularByteBufferInputStream getInputStream() {
        return this.inputStream;
    }

    public CircularByteBufferOutputStream getOutputStream() {
        return this.outputStream;
    }

    public class CircularByteBufferOutputStream
    extends OutputStream {
        public void write(int i) throws IOException {
            CircularByteBuffer.this.write(i);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            CircularByteBuffer.this.write(b, off, len);
        }
    }

    public class CircularByteBufferInputStream
    extends InputStream {
        public int available() {
            return CircularByteBuffer.this.available();
        }

        public int read() throws IOException {
            return CircularByteBuffer.this.read();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return CircularByteBuffer.this.read(b, off, len);
        }

        public long skip(long n) {
            return CircularByteBuffer.this.skip(n);
        }

        public boolean markSupported() {
            return false;
        }
    }
}

