/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.internal;

import io.apigee.trireme.core.Utils;
import io.apigee.trireme.core.internal.Charsets;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.DataFormatException;

public class GZipHeader {
    public static final int HEADER_SIZE = 10;
    public static final int TRAILER_SIZE = 8;
    public static final byte MAGIC_1 = 31;
    public static final byte MAGIC_2 = -117;
    public static final byte METHOD_INFLATE = 8;
    public static final byte UNIX = 3;
    public static final byte BEST_COMPRESSION = 2;
    public static final byte FAST_COMPRESSION = 4;
    public static final int FHCRC = 2;
    public static final int FHEXTRA = 4;
    public static final int FNAME = 8;
    public static final int FCOMMENT = 16;
    private int compressionLevel;
    private long timestamp;
    private String fileName;
    private String comment;

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public void setCompressionLevel(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public ByteBuffer store() {
        ByteBuffer nameBuf = this.fileName == null ? null : Utils.stringToBuffer(this.fileName, Charsets.ASCII);
        ByteBuffer commentBuf = this.comment == null ? null : Utils.stringToBuffer(this.comment, Charsets.ASCII);
        ByteBuffer buf = ByteBuffer.allocate(10 + (nameBuf == null ? 0 : nameBuf.remaining() + 1) + (commentBuf == null ? 0 : commentBuf.remaining() + 1));
        buf.put((byte)31);
        buf.put((byte)-117);
        buf.put((byte)8);
        int flags = 0;
        if (nameBuf != null) {
            flags |= 8;
        }
        if (commentBuf != null) {
            flags |= 0x10;
        }
        buf.put((byte)flags);
        GZipHeader.writeUInt32LE(this.timestamp / 1000L, buf);
        if (this.compressionLevel == 9) {
            buf.put((byte)2);
        } else if (this.compressionLevel == 1) {
            buf.put((byte)4);
        } else {
            buf.put((byte)0);
        }
        buf.put((byte)3);
        assert (buf.position() == 10);
        if (nameBuf != null) {
            buf.put(nameBuf);
            buf.put((byte)0);
        }
        if (commentBuf != null) {
            buf.put(commentBuf);
            buf.put((byte)0);
        }
        buf.flip();
        return buf;
    }

    public static Magic peekMagicNumber(ByteBuffer buf) {
        if (buf.remaining() < 2) {
            return Magic.NOT_ENOUGH_DATA;
        }
        if (31 == buf.get(0) && -117 == buf.get(1)) {
            return Magic.GZIP;
        }
        return Magic.UNDEFINED;
    }

    public static GZipHeader load(ByteBuffer buf) throws DataFormatException {
        if (buf.remaining() < 10) {
            return null;
        }
        buf.order(ByteOrder.LITTLE_ENDIAN);
        int oldPos = buf.position();
        GZipHeader hdr = new GZipHeader();
        if (31 != buf.get()) {
            throw new DataFormatException("Incorrect GZip magic number");
        }
        if (-117 != buf.get()) {
            throw new DataFormatException("Incorrect GZip magic number");
        }
        buf.get();
        byte flags = buf.get();
        hdr.setTimestamp(GZipHeader.readUInt32LE(buf) * 1000L);
        buf.get();
        buf.get();
        if ((flags & 4) != 0) {
            if (buf.remaining() < 2) {
                buf.position(oldPos);
                return null;
            }
            int extraLen = GZipHeader.readUInt16LE(buf);
            if (buf.remaining() < extraLen) {
                buf.position(oldPos);
                return null;
            }
            buf.position(buf.position() + extraLen);
        }
        if ((flags & 8) != 0) {
            String name = GZipHeader.readNullTerminatedString(buf);
            if (name == null) {
                buf.position(oldPos);
                return null;
            }
            hdr.setFileName(name);
        }
        if ((flags & 0x10) != 0) {
            String comment = GZipHeader.readNullTerminatedString(buf);
            if (comment == null) {
                buf.position(oldPos);
                return null;
            }
            hdr.setComment(comment);
        }
        if ((flags & 2) != 0) {
            if (buf.remaining() < 2) {
                buf.position(oldPos);
                return null;
            }
            buf.getShort();
        }
        return hdr;
    }

    public static Trailer readGZipTrailer(ByteBuffer buf) throws DataFormatException {
        if (buf.remaining() < 8) {
            throw new DataFormatException("No GZIP trailer");
        }
        Trailer t = new Trailer();
        t.setChecksum(GZipHeader.readUInt32LE(buf));
        t.setLength(GZipHeader.readUInt32LE(buf));
        return t;
    }

    public static ByteBuffer writeGZipTrailer(long checksum, long bytesRead) {
        ByteBuffer b = ByteBuffer.allocate(8);
        GZipHeader.writeUInt32LE(checksum, b);
        GZipHeader.writeUInt32LE(bytesRead, b);
        b.flip();
        return b;
    }

    private static String readNullTerminatedString(ByteBuffer buf) {
        byte b;
        int pos = buf.position();
        do {
            if (pos >= buf.limit()) {
                return null;
            }
            b = buf.get(pos);
            ++pos;
        } while (b != 0);
        ByteBuffer strBuf = buf.duplicate();
        strBuf.limit(pos - 1);
        String ret = Utils.bufferToString(strBuf, Charsets.ASCII);
        buf.position(pos);
        return ret;
    }

    private static void writeUInt32LE(long v, ByteBuffer buf) {
        buf.put((byte)(v & 0xFFL));
        buf.put((byte)(v >>> 8 & 0xFFL));
        buf.put((byte)(v >>> 16 & 0xFFL));
        buf.put((byte)(v >>> 24 & 0xFFL));
    }

    private static void writeUInt16LE(int v, ByteBuffer buf) {
        buf.put((byte)(v & 0xFF));
        buf.put((byte)(v >>> 8 & 0xFF));
    }

    private static long readUInt32LE(ByteBuffer buf) {
        long b1 = (long)buf.get() & 0xFFL;
        long b2 = (long)buf.get() & 0xFFL;
        long b3 = (long)buf.get() & 0xFFL;
        long b4 = (long)buf.get() & 0xFFL;
        return (b1 | b2 << 8 | b3 << 16 | b4 << 24) & 0xFFFFFFFFL;
    }

    private static int readUInt16LE(ByteBuffer buf) {
        int b1 = buf.get() & 0xFF;
        int b2 = buf.get() & 0xFF;
        return (b1 | b2 << 8) & 0xFFFF;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Magic {
        GZIP,
        UNDEFINED,
        NOT_ENOUGH_DATA;

    }

    public static final class Trailer {
        private long length;
        private long checksum;

        public long getLength() {
            return this.length;
        }

        public void setLength(long length) {
            this.length = length;
        }

        public long getChecksum() {
            return this.checksum;
        }

        public void setChecksum(long checksum) {
            this.checksum = checksum;
        }
    }
}

