/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.internal;

import java.security.MessageDigest;
import java.util.Arrays;

public class KeyGenerator {
    public static Key generateKey(MessageDigest digest, byte[] keyData, int keyDataOffset, int keyDataLength, int keyLen, int ivLen, int count) {
        byte[] mdBuf = null;
        int keyI = 0;
        int ivI = 0;
        int nKey = keyLen;
        int nIv = ivLen;
        byte[] key = new byte[keyLen];
        byte[] iv = new byte[ivLen];
        while (nKey > 0 || nIv > 0) {
            int i;
            digest.reset();
            if (mdBuf != null) {
                digest.update(mdBuf);
            }
            digest.update(keyData, keyDataOffset, keyDataLength);
            mdBuf = digest.digest();
            for (i = 1; i < count; ++i) {
                digest.reset();
                digest.update(mdBuf);
                mdBuf = digest.digest();
            }
            for (i = 0; nKey > 0 && i < mdBuf.length; --nKey, ++i) {
                key[keyI] = mdBuf[i];
                ++keyI;
            }
            while (nIv > 0 && i < mdBuf.length) {
                iv[ivI] = mdBuf[i];
                ++ivI;
                --nIv;
                ++i;
            }
        }
        if (mdBuf != null) {
            Arrays.fill(mdBuf, (byte)0);
        }
        return new Key(key, iv);
    }

    public static class Key {
        private byte[] key;
        private byte[] iv;

        Key(byte[] key, byte[] iv) {
            this.key = key;
            this.iv = iv;
        }

        public byte[] getKey() {
            return this.key;
        }

        public byte[] getIv() {
            return this.iv;
        }
    }
}

